/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.ManorData;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.CropProcure;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class ExShowCropSetting
extends L2GameServerPacket {
    private final int _manorId;
    private final int _count;
    private final long[] _cropData;

    public ExShowCropSetting(int manorId) {
        this._manorId = manorId;
        Castle c = CastleManager.getInstance().getCastleById(this._manorId);
        int[] crops = ManorData.getInstance().getCropsForCastle(this._manorId);
        this._count = crops.length;
        this._cropData = new long[this._count * 14];
        for (int i = 0; i < this._count; ++i) {
            int cr = crops[i];
            int dx = i * 14;
            this._cropData[dx + 0] = cr;
            this._cropData[dx + 1] = ManorData.getInstance().getSeedLevelByCrop(cr);
            this._cropData[dx + 2] = ManorData.getInstance().getRewardItem(cr, 1);
            this._cropData[dx + 3] = ManorData.getInstance().getRewardItem(cr, 2);
            this._cropData[dx + 4] = ManorData.getInstance().getCropPuchaseLimit(cr);
            this._cropData[dx + 5] = 0L;
            this._cropData[dx + 6] = ManorData.getInstance().getCropBasicPrice(cr) * 60 / 100;
            this._cropData[dx + 7] = ManorData.getInstance().getCropBasicPrice(cr) * 10;
            CropProcure cropPr = c.getCrop(cr, 0);
            if (cropPr != null) {
                this._cropData[dx + 8] = cropPr.getStartAmount();
                this._cropData[dx + 9] = cropPr.getPrice();
                this._cropData[dx + 10] = cropPr.getReward();
            }
            if ((cropPr = c.getCrop(cr, 1)) == null) continue;
            this._cropData[dx + 11] = cropPr.getStartAmount();
            this._cropData[dx + 12] = cropPr.getPrice();
            this._cropData[dx + 13] = cropPr.getReward();
        }
    }

    @Override
    public void writeImpl() {
        this.writeC(254);
        this.writeH(43);
        this.writeD(this._manorId);
        this.writeD(this._count);
        for (int i = 0; i < this._count; ++i) {
            int dx = i * 14;
            this.writeD((int)this._cropData[dx + 0]);
            this.writeD((int)this._cropData[dx + 1]);
            this.writeC(1);
            this.writeD((int)this._cropData[dx + 2]);
            this.writeC(1);
            this.writeD((int)this._cropData[dx + 3]);
            this.writeD((int)this._cropData[dx + 4]);
            this.writeD((int)this._cropData[dx + 5]);
            this.writeD((int)this._cropData[dx + 6]);
            this.writeD((int)this._cropData[dx + 7]);
            this.writeQ(this._cropData[dx + 8]);
            this.writeQ(this._cropData[dx + 9]);
            this.writeC((int)this._cropData[dx + 10]);
            this.writeQ(this._cropData[dx + 11]);
            this.writeQ(this._cropData[dx + 12]);
            this.writeC((int)this._cropData[dx + 13]);
        }
    }
}

