/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.ExperienceTable;
import com.l2jserver.gameserver.model.CharSelectInfoPackage;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CharSelectionInfo
extends L2GameServerPacket {
    private static Logger _log = Logger.getLogger(CharSelectionInfo.class.getName());
    private final String _loginName;
    private final int _sessionId;
    private int _activeId;
    private final CharSelectInfoPackage[] _characterPackages;

    public CharSelectionInfo(String loginName, int sessionId) {
        this._sessionId = sessionId;
        this._loginName = loginName;
        this._characterPackages = CharSelectionInfo.loadCharacterSelectInfo(this._loginName);
        this._activeId = -1;
    }

    public CharSelectionInfo(String loginName, int sessionId, int activeId) {
        this._sessionId = sessionId;
        this._loginName = loginName;
        this._characterPackages = CharSelectionInfo.loadCharacterSelectInfo(this._loginName);
        this._activeId = activeId;
    }

    public CharSelectInfoPackage[] getCharInfo() {
        return this._characterPackages;
    }

    @Override
    protected final void writeImpl() {
        int i;
        this.writeC(9);
        int size = this._characterPackages.length;
        this.writeD(size);
        this.writeD(Config.MAX_CHARACTERS_NUMBER_PER_ACCOUNT);
        this.writeC(0);
        long lastAccess = 0L;
        if (this._activeId == -1) {
            for (i = 0; i < size; ++i) {
                if (lastAccess >= this._characterPackages[i].getLastAccess()) continue;
                lastAccess = this._characterPackages[i].getLastAccess();
                this._activeId = i;
            }
        }
        for (i = 0; i < size; ++i) {
            CharSelectInfoPackage charInfoPackage = this._characterPackages[i];
            this.writeS(charInfoPackage.getName());
            this.writeD(charInfoPackage.getObjectId());
            this.writeS(this._loginName);
            this.writeD(this._sessionId);
            this.writeD(charInfoPackage.getClanId());
            this.writeD(0);
            this.writeD(charInfoPackage.getSex());
            this.writeD(charInfoPackage.getRace());
            if (charInfoPackage.getClassId() == charInfoPackage.getBaseClassId()) {
                this.writeD(charInfoPackage.getClassId());
            } else {
                this.writeD(charInfoPackage.getBaseClassId());
            }
            this.writeD(1);
            this.writeD(charInfoPackage.getX());
            this.writeD(charInfoPackage.getY());
            this.writeD(charInfoPackage.getZ());
            this.writeF(charInfoPackage.getCurrentHp());
            this.writeF(charInfoPackage.getCurrentMp());
            this.writeD(charInfoPackage.getSp());
            this.writeQ(charInfoPackage.getExp());
            this.writeF((float)(charInfoPackage.getExp() - ExperienceTable.getInstance().getExpForLevel(charInfoPackage.getLevel())) / (float)(ExperienceTable.getInstance().getExpForLevel(charInfoPackage.getLevel() + 1) - ExperienceTable.getInstance().getExpForLevel(charInfoPackage.getLevel())));
            this.writeD(charInfoPackage.getLevel());
            this.writeD(charInfoPackage.getKarma());
            this.writeD(charInfoPackage.getPkKills());
            this.writeD(charInfoPackage.getPvPKills());
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            for (int slot : this.getPaperdollOrder()) {
                this.writeD(charInfoPackage.getPaperdollItemId(slot));
            }
            this.writeD(charInfoPackage.getHairStyle());
            this.writeD(charInfoPackage.getHairColor());
            this.writeD(charInfoPackage.getFace());
            this.writeF(charInfoPackage.getMaxHp());
            this.writeF(charInfoPackage.getMaxMp());
            long deleteTime = charInfoPackage.getDeleteTimer();
            int deletedays = 0;
            if (deleteTime > 0L) {
                deletedays = (int)((deleteTime - System.currentTimeMillis()) / 1000L);
            }
            this.writeD(deletedays);
            this.writeD(charInfoPackage.getClassId());
            this.writeD(i == this._activeId ? 1 : 0);
            this.writeC(charInfoPackage.getEnchantEffect() > 127 ? 127 : charInfoPackage.getEnchantEffect());
            this.writeH(0);
            this.writeH(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeF(0.0);
            this.writeF(0.0);
            this.writeD(charInfoPackage.getVitalityPoints());
        }
    }

    /*
     * Exception decompiling
     */
    private static CharSelectInfoPackage[] loadCharacterSelectInfo(String loginName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void loadCharacterSubclassInfo(CharSelectInfoPackage charInfopackage, int ObjectId, int activeClassId) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT exp, sp, level FROM character_subclasses WHERE charId=? && class_id=? ORDER BY charId");){
            statement.setInt(1, ObjectId);
            statement.setInt(2, activeClassId);
            try (ResultSet charList = statement.executeQuery();){
                if (charList.next()) {
                    charInfopackage.setExp(charList.getLong("exp"));
                    charInfopackage.setSp(charList.getInt("sp"));
                    charInfopackage.setLevel(charList.getInt("level"));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore char subclass info: " + e.getMessage(), e);
        }
    }

    private static CharSelectInfoPackage restoreChar(ResultSet chardata) throws Exception {
        int objectId = chardata.getInt("charId");
        String name = chardata.getString("char_name");
        long deletetime = chardata.getLong("deletetime");
        if (deletetime > 0L && System.currentTimeMillis() > deletetime) {
            L2Clan clan = ClanTable.getInstance().getClan(chardata.getInt("clanid"));
            if (clan != null) {
                clan.removeClanMember(objectId, 0L);
            }
            L2GameClient.deleteCharByObjId(objectId);
            return null;
        }
        CharSelectInfoPackage charInfopackage = new CharSelectInfoPackage(objectId, name);
        charInfopackage.setAccessLevel(chardata.getInt("accesslevel"));
        charInfopackage.setLevel(chardata.getInt("level"));
        charInfopackage.setMaxHp(chardata.getInt("maxhp"));
        charInfopackage.setCurrentHp(chardata.getDouble("curhp"));
        charInfopackage.setMaxMp(chardata.getInt("maxmp"));
        charInfopackage.setCurrentMp(chardata.getDouble("curmp"));
        charInfopackage.setKarma(chardata.getInt("karma"));
        charInfopackage.setPkKills(chardata.getInt("pkkills"));
        charInfopackage.setPvPKills(chardata.getInt("pvpkills"));
        charInfopackage.setFace(chardata.getInt("face"));
        charInfopackage.setHairStyle(chardata.getInt("hairstyle"));
        charInfopackage.setHairColor(chardata.getInt("haircolor"));
        charInfopackage.setSex(chardata.getInt("sex"));
        charInfopackage.setExp(chardata.getLong("exp"));
        charInfopackage.setSp(chardata.getInt("sp"));
        charInfopackage.setVitalityPoints(chardata.getInt("vitality_points"));
        charInfopackage.setClanId(chardata.getInt("clanid"));
        charInfopackage.setRace(chardata.getInt("race"));
        int baseClassId = chardata.getInt("base_class");
        int activeClassId = chardata.getInt("classid");
        charInfopackage.setX(chardata.getInt("x"));
        charInfopackage.setY(chardata.getInt("y"));
        charInfopackage.setZ(chardata.getInt("z"));
        if (Config.L2JMOD_MULTILANG_ENABLE) {
            String lang = chardata.getString("language");
            if (!Config.L2JMOD_MULTILANG_ALLOWED.contains(lang)) {
                lang = Config.L2JMOD_MULTILANG_DEFAULT;
            }
            charInfopackage.setHtmlPrefix("data/lang/" + lang + "/");
        }
        if (baseClassId != activeClassId) {
            CharSelectionInfo.loadCharacterSubclassInfo(charInfopackage, objectId, activeClassId);
        }
        charInfopackage.setClassId(activeClassId);
        int weaponObjId = charInfopackage.getPaperdollObjectId(5);
        if (weaponObjId < 1) {
            weaponObjId = charInfopackage.getPaperdollObjectId(5);
        }
        if (weaponObjId > 0) {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement statement = con.prepareStatement("SELECT augAttributes FROM item_attributes WHERE itemId=?");){
                statement.setInt(1, weaponObjId);
                try (ResultSet result = statement.executeQuery();){
                    if (result.next()) {
                        int augment = result.getInt("augAttributes");
                        charInfopackage.setAugmentationId(augment == -1 ? 0 : augment);
                    }
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not restore augmentation info: " + e.getMessage(), e);
            }
        }
        if (baseClassId == 0 && activeClassId > 0) {
            charInfopackage.setBaseClassId(activeClassId);
        } else {
            charInfopackage.setBaseClassId(baseClassId);
        }
        charInfopackage.setDeleteTimer(deletetime);
        charInfopackage.setLastAccess(chardata.getLong("lastAccess"));
        return charInfopackage;
    }
}

