/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.BuyListData;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.buylist.L2BuyList;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExBuySellList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.util.Util;

public final class RequestRefundItem
extends L2GameClientPacket {
    private static final String _C__D0_75_REQUESTREFUNDITEM = "[C] D0:75 RequestRefundItem";
    private static final int BATCH_LENGTH = 4;
    private int _listId;
    private int[] _items = null;

    @Override
    protected void readImpl() {
        this._listId = this.readD();
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 4 != this._buf.remaining()) {
            return;
        }
        this._items = new int[count];
        for (int i = 0; i < count; ++i) {
            this._items[i] = this.readD();
        }
    }

    @Override
    protected void runImpl() {
        int i;
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("refund")) {
            player.sendMessage("You are using refund too fast.");
            return;
        }
        if (this._items == null) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!player.hasRefund()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2Object target = player.getTarget();
        if (!(player.isGM() || target != null && target instanceof L2MerchantInstance && player.getInstanceId() == target.getInstanceId() && player.isInsideRadius(target, 150, true, false))) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2Character merchant = null;
        if (target instanceof L2MerchantInstance) {
            merchant = (L2Character)target;
        } else if (!player.isGM()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (merchant == null) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2BuyList buyList = BuyListData.getInstance().getBuyList(this._listId);
        if (buyList == null) {
            Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false BuyList list_id " + this._listId, Config.DEFAULT_PUNISH);
            return;
        }
        if (!buyList.isNpcAllowed(merchant.getId())) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        long weight = 0L;
        long adena = 0L;
        long slots = 0L;
        L2ItemInstance[] refund = player.getRefund().getItems();
        int[] objectIds = new int[this._items.length];
        for (i = 0; i < this._items.length; ++i) {
            int idx = this._items[i];
            if (idx < 0 || idx >= refund.length) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent invalid refund index", Config.DEFAULT_PUNISH);
                return;
            }
            for (int j = i + 1; j < this._items.length; ++j) {
                if (idx != this._items[j]) continue;
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent duplicate refund index", Config.DEFAULT_PUNISH);
                return;
            }
            L2ItemInstance item = refund[idx];
            L2Item template = item.getItem();
            objectIds[i] = item.getObjectId();
            for (int j = 0; j < i; ++j) {
                if (objectIds[i] != objectIds[j]) continue;
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " has duplicate items in refund list", Config.DEFAULT_PUNISH);
                return;
            }
            long count = item.getCount();
            weight += count * (long)template.getWeight();
            adena += count * (long)template.getReferencePrice() / 2L;
            if (!template.isStackable()) {
                slots += count;
                continue;
            }
            if (player.getInventory().getItemByItemId(template.getId()) != null) continue;
            ++slots;
        }
        if (weight > Integer.MAX_VALUE || weight < 0L || !player.getInventory().validateWeight((int)weight)) {
            player.sendPacket(SystemMessageId.WEIGHT_LIMIT_EXCEEDED);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (slots > Integer.MAX_VALUE || slots < 0L || !player.getInventory().validateCapacity((int)slots)) {
            player.sendPacket(SystemMessageId.SLOTS_FULL);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (adena < 0L || !player.reduceAdena("Refund", adena, player.getLastFolkNPC(), false)) {
            player.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        for (i = 0; i < this._items.length; ++i) {
            L2ItemInstance item = player.getRefund().transferItem("Refund", objectIds[i], Long.MAX_VALUE, player.getInventory(), player, player.getLastFolkNPC());
            if (item != null) continue;
            _log.warning("Error refunding object for char " + player.getName() + " (newitem == null)");
        }
        StatusUpdate su = new StatusUpdate(player);
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(su);
        player.sendPacket(new ExBuySellList(player, true));
    }

    @Override
    public String getType() {
        return _C__D0_75_REQUESTREFUNDITEM;
    }
}

