/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.targets.L2TargetType;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;

public final class RequestMagicSkillUse
extends L2GameClientPacket {
    private static final String _C__39_REQUESTMAGICSKILLUSE = "[C] 39 RequestMagicSkillUse";
    private int _magicId;
    private boolean _ctrlPressed;
    private boolean _shiftPressed;

    @Override
    protected void readImpl() {
        this._magicId = this.readD();
        this._ctrlPressed = this.readD() != 0;
        this._shiftPressed = this.readC() != 0;
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = this.getActiveChar();
        if (activeChar == null) {
            return;
        }
        Skill skill = activeChar.getKnownSkill(this._magicId);
        if (skill == null && (skill = activeChar.getCustomSkill(this._magicId)) == null) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            _log.warning("Skill Id " + this._magicId + " not found in player!");
            return;
        }
        if (activeChar.isPlayable() && activeChar.isInAirShip()) {
            activeChar.sendPacket(SystemMessageId.ACTION_PROHIBITED_WHILE_MOUNTED_OR_ON_AN_AIRSHIP);
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if ((activeChar.isTransformed() || activeChar.isInStance()) && !activeChar.hasTransformSkill(skill.getId())) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!Config.ALT_GAME_KARMA_PLAYER_CAN_TELEPORT && activeChar.getKarma() > 0 && skill.hasEffectType(L2EffectType.TELEPORT)) {
            return;
        }
        if (skill.isToggle() && activeChar.isMounted()) {
            return;
        }
        activeChar.useMagic(skill, this._ctrlPressed, this._shiftPressed);
        if (!(!skill.isContinuous() || skill.isDebuff() || skill.getTargetType() != L2TargetType.SELF || activeChar.isInAirShip() && activeChar.isInBoat())) {
            activeChar.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, activeChar.getLocation());
        }
    }

    @Override
    public String getType() {
        return _C__39_REQUESTMAGICSKILLUSE;
    }
}

