/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.BuyListData;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.buylist.L2BuyList;
import com.l2jserver.gameserver.model.buylist.Product;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExBuySellList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;
import java.util.List;

public final class RequestBuyItem
extends L2GameClientPacket {
    private static final String _C__40_REQUESTBUYITEM = "[C] 40 RequestBuyItem";
    private static final int BATCH_LENGTH = 12;
    private int _listId;
    private List<ItemHolder> _items = null;

    @Override
    protected void readImpl() {
        this._listId = this.readD();
        int size = this.readD();
        if (size <= 0 || size > Config.MAX_ITEM_IN_PACKET || size * 12 != this._buf.remaining()) {
            return;
        }
        this._items = new ArrayList<ItemHolder>(size);
        for (int i = 0; i < size; ++i) {
            int itemId = this.readD();
            long count = this.readQ();
            if (itemId < 1 || count < 1L) {
                this._items = null;
                return;
            }
            this._items.add(new ItemHolder(itemId, count));
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("buy")) {
            player.sendMessage("You are buying too fast.");
            return;
        }
        if (this._items == null) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!Config.ALT_GAME_KARMA_PLAYER_CAN_SHOP && player.getKarma() > 0) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2Object target = player.getTarget();
        L2Character merchant = null;
        if (!player.isGM()) {
            if (!(target instanceof L2MerchantInstance) || !player.isInsideRadius(target, 150, true, false) || player.getInstanceId() != target.getInstanceId()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            merchant = (L2Character)target;
        }
        double castleTaxRate = 0.0;
        double baseTaxRate = 0.0;
        if (merchant == null && !player.isGM()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2BuyList buyList = BuyListData.getInstance().getBuyList(this._listId);
        if (buyList == null) {
            Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false BuyList list_id " + this._listId, Config.DEFAULT_PUNISH);
            return;
        }
        if (merchant != null) {
            if (!buyList.isNpcAllowed(merchant.getId())) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (merchant instanceof L2MerchantInstance) {
                castleTaxRate = ((L2MerchantInstance)merchant).getMpc().getCastleTaxRate();
                baseTaxRate = ((L2MerchantInstance)merchant).getMpc().getBaseTaxRate();
            } else {
                baseTaxRate = 0.5;
            }
        }
        long subTotal = 0L;
        long slots = 0L;
        long weight = 0L;
        for (ItemHolder i : this._items) {
            long price = -1L;
            Product product = buyList.getProductByItemId(i.getId());
            if (product == null) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false BuyList list_id " + this._listId + " and item_id " + i.getId(), Config.DEFAULT_PUNISH);
                return;
            }
            if (!product.getItem().isStackable() && i.getCount() > 1L) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to purchase invalid quantity of items at the same time.", Config.DEFAULT_PUNISH);
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_EXCEEDED_QUANTITY_THAT_CAN_BE_INPUTTED);
                this.sendPacket(sm);
                sm = null;
                return;
            }
            price = product.getPrice();
            if (product.getItemId() >= 3960 && product.getItemId() <= 4026) {
                price = (long)((float)price * Config.RATE_SIEGE_GUARDS_PRICE);
            }
            if (price < 0L) {
                _log.warning("ERROR, no price found .. wrong buylist ??");
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (price == 0L && !player.isGM() && Config.ONLY_GM_ITEMS_FREE) {
                player.sendMessage("Ohh Cheat dont work? You have a problem now!");
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried buy item for 0 adena.", Config.DEFAULT_PUNISH);
                return;
            }
            if (product.hasLimitedStock() && i.getCount() > product.getCount()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (Inventory.MAX_ADENA / i.getCount() < price) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to purchase over " + Inventory.MAX_ADENA + " adena worth of goods.", Config.DEFAULT_PUNISH);
                return;
            }
            price = (long)((double)price * (1.0 + castleTaxRate + baseTaxRate));
            if ((subTotal += i.getCount() * price) > Inventory.MAX_ADENA) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to purchase over " + Inventory.MAX_ADENA + " adena worth of goods.", Config.DEFAULT_PUNISH);
                return;
            }
            weight += i.getCount() * (long)product.getItem().getWeight();
            if (player.getInventory().getItemByItemId(product.getItemId()) != null) continue;
            ++slots;
        }
        if (!(player.isGM() || weight <= Integer.MAX_VALUE && weight >= 0L && player.getInventory().validateWeight((int)weight))) {
            player.sendPacket(SystemMessageId.WEIGHT_LIMIT_EXCEEDED);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!(player.isGM() || slots <= Integer.MAX_VALUE && slots >= 0L && player.getInventory().validateCapacity((int)slots))) {
            player.sendPacket(SystemMessageId.SLOTS_FULL);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (subTotal < 0L || !player.reduceAdena("Buy", subTotal, player.getLastFolkNPC(), false)) {
            player.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        for (ItemHolder i : this._items) {
            Product product = buyList.getProductByItemId(i.getId());
            if (product == null) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false BuyList list_id " + this._listId + " and item_id " + i.getId(), Config.DEFAULT_PUNISH);
                continue;
            }
            if (product.hasLimitedStock()) {
                if (!product.decreaseCount(i.getCount())) continue;
                player.getInventory().addItem("Buy", i.getId(), i.getCount(), player, merchant);
                continue;
            }
            player.getInventory().addItem("Buy", i.getId(), i.getCount(), player, merchant);
        }
        if (merchant instanceof L2MerchantInstance) {
            ((L2MerchantInstance)merchant).getCastle().addToTreasury((long)((double)subTotal * castleTaxRate));
        }
        StatusUpdate su = new StatusUpdate(player);
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(su);
        player.sendPacket(new ExBuySellList(player, true));
    }

    @Override
    public String getType() {
        return _C__40_REQUESTBUYITEM;
    }
}

