/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.zone.L2ZoneRespawn;
import com.l2jserver.gameserver.model.zone.ZoneId;

public class L2ResidenceTeleportZone
extends L2ZoneRespawn {
    private int _residenceId;

    public L2ResidenceTeleportZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("residenceId")) {
            this._residenceId = Integer.parseInt(value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        character.setInsideZone(ZoneId.NO_SUMMON_FRIEND, true);
    }

    @Override
    protected void onExit(L2Character character) {
        character.setInsideZone(ZoneId.NO_SUMMON_FRIEND, false);
    }

    public void oustAllPlayers() {
        for (L2PcInstance player : this.getPlayersInside()) {
            if (player == null || !player.isOnline()) continue;
            player.teleToLocation((ILocational)this.getSpawnLoc(), 200);
        }
    }

    public int getResidenceId() {
        return this._residenceId;
    }
}

