/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.GameServer;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.ZoneId;

public class L2NoRestartZone
extends L2ZoneType {
    private int _restartAllowedTime = 0;
    private int _restartTime = 0;
    private boolean _enabled = true;

    public L2NoRestartZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equalsIgnoreCase("default_enabled")) {
            this._enabled = Boolean.parseBoolean(value);
        } else if (name.equalsIgnoreCase("restartAllowedTime")) {
            this._restartAllowedTime = Integer.parseInt(value) * 1000;
        } else if (name.equalsIgnoreCase("restartTime")) {
            this._restartTime = Integer.parseInt(value) * 1000;
        } else if (!name.equalsIgnoreCase("instanceId")) {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        if (!this._enabled) {
            return;
        }
        if (character.isPlayer()) {
            character.setInsideZone(ZoneId.NO_RESTART, true);
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (!this._enabled) {
            return;
        }
        if (character.isPlayer()) {
            character.setInsideZone(ZoneId.NO_RESTART, false);
        }
    }

    @Override
    public void onPlayerLoginInside(L2PcInstance player) {
        if (!this._enabled) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - player.getLastAccess() > (long)this.getRestartTime() && now - GameServer.gameServer.serverLoadEnd > (long)this.getRestartAllowedTime()) {
            player.teleToLocation(TeleportWhereType.TOWN);
        }
    }

    public int getRestartAllowedTime() {
        return this._restartAllowedTime;
    }

    public void setRestartAllowedTime(int time) {
        this._restartAllowedTime = time;
    }

    public int getRestartTime() {
        return this._restartTime;
    }

    public void setRestartTime(int time) {
        this._restartTime = time;
    }
}

