/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.GameServer;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.AbstractZoneSettings;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.util.FastIntSet;
import javolution.util.FastList;
import jp.sf.l2j.troja.FastIntObjectMap;

public class L2BossZone
extends L2ZoneType {
    private int _timeServerDown = 0;
    private int _timeClientDown = 0;
    final Location _oustLoc = new Location(0, 0, 0, 0, -1);

    void oustPlayer(L2PcInstance player) {
        if (this._oustLoc.getX() != 0 && this._oustLoc.getY() != 0 && this._oustLoc.getZ() != 0) {
            player.teleToLocation(this._oustLoc);
        } else {
            player.teleToLocation(TeleportWhereType.TOWN);
        }
    }

    public L2BossZone(int id) {
        super(id);
        AbstractZoneSettings settings = ZoneManager.getSettings(this.getName());
        if (settings == null) {
            settings = new Settings();
        }
        this.setSettings(settings);
        GrandBossManager.getInstance().addZone(this);
    }

    @Override
    public Settings getSettings() {
        return (Settings)super.getSettings();
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("serverDownTime")) {
            this._timeServerDown = Integer.parseInt(value);
        } else if (name.equals("clientDownTime")) {
            this._timeClientDown = Integer.parseInt(value);
        } else if (name.equals("InvadeTime")) {
            if (this._timeServerDown == 0 && this._timeClientDown == 0) {
                this._timeServerDown = Integer.parseInt(value);
            }
        } else if (name.equals("oustX")) {
            this._oustLoc.setX(Integer.parseInt(value));
        } else if (name.equals("oustY")) {
            this._oustLoc.setY(Integer.parseInt(value));
        } else if (name.equals("oustZ")) {
            this._oustLoc.setZ(Integer.parseInt(value));
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        if (this.isEnabled()) {
            if (character.isPlayer()) {
                L2PcInstance player = character.getActingPlayer();
                if (player.canOverrideCond(PcCondOverride.ZONE_CONDITIONS)) {
                    return;
                }
                if (this.getSettings().getPlayersAllowed().contains(player.getObjectId())) {
                    Long expirationTime = (Long)this.getSettings().getPlayerAllowedReEntryTimes().get(player.getObjectId());
                    if (expirationTime == null) {
                        long serverStartTime = GameServer.gameServer.serverLoadEnd;
                        if (serverStartTime > System.currentTimeMillis() - (long)this._timeServerDown) {
                            return;
                        }
                    } else {
                        this.getSettings().getPlayerAllowedReEntryTimes().remove(player.getObjectId());
                        if (expirationTime > System.currentTimeMillis()) {
                            return;
                        }
                    }
                    this.getSettings().getPlayersAllowed().remove(player.getObjectId());
                }
                this.oustPlayer(player);
            } else if (character.isSummon()) {
                L2PcInstance player = character.getActingPlayer();
                if (player != null) {
                    if (this.getSettings().getPlayersAllowed().contains(player.getObjectId()) || player.canOverrideCond(PcCondOverride.ZONE_CONDITIONS)) {
                        return;
                    }
                    this.oustPlayer(player);
                }
                ((L2Summon)character).unSummon(player);
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (this.isEnabled()) {
            if (character.isPlayer()) {
                L2PcInstance player = character.getActingPlayer();
                if (player.canOverrideCond(PcCondOverride.ZONE_CONDITIONS)) {
                    return;
                }
                if (!player.isOnline() && this.getSettings().getPlayersAllowed().contains(player.getObjectId())) {
                    this.getSettings().getPlayerAllowedReEntryTimes().put(player.getObjectId(), (Object)(System.currentTimeMillis() + (long)this._timeClientDown));
                } else {
                    this.getSettings().getPlayersAllowed().remove(player.getObjectId());
                    this.getSettings().getPlayerAllowedReEntryTimes().remove(player.getObjectId());
                }
            }
            if (character.isPlayable() && this.getCharactersInside() != null && !this.getCharactersInside().isEmpty()) {
                this.getSettings().getRaidList().clear();
                int count = 0;
                for (L2Character obj : this.getCharactersInside()) {
                    if (obj == null) continue;
                    if (obj.isPlayable()) {
                        ++count;
                        continue;
                    }
                    if (!obj.isAttackable() || !obj.isRaid()) continue;
                    this.getSettings().getRaidList().add((Object)obj);
                }
                if (count == 0 && !this.getSettings().getRaidList().isEmpty()) {
                    for (int i = 0; i < this.getSettings().getRaidList().size(); ++i) {
                        L2Attackable raid = (L2Attackable)this.getSettings().getRaidList().get(i);
                        if (raid == null || raid.getSpawn() == null || raid.isDead() || raid.isInsideRadius(raid.getSpawn(), 150, false, false)) continue;
                        raid.returnHome();
                    }
                }
            }
        }
        if (character.isAttackable() && character.isRaid() && !character.isDead()) {
            ((L2Attackable)character).returnHome();
        }
    }

    @Deprecated
    public boolean isZoneEnabled() {
        return this.isEnabled();
    }

    public void setZoneDisable() {
        super.setEnabled(false);
    }

    public void setZoneEnable() {
        super.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean flag) {
        if (this.isEnabled() != flag) {
            this.oustAllPlayers();
        }
        super.setEnabled(flag);
    }

    public void setAllowedPlayers(FastIntSet players) {
        if (players != null) {
            this.getSettings().getPlayersAllowed().clear();
            this.getSettings().getPlayersAllowed().addAll(players.iterator());
        }
    }

    public FastIntSet getAllowedPlayers() {
        return this.getSettings().getPlayersAllowed();
    }

    public boolean isPlayerAllowed(L2PcInstance player) {
        if (player.canOverrideCond(PcCondOverride.ZONE_CONDITIONS)) {
            return true;
        }
        if (this.getSettings().getPlayersAllowed().contains(player.getObjectId())) {
            return true;
        }
        this.oustPlayer(player);
        return false;
    }

    public void movePlayersTo(Location loc) {
        if (this._characterList.isEmpty()) {
            return;
        }
        for (L2Character character : this.getCharactersInside()) {
            L2PcInstance player;
            if (character == null || !character.isPlayer() || !(player = character.getActingPlayer()).isOnline()) continue;
            player.teleToLocation(loc);
        }
    }

    public void oustAllPlayers() {
        if (this._characterList.isEmpty()) {
            return;
        }
        for (L2Character character : this.getCharactersInside()) {
            L2PcInstance player;
            if (character == null || !character.isPlayer() || !(player = character.getActingPlayer()).isOnline()) continue;
            this.oustPlayer(player);
        }
        this.getSettings().getPlayerAllowedReEntryTimes().clear();
        this.getSettings().getPlayersAllowed().clear();
    }

    public void allowPlayerEntry(L2PcInstance player, int durationInSec) {
        if (!player.canOverrideCond(PcCondOverride.ZONE_CONDITIONS)) {
            int id = player.getObjectId();
            this.getSettings().getPlayersAllowed().add(id);
            this.getSettings().getPlayerAllowedReEntryTimes().put(id, (Object)(System.currentTimeMillis() + (long)(durationInSec * 1000)));
        }
    }

    public void removePlayer(L2PcInstance player) {
        if (!player.canOverrideCond(PcCondOverride.ZONE_CONDITIONS)) {
            int id = player.getObjectId();
            this.getSettings().getPlayersAllowed().remove(id);
            this.getSettings().getPlayerAllowedReEntryTimes().remove(id);
        }
    }

    public void updateKnownList(L2Npc npc) {
        if (this._characterList == null || this._characterList.isEmpty()) {
            return;
        }
        FastIntObjectMap<L2PcInstance> npcKnownPlayers = npc.getKnownList().getKnownPlayers();
        for (L2Character character : this.getCharactersInside()) {
            L2PcInstance player;
            if (character == null || !character.isPlayer() || !(player = character.getActingPlayer()).isOnline()) continue;
            npcKnownPlayers.put(player.getObjectId(), (Object)player);
        }
    }

    public void checkAnnihilated(L2PcInstance pc) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.isPlayersAnnihilated()) {
            ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

                @Override
                public void run() {
                    L2BossZone.this.oustAllPlayers();
                }
            }, 10000L);
        }
    }

    private synchronized boolean isPlayersAnnihilated() {
        if (this._characterList == null) {
            return false;
        }
        for (L2Character character : this.getCharactersInside()) {
            L2PcInstance player;
            if (!(character instanceof L2PcInstance) || (player = (L2PcInstance)character).isDead() || !player.isOnline()) continue;
            return false;
        }
        return true;
    }

    private final class Settings
    extends AbstractZoneSettings {
        private final FastIntObjectMap<Long> _playerAllowedReEntryTimes = new FastIntObjectMap();
        private final FastIntSet _playersAllowed = new FastIntSet();
        private final FastList<L2Character> _raidList = new FastList();

        public FastIntObjectMap<Long> getPlayerAllowedReEntryTimes() {
            return this._playerAllowedReEntryTimes;
        }

        public FastIntSet getPlayersAllowed() {
            return this._playersAllowed;
        }

        public FastList<L2Character> getRaidList() {
            return this._raidList;
        }

        @Override
        public void clear() {
            this._playerAllowedReEntryTimes.clear();
            this._playersAllowed.clear();
            this._raidList.clear();
        }
    }
}

