/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.quest;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.enums.QuestSound;
import com.l2jserver.gameserver.enums.QuestType;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestTimer;
import com.l2jserver.gameserver.network.serverpackets.ExShowQuestMark;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.network.serverpackets.QuestList;
import com.l2jserver.gameserver.network.serverpackets.TutorialCloseHtml;
import com.l2jserver.gameserver.network.serverpackets.TutorialEnableClientEvent;
import com.l2jserver.gameserver.network.serverpackets.TutorialShowHtml;
import com.l2jserver.gameserver.network.serverpackets.TutorialShowQuestionMark;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class QuestState {
    protected static final Logger _log = Logger.getLogger(QuestState.class.getName());
    private final String _questName;
    private final L2PcInstance _player;
    private byte _state;
    private Map<String, String> _vars;
    private boolean _isExitQuestOnCleanUp = false;

    public QuestState(Quest quest, L2PcInstance player, byte state) {
        this._questName = quest.getName();
        this._player = player;
        this._state = state;
        player.setQuestState(this);
    }

    public String getQuestName() {
        return this._questName;
    }

    public Quest getQuest() {
        return QuestManager.getInstance().getQuest(this._questName);
    }

    public L2PcInstance getPlayer() {
        return this._player;
    }

    public byte getState() {
        return this._state;
    }

    public boolean isCreated() {
        return this._state == 0;
    }

    public boolean isStarted() {
        return this._state == 1;
    }

    public boolean isCompleted() {
        return this._state == 2;
    }

    public boolean setState(byte state) {
        return this.setState(state, true);
    }

    public boolean setState(byte state, boolean saveInDb) {
        if (this._state == state) {
            return false;
        }
        boolean newQuest = this.isCreated();
        this._state = state;
        if (saveInDb) {
            if (newQuest) {
                Quest.createQuestInDb(this);
            } else {
                Quest.updateQuestInDb(this);
            }
        }
        this._player.sendPacket(new QuestList());
        return true;
    }

    public String setInternal(String var, String val) {
        if (this._vars == null) {
            this._vars = new HashMap<String, String>();
        }
        if (val == null) {
            val = "";
        }
        this._vars.put(var, val);
        return val;
    }

    public String set(String var, int val) {
        return this.set(var, Integer.toString(val));
    }

    public String set(String var, String val) {
        String old;
        if (this._vars == null) {
            this._vars = new HashMap<String, String>();
        }
        if (val == null) {
            val = "";
        }
        if ((old = this._vars.put(var, val)) != null) {
            Quest.updateQuestVarInDb(this, var, val);
        } else {
            Quest.createQuestVarInDb(this, var, val);
        }
        if ("cond".equals(var)) {
            try {
                int previousVal = 0;
                try {
                    previousVal = Integer.parseInt(old);
                }
                catch (Exception ex) {
                    previousVal = 0;
                }
                this.setCond(Integer.parseInt(val), previousVal);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, this._player.getName() + ", " + this.getQuestName() + " cond [" + val + "] is not an integer.  Value stored, but no packet was sent: " + e.getMessage(), e);
            }
        }
        return val;
    }

    private void setCond(int cond, int old) {
        if (cond == old) {
            return;
        }
        int completedStateFlags = 0;
        if (cond < 3 || cond > 31) {
            this.unset("__compltdStateFlags");
        } else {
            completedStateFlags = this.getInt("__compltdStateFlags");
        }
        if (completedStateFlags == 0) {
            if (cond > old + 1) {
                completedStateFlags = -2147483647;
                completedStateFlags |= (1 << old) - 1;
                this.set("__compltdStateFlags", String.valueOf(completedStateFlags |= 1 << cond - 1));
            }
        } else if (cond < old) {
            if ((completedStateFlags &= (1 << cond) - 1) == (1 << cond) - 1) {
                this.unset("__compltdStateFlags");
            } else {
                this.set("__compltdStateFlags", String.valueOf(completedStateFlags |= 0x80000001));
            }
        } else {
            this.set("__compltdStateFlags", String.valueOf(completedStateFlags |= 1 << cond - 1));
        }
        this._player.sendPacket(new QuestList());
        Quest q = this.getQuest();
        if (q.isQuests() && cond > 0) {
            this._player.sendPacket(new ExShowQuestMark(q.getId()));
        }
    }

    public String unset(String var) {
        if (this._vars == null) {
            return null;
        }
        String old = this._vars.remove(var);
        if (old != null) {
            Quest.deleteQuestVarInDb(this, var);
        }
        return old;
    }

    public final void saveGlobalQuestVar(String var, String value) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("REPLACE INTO character_quest_global_data (charId, var, value) VALUES (?, ?, ?)");){
            statement.setInt(1, this._player.getObjectId());
            statement.setString(2, var);
            statement.setString(3, value);
            statement.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not insert player's global quest variable: " + e.getMessage(), e);
        }
    }

    public final String getGlobalQuestVar(String var) {
        String result = "";
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT value FROM character_quest_global_data WHERE charId = ? AND var = ?");){
            ps.setInt(1, this._player.getObjectId());
            ps.setString(2, var);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.first()) {
                    result = rs.getString(1);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not load player's global quest variable: " + e.getMessage(), e);
        }
        return result;
    }

    public final void deleteGlobalQuestVar(String var) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("DELETE FROM character_quest_global_data WHERE charId = ? AND var = ?");){
            statement.setInt(1, this._player.getObjectId());
            statement.setString(2, var);
            statement.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not delete player's global quest variable; charId = " + this._player.getObjectId() + ", variable name = " + var + ". Exception: " + e.getMessage(), e);
        }
    }

    public String get(String var) {
        if (this._vars == null) {
            return null;
        }
        return this._vars.get(var);
    }

    public int getInt(String var) {
        if (this._vars == null) {
            return 0;
        }
        String variable = this._vars.get(var);
        if (variable == null || variable.isEmpty()) {
            return 0;
        }
        int varint = 0;
        try {
            varint = Integer.parseInt(variable);
        }
        catch (NumberFormatException nfe) {
            _log.log(Level.INFO, "Quest " + this.getQuestName() + ", method getInt(" + var + "), tried to parse a non-integer value (" + variable + "). Char Id: " + this._player.getObjectId(), nfe);
        }
        return varint;
    }

    public boolean isCond(int condition) {
        return this.getInt("cond") == condition;
    }

    public QuestState setCond(int value) {
        if (this.isStarted()) {
            this.set("cond", Integer.toString(value));
        }
        return this;
    }

    public int getCond() {
        if (this.isStarted()) {
            return this.getInt("cond");
        }
        return 0;
    }

    public boolean isSet(String variable) {
        return this.get(variable) != null;
    }

    public QuestState setCond(int value, boolean playQuestMiddle) {
        if (!this.isStarted()) {
            return this;
        }
        this.set("cond", String.valueOf(value));
        if (playQuestMiddle) {
            Quest.playSound(this._player, QuestSound.ITEMSOUND_QUEST_MIDDLE);
        }
        return this;
    }

    public QuestState setMemoState(int value) {
        this.set("memoState", String.valueOf(value));
        return this;
    }

    public int getMemoState() {
        if (this.isStarted()) {
            return this.getInt("memoState");
        }
        return 0;
    }

    public boolean isMemoState(int memoState) {
        return this.getInt("memoState") == memoState;
    }

    public void addNotifyOfDeath(L2Character character) {
        if (!(character instanceof L2PcInstance)) {
            return;
        }
        ((L2PcInstance)character).addNotifyQuestOfDeath(this);
    }

    public long getQuestItemsCount(int itemId) {
        return Quest.getQuestItemsCount(this._player, itemId);
    }

    public boolean hasQuestItems(int itemId) {
        return Quest.hasQuestItems(this._player, itemId);
    }

    public boolean hasQuestItems(int ... itemIds) {
        return Quest.hasQuestItems(this._player, itemIds);
    }

    public int getEnchantLevel(int itemId) {
        return Quest.getEnchantLevel(this._player, itemId);
    }

    public void giveAdena(long count, boolean applyRates) {
        this.giveItems(57, count, applyRates ? 0 : 1);
    }

    public void rewardItems(ItemHolder item) {
        Quest.rewardItems(this._player, item);
    }

    public void rewardItems(int itemId, long count) {
        Quest.rewardItems(this._player, itemId, count);
    }

    public void giveItems(int itemId, long count) {
        Quest.giveItems(this._player, itemId, count, 0);
    }

    public void giveItems(ItemHolder holder) {
        Quest.giveItems(this._player, holder.getId(), holder.getCount(), 0);
    }

    public void giveItems(int itemId, long count, int enchantlevel) {
        Quest.giveItems(this._player, itemId, count, enchantlevel);
    }

    public void giveItems(int itemId, long count, byte attributeId, int attributeLevel) {
        Quest.giveItems(this._player, itemId, count, attributeId, attributeLevel);
    }

    public boolean giveItemRandomly(int itemId, long amount, long limit, double dropChance, boolean playSound) {
        return Quest.giveItemRandomly(this._player, null, itemId, amount, amount, limit, dropChance, playSound);
    }

    public boolean giveItemRandomly(L2Npc npc, int itemId, long amount, long limit, double dropChance, boolean playSound) {
        return Quest.giveItemRandomly(this._player, npc, itemId, amount, amount, limit, dropChance, playSound);
    }

    public boolean giveItemRandomly(L2Npc npc, int itemId, long minAmount, long maxAmount, long limit, double dropChance, boolean playSound) {
        return Quest.giveItemRandomly(this._player, npc, itemId, minAmount, maxAmount, limit, dropChance, playSound);
    }

    public void addRadar(int x, int y, int z) {
        this._player.getRadar().addMarker(x, y, z);
    }

    public void takeItems(int itemId, long count) {
        Quest.takeItems(this._player, itemId, count);
    }

    public void playSound(String sound) {
        Quest.playSound(this._player, sound);
    }

    public void playSound(QuestSound sound) {
        Quest.playSound(this._player, sound);
    }

    public void addExpAndSp(int exp, int sp) {
        Quest.addExpAndSp(this._player, exp, sp);
    }

    public int getRandom(int max) {
        return Rnd.get(max);
    }

    public int getItemEquipped(int loc) {
        return Quest.getItemEquipped(this._player, loc);
    }

    public final boolean isExitQuestOnCleanUp() {
        return this._isExitQuestOnCleanUp;
    }

    public void setIsExitQuestOnCleanUp(boolean isExitQuestOnCleanUp) {
        this._isExitQuestOnCleanUp = isExitQuestOnCleanUp;
    }

    public void startQuestTimer(String name, long time) {
        this.getQuest().startQuestTimer(name, time, null, this._player, false);
    }

    public void startQuestTimer(String name, long time, L2Npc npc) {
        this.getQuest().startQuestTimer(name, time, npc, this._player, false);
    }

    public void startRepeatingQuestTimer(String name, long time) {
        this.getQuest().startQuestTimer(name, time, null, this._player, true);
    }

    public void startRepeatingQuestTimer(String name, long time, L2Npc npc) {
        this.getQuest().startQuestTimer(name, time, npc, this._player, true);
    }

    public final QuestTimer getQuestTimer(String name) {
        return this.getQuest().getQuestTimer(name, null, this._player);
    }

    public L2Npc addSpawn(int npcId) {
        return this.addSpawn(npcId, this._player.getX(), this._player.getY(), this._player.getZ(), 0, false, 0, false);
    }

    public L2Npc addSpawn(int npcId, int despawnDelay) {
        return this.addSpawn(npcId, this._player.getX(), this._player.getY(), this._player.getZ(), 0, false, despawnDelay, false);
    }

    public L2Npc addSpawn(int npcId, int x, int y, int z) {
        return this.addSpawn(npcId, x, y, z, 0, false, 0, false);
    }

    public L2Npc addSpawn(int npcId, int x, int y, int z, int despawnDelay) {
        return this.addSpawn(npcId, x, y, z, 0, false, despawnDelay, false);
    }

    public L2Npc addSpawn(int npcId, L2Character cha) {
        return this.addSpawn(npcId, cha.getX(), cha.getY(), cha.getZ(), cha.getHeading(), true, 0, false);
    }

    public L2Npc addSpawn(int npcId, L2Character cha, int despawnDelay) {
        return this.addSpawn(npcId, cha.getX(), cha.getY(), cha.getZ(), cha.getHeading(), true, despawnDelay, false);
    }

    public L2Npc addSpawn(int npcId, L2Character cha, boolean randomOffset, int despawnDelay) {
        return this.addSpawn(npcId, cha.getX(), cha.getY(), cha.getZ(), cha.getHeading(), randomOffset, despawnDelay, false);
    }

    public L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, int despawnDelay) {
        return this.addSpawn(npcId, x, y, z, heading, randomOffset, despawnDelay, false);
    }

    public L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, int despawnDelay, boolean isSummonSpawn) {
        return Quest.addSpawn(npcId, x, y, z, heading, randomOffset, despawnDelay, isSummonSpawn);
    }

    public String showHtmlFile(String filename) {
        return this.showHtmlFile(filename, null);
    }

    public String showHtmlFile(String filename, L2Npc npc) {
        return this.getQuest().showHtmlFile(this._player, filename, npc);
    }

    public QuestState startQuest() {
        if (this.isCreated() && this.getQuest().isQuests()) {
            this.set("cond", "1");
            this.setState((byte)1);
            this.playSound(QuestSound.ITEMSOUND_QUEST_ACCEPT);
        }
        return this;
    }

    public QuestState exitQuest(QuestType type) {
        switch (type) {
            case DAILY: {
                this.exitQuest(false);
                this.setRestartTime();
                break;
            }
            case ONE_TIME: {
                this.exitQuest(false);
                break;
            }
            case REPEATABLE: {
                this.exitQuest(true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("exitQuest(" + (Object)((Object)type) + ")");
            }
        }
        return this;
    }

    public QuestState exitQuest(QuestType type, boolean playExitQuest) {
        this.exitQuest(type);
        if (playExitQuest) {
            this.playSound(QuestSound.ITEMSOUND_QUEST_FINISH);
        }
        return this;
    }

    public QuestState exitQuest(boolean repeatable) {
        this._player.removeNotifyQuestOfDeath(this);
        if (!this.isStarted()) {
            return this;
        }
        this.getQuest().removeRegisteredQuestItems(this._player);
        Quest.deleteQuestInDb(this, repeatable);
        if (repeatable) {
            this._player.delQuestState(this.getQuestName());
            this._player.sendPacket(new QuestList());
        } else {
            this.setState((byte)2);
        }
        this._vars = null;
        return this;
    }

    public QuestState exitQuest(boolean repeatable, boolean playExitQuest) {
        this.exitQuest(repeatable);
        if (playExitQuest) {
            this.playSound(QuestSound.ITEMSOUND_QUEST_FINISH);
        }
        return this;
    }

    public void showQuestionMark(int number) {
        this._player.sendPacket(new TutorialShowQuestionMark(number));
    }

    public void playTutorialVoice(String voice) {
        this._player.sendPacket(new PlaySound(2, voice, 0, 0, this._player.getX(), this._player.getY(), this._player.getZ()));
    }

    public void showTutorialHTML(String html) {
        String text = HtmCache.getInstance().getHtm(this._player.getHtmlPrefix(), "data/scripts/quests/255_Tutorial/" + html);
        if (text == null) {
            _log.warning("missing html page data/scripts/quests/255_Tutorial/" + html);
            text = "<html><body>File data/scripts/quests/255_Tutorial/" + html + " not found or file is empty.</body></html>";
        }
        this._player.sendPacket(new TutorialShowHtml(text));
    }

    public void closeTutorialHtml() {
        this._player.sendPacket(TutorialCloseHtml.STATIC_PACKET);
    }

    public void onTutorialClientEvent(int number) {
        this._player.sendPacket(new TutorialEnableClientEvent(number));
    }

    public void setRestartTime() {
        Calendar reDo = Calendar.getInstance();
        if (reDo.get(11) >= this.getQuest().getResetHour()) {
            reDo.add(5, 1);
        }
        reDo.set(11, this.getQuest().getResetHour());
        reDo.set(12, this.getQuest().getResetMinutes());
        this.set("restartTime", String.valueOf(reDo.getTimeInMillis()));
    }

    public boolean isNowAvailable() {
        String val = this.get("restartTime");
        return val == null || !Util.isDigit(val) || Long.parseLong(val) <= System.currentTimeMillis();
    }
}

