/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.olympiad.AbstractOlympiadGame;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameClassed;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameNonClassed;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTask;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTeams;
import com.l2jserver.gameserver.model.olympiad.OlympiadManager;
import com.l2jserver.gameserver.model.zone.type.L2OlympiadStadiumZone;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OlympiadGameManager
implements Runnable {
    private static final Logger _log = Logger.getLogger(OlympiadGameManager.class.getName());
    private volatile boolean _battleStarted = false;
    private final OlympiadGameTask[] _tasks;

    protected OlympiadGameManager() {
        Collection<L2OlympiadStadiumZone> zones = ZoneManager.getInstance().getAllZones(L2OlympiadStadiumZone.class);
        if (zones == null || zones.isEmpty()) {
            throw new Error("No olympiad stadium zones defined !");
        }
        this._tasks = new OlympiadGameTask[zones.size()];
        int i = 0;
        for (L2OlympiadStadiumZone zone : zones) {
            this._tasks[i++] = new OlympiadGameTask(zone);
        }
        _log.log(Level.INFO, "Olympiad System: Loaded " + this._tasks.length + " stadiums.");
    }

    public static final OlympiadGameManager getInstance() {
        return SingletonHolder._instance;
    }

    protected final boolean isBattleStarted() {
        return this._battleStarted;
    }

    protected final void startBattle() {
        this._battleStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (Olympiad.getInstance().isOlympiadEnd()) {
            return;
        }
        if (Olympiad.getInstance().inCompPeriod()) {
            List<List<Integer>> readyClassed = OlympiadManager.getInstance().hasEnoughRegisteredClassed();
            boolean readyNonClassed = OlympiadManager.getInstance().hasEnoughRegisteredNonClassed();
            boolean readyTeams = OlympiadManager.getInstance().hasEnoughRegisteredTeams();
            if (readyClassed != null || readyNonClassed || readyTeams) {
                for (int i = 0; i < this._tasks.length; ++i) {
                    OlympiadGameTask task;
                    OlympiadGameTask olympiadGameTask = task = this._tasks[i];
                    synchronized (olympiadGameTask) {
                        if (!task.isRunning()) {
                            AbstractOlympiadGame newGame;
                            if ((readyClassed != null || readyTeams) && i % 2 == 0) {
                                if (readyTeams && i % 4 == 0) {
                                    newGame = OlympiadGameTeams.createGame(i, OlympiadManager.getInstance().getRegisteredTeamsBased());
                                    if (newGame != null) {
                                        task.attachGame(newGame);
                                        continue;
                                    }
                                    readyTeams = false;
                                }
                                if (readyClassed != null) {
                                    newGame = OlympiadGameClassed.createGame(i, readyClassed);
                                    if (newGame != null) {
                                        task.attachGame(newGame);
                                        continue;
                                    }
                                    readyClassed = null;
                                }
                            }
                            if (readyNonClassed) {
                                newGame = OlympiadGameNonClassed.createGame(i, OlympiadManager.getInstance().getRegisteredNonClassBased());
                                if (newGame != null) {
                                    task.attachGame(newGame);
                                    continue;
                                }
                                readyNonClassed = false;
                            }
                        }
                    }
                    if (readyClassed != null || readyNonClassed || readyTeams) {
                        continue;
                    }
                    break;
                }
            }
        } else if (this.isAllTasksFinished()) {
            OlympiadManager.getInstance().clearRegistered();
            this._battleStarted = false;
            _log.log(Level.INFO, "Olympiad System: All current games finished.");
        }
    }

    public final boolean isAllTasksFinished() {
        for (OlympiadGameTask task : this._tasks) {
            if (!task.isRunning()) continue;
            return false;
        }
        return true;
    }

    public final OlympiadGameTask getOlympiadTask(int id) {
        if (id < 0 || id >= this._tasks.length) {
            return null;
        }
        return this._tasks[id];
    }

    public final int getNumberOfStadiums() {
        return this._tasks.length;
    }

    public final void notifyCompetitorDamage(L2PcInstance player, int damage) {
        if (player == null) {
            return;
        }
        int id = player.getOlympiadGameId();
        if (id < 0 || id >= this._tasks.length) {
            return;
        }
        AbstractOlympiadGame game = this._tasks[id].getGame();
        if (game != null) {
            game.addDamage(player, damage);
        }
    }

    private static class SingletonHolder {
        protected static final OlympiadGameManager _instance = new OlympiadGameManager();

        private SingletonHolder() {
        }
    }
}

