/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.multisell;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.L2Armor;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.multisell.Entry;
import com.l2jserver.gameserver.model.multisell.Ingredient;
import com.l2jserver.gameserver.model.multisell.ListContainer;
import com.l2jserver.gameserver.model.multisell.PreparedEntry;
import java.util.ArrayList;

public class PreparedListContainer
extends ListContainer {
    private int _npcObjectId = 0;

    public PreparedListContainer(ListContainer template, boolean inventoryOnly, L2PcInstance player, L2Npc npc) {
        super(template.getListId());
        this._maintainEnchantment = template.getMaintainEnchantment();
        this._applyTaxes = false;
        double taxRate = 0.0;
        if (npc != null) {
            this._npcObjectId = npc.getObjectId();
            if (template.getApplyTaxes() && npc.getIsInTown() && npc.getCastle().getOwnerId() > 0) {
                this._applyTaxes = true;
                taxRate = npc.getCastle().getTaxRate();
            }
        }
        if (inventoryOnly) {
            if (player == null) {
                return;
            }
            L2ItemInstance[] items = this._maintainEnchantment ? player.getInventory().getUniqueItemsByEnchantLevel(false, false, false) : player.getInventory().getUniqueItems(false, false, false);
            this._entries = new ArrayList();
            for (L2ItemInstance item : items) {
                if (item.isEquipped() || !(item.getItem() instanceof L2Armor) && !(item.getItem() instanceof L2Weapon)) continue;
                block1: for (Entry ent : template.getEntries()) {
                    for (Ingredient ing : ent.getIngredients()) {
                        if (item.getId() != ing.getItemId()) continue;
                        this._entries.add(new PreparedEntry(ent, item, this._applyTaxes, this._maintainEnchantment, taxRate));
                        continue block1;
                    }
                }
            }
        } else {
            this._entries = new ArrayList(template.getEntries().size());
            for (Entry ent : template.getEntries()) {
                this._entries.add(new PreparedEntry(ent, null, this._applyTaxes, false, taxRate));
            }
        }
    }

    public final boolean checkNpcObjectId(int npcObjectId) {
        return this._npcObjectId != 0 ? this._npcObjectId == npcObjectId : true;
    }
}

