/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.items.type;

import com.l2jserver.gameserver.model.items.type.L2ItemType;
import com.l2jserver.gameserver.model.stats.TraitType;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum L2WeaponType implements L2ItemType
{
    SWORD("Sword", TraitType.SWORD),
    BLUNT("Blunt", TraitType.BLUNT),
    DAGGER("Dagger", TraitType.DAGGER),
    BOW("Bow", TraitType.BOW),
    POLE("Pole", TraitType.POLE),
    NONE("None", TraitType.NONE),
    DUAL("Dual Sword", TraitType.DUAL),
    ETC("Etc", TraitType.ETC),
    FIST("Fist", TraitType.FIST),
    DUALFIST("Dual Fist", TraitType.DUALFIST),
    FISHINGROD("Rod", TraitType.NONE),
    RAPIER("Rapier", TraitType.RAPIER),
    ANCIENTSWORD("Ancient", TraitType.ANCIENTSWORD),
    CROSSBOW("Crossbow", TraitType.CROSSBOW),
    FLAG("Flag", TraitType.NONE),
    OWNTHING("Ownthing", TraitType.NONE),
    DUALDAGGER("Dual Dagger", TraitType.DUALDAGGER),
    BIGBLUNT("Big Blunt", TraitType.BLUNT),
    BIGSWORD("Big Sword", TraitType.SWORD);

    private static final Logger _log;
    private final int _mask = 1 << this.ordinal();
    private final String _name;
    private final TraitType _traitType;

    private L2WeaponType(String name, TraitType traitType) {
        this._name = name;
        this._traitType = traitType;
    }

    @Override
    public int mask() {
        return this._mask;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public TraitType getTraitType() {
        return this._traitType;
    }

    public static L2WeaponType findByName(String name) {
        if (name.equalsIgnoreCase("DUAL")) {
            name = "Dual Sword";
        } else if (name.equalsIgnoreCase("DUALFIST")) {
            name = "Dual Fist";
        }
        for (L2WeaponType type : L2WeaponType.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        _log.log(Level.WARNING, L2WeaponType.class.getSimpleName() + ": Requested unexistent enum member: " + name, new IllegalStateException());
        return FIST;
    }

    static {
        _log = Logger.getLogger(L2WeaponType.class.getName());
    }
}

