/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.items;

import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.type.L2ArmorType;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.util.StringUtil;

public final class L2Armor
extends L2Item {
    private SkillHolder _enchant4Skill = null;
    private L2ArmorType _type;

    public L2Armor(StatsSet set) {
        super(set);
        String[] info;
        this._type = L2ArmorType.valueOf(set.getString("armor_type", "none").toUpperCase());
        int _bodyPart = this.getBodyPart();
        if (_bodyPart == 8 || (_bodyPart & 4) != 0 || (_bodyPart & 0x20) != 0 || (_bodyPart & 0x100000) != 0 || (_bodyPart & 0x200000) != 0) {
            this._type1 = 0;
            this._type2 = 2;
        } else {
            if (this._type == L2ArmorType.NONE && this.getBodyPart() == 256) {
                this._type = L2ArmorType.SHIELD;
            }
            this._type1 = 1;
            this._type2 = 1;
        }
        String skill = set.getString("enchant4_skill", null);
        if (skill != null && (info = skill.split("-")) != null && info.length == 2) {
            int id = 0;
            int level = 0;
            try {
                id = Integer.parseInt(info[0]);
                level = Integer.parseInt(info[1]);
            }
            catch (Exception nfe) {
                _log.info(StringUtil.concat("> Couldnt parse ", skill, " in armor enchant skills! item ", this.toString()));
            }
            if (id > 0 && level > 0) {
                this._enchant4Skill = new SkillHolder(id, level);
            }
        }
    }

    @Override
    public L2ArmorType getItemType() {
        return this._type;
    }

    @Override
    public final int getItemMask() {
        return this.getItemType().mask();
    }

    @Override
    public Skill getEnchant4Skill() {
        if (this._enchant4Skill == null) {
            return null;
        }
        return this._enchant4Skill.getSkill();
    }
}

