/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemcontainer;

import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;

public class PetInventory
extends Inventory {
    private final L2PetInstance _owner;

    public PetInventory(L2PetInstance owner) {
        this._owner = owner;
    }

    @Override
    public L2PetInstance getOwner() {
        return this._owner;
    }

    @Override
    public int getOwnerId() {
        int id;
        try {
            id = this._owner.getOwner().getObjectId();
        }
        catch (NullPointerException e) {
            return 0;
        }
        return id;
    }

    @Override
    protected void refreshWeight() {
        super.refreshWeight();
        this.getOwner().updateAndBroadcastStatus(1);
    }

    public boolean validateCapacity(L2ItemInstance item) {
        int slots = 0;
        if (!(item.isStackable() && this.getItemByItemId(item.getId()) != null || item.getItem().hasExImmediateEffect())) {
            ++slots;
        }
        return this.validateCapacity(slots);
    }

    @Override
    public boolean validateCapacity(long slots) {
        return (long)this._items.size() + slots <= (long)this._owner.getInventoryLimit();
    }

    public boolean validateWeight(L2ItemInstance item, long count) {
        int weight = 0;
        L2Item template = ItemTable.getInstance().getTemplate(item.getId());
        if (template == null) {
            return false;
        }
        weight = (int)((long)weight + count * (long)template.getWeight());
        return this.validateWeight(weight);
    }

    @Override
    public boolean validateWeight(long weight) {
        return (long)this._totalWeight + weight <= (long)this._owner.getMaxLoad();
    }

    @Override
    protected ItemLocation getBaseLocation() {
        return ItemLocation.PET;
    }

    @Override
    protected ItemLocation getEquipLocation() {
        return ItemLocation.PET_EQUIP;
    }

    @Override
    public void restore() {
        super.restore();
        for (L2ItemInstance item : this._items) {
            if (!item.isEquipped() || item.getItem().checkCondition(this.getOwner(), this.getOwner(), false)) continue;
            this.unEquipItemInSlot(item.getLocationSlot());
        }
    }

    public void transferItemsToOwner() {
        for (L2ItemInstance item : this._items) {
            this.getOwner().transferItem("return", item.getObjectId(), item.getCount(), this.getOwner().getOwner().getInventory(), this.getOwner().getOwner(), this.getOwner());
        }
    }
}

