/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.event;

import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.EventDroplist;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.script.DateRange;
import com.l2jserver.gameserver.script.EventDrop;
import com.l2jserver.gameserver.script.IntList;
import com.l2jserver.gameserver.script.faenor.FaenorParser;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.gameserver.util.EventNpcAligner;
import com.l2jserver.util.Util;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class LongTimeEvent
extends Quest {
    static final String messageSplitPattern = "(?:\r\n|\n|\r|\\\\n)";
    private String _onEnterMsg = "Event is in process";
    private String _onEndMsg = "Event ends!";
    private DateRange _eventPeriod = null;
    private DateRange _dropPeriod;
    private ArrayList<NpcSpawn> _spawnList;
    private ArrayList<EventDrop> _dropList;

    public LongTimeEvent(String name, String descr) {
        super(-1, name, descr);
        this.loadConfig();
        if (this._eventPeriod != null) {
            Date now = new Date();
            if (now.before(this._eventPeriod.getEndDate())) {
                long delay = this._eventPeriod.getStartDate().getTime() - now.getTime();
                if (delay <= 0L) {
                    _log.info("Event name: (" + this.getName() + ") active till " + Util.dateFormat(this._eventPeriod.getEndDate()));
                } else {
                    _log.info("Event name: (" + this.getName() + ") Date: " + Util.dateFormat(this._eventPeriod.getStartDate()) + " is not active yet... Scheduled.");
                }
                ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

                    @Override
                    public void run() {
                        LongTimeEvent.this.startEvent();
                    }
                }, Math.max(99999L, delay));
            } else {
                _log.info("Event name: (" + this.getName() + ") Date: " + Util.dateFormat(this._eventPeriod.getEndDate()) + " has passed... Ignored.");
            }
        }
    }

    private void loadConfig() {
        block25: {
            File configFile = new File("data/scripts/events/" + this.getScriptName() + "/config.xml");
            _log.info("LongTimeEvent: " + configFile.getPath());
            try {
                Node first;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(configFile);
                if (!doc.getDocumentElement().getNodeName().equalsIgnoreCase("event")) {
                    throw new NullPointerException("WARNING!!! " + this.getScriptName() + " event: bad config file!");
                }
                String period = doc.getDocumentElement().getAttributes().getNamedItem("active").getNodeValue();
                this._eventPeriod = DateRange.parse(period, new SimpleDateFormat("dd MM yyyy", Locale.US));
                if (!this._eventPeriod.isValid()) {
                    this._eventPeriod = null;
                    throw new NullPointerException("WARNING!!! " + this.getScriptName() + " event: illegal event period");
                }
                if (doc.getDocumentElement().getAttributes().getNamedItem("dropPeriod") != null) {
                    String dropPeriod = doc.getDocumentElement().getAttributes().getNamedItem("dropPeriod").getNodeValue();
                    this._dropPeriod = DateRange.parse(dropPeriod, new SimpleDateFormat("dd MM yyyy", Locale.US));
                    if (!(this._dropPeriod.isValid() && this._eventPeriod.isWithinRange(this._dropPeriod.getStartDate()) && this._eventPeriod.isWithinRange(this._dropPeriod.getEndDate()))) {
                        this._dropPeriod = this._eventPeriod;
                        _log.warning(this.getScriptName() + " event: illegal drop period");
                    }
                } else {
                    this._dropPeriod = this._eventPeriod;
                }
                Date now = new Date();
                if (!now.before(this._eventPeriod.getEndDate())) break block25;
                for (Node n = first = doc.getDocumentElement().getFirstChild(); n != null; n = n.getNextSibling()) {
                    Node d;
                    if (n.getNodeName().equalsIgnoreCase("droplist")) {
                        for (d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                            if (!d.getNodeName().equalsIgnoreCase("add")) continue;
                            try {
                                String itemId = d.getAttributes().getNamedItem("item").getNodeValue();
                                int[] items = IntList.parse(itemId);
                                int minCount = Integer.parseInt(d.getAttributes().getNamedItem("min").getNodeValue());
                                int maxCount = Integer.parseInt(d.getAttributes().getNamedItem("max").getNodeValue());
                                String chance = d.getAttributes().getNamedItem("chance").getNodeValue();
                                int finalChance = 0;
                                if (!chance.isEmpty() && chance.endsWith("%")) {
                                    finalChance = (int)(FaenorParser.getPercent(chance) * 1000000.0);
                                }
                                boolean err = false;
                                for (int item : items) {
                                    if (ItemTable.getInstance().getTemplate(item) != null) continue;
                                    _log.warning(this.getScriptName() + " event: " + itemId + " is wrong item id, item was not added in droplist");
                                    err = true;
                                }
                                if (minCount > maxCount) {
                                    _log.warning(this.getScriptName() + " event: item " + itemId + " - min greater than max, item was not added in droplist");
                                    err = true;
                                }
                                if (finalChance < 0 || finalChance > 1000000) {
                                    _log.warning(this.getScriptName() + " event: item " + itemId + " - incorrect drop chance, item was not added in droplist");
                                    err = true;
                                }
                                if (err) continue;
                                if (this._dropList == null) {
                                    this._dropList = new ArrayList();
                                }
                                this._dropList.add(new EventDrop(items, (long)minCount, (long)maxCount, finalChance));
                                continue;
                            }
                            catch (NumberFormatException nfe) {
                                _log.warning("Wrong number format in config.xml droplist block for " + this.getScriptName() + " event");
                            }
                        }
                        continue;
                    }
                    if (n.getNodeName().equalsIgnoreCase("spawnlist")) {
                        for (d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                            if (!d.getNodeName().equalsIgnoreCase("add")) continue;
                            try {
                                int heading;
                                int npcId = Integer.parseInt(d.getAttributes().getNamedItem("npc").getNodeValue());
                                if (NpcData.getInstance().getTemplate(npcId) == null) {
                                    _log.warning(this.getScriptName() + " event: " + npcId + " is wrong NPC id, NPC was not added in spawnlist");
                                    continue;
                                }
                                Node nx = d.getAttributes().getNamedItem("x");
                                Node ny = d.getAttributes().getNamedItem("y");
                                Node nz = d.getAttributes().getNamedItem("z");
                                Node nh = d.getAttributes().getNamedItem("heading");
                                int xPos = nx == null ? 0 : Integer.parseInt(nx.getNodeValue());
                                int yPos = ny == null ? 0 : Integer.parseInt(ny.getNodeValue());
                                int zPos = nz == null ? 0 : Integer.parseInt(nz.getNodeValue());
                                int n2 = heading = nh == null ? 0 : Integer.parseInt(nh.getNodeValue());
                                if (this._spawnList == null) {
                                    this._spawnList = new ArrayList();
                                }
                                this._spawnList.add(new NpcSpawn(npcId, xPos, yPos, zPos, heading));
                                continue;
                            }
                            catch (NumberFormatException nfe) {
                                _log.warning("Wrong number format in config.xml spawnlist block for " + this.getScriptName() + " event");
                            }
                        }
                        continue;
                    }
                    if (!n.getNodeName().equalsIgnoreCase("messages")) continue;
                    for (d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                        if (!d.getNodeName().equalsIgnoreCase("add")) continue;
                        String msgType = d.getAttributes().getNamedItem("type").getNodeValue();
                        String msgText = d.getAttributes().getNamedItem("text").getNodeValue();
                        if (msgType == null || msgText == null) continue;
                        if (msgType.equalsIgnoreCase("onEnd")) {
                            this._onEndMsg = msgText;
                            continue;
                        }
                        if (!msgType.equalsIgnoreCase("onEnter")) continue;
                        this._onEnterMsg = msgText;
                    }
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, this.getScriptName() + " event: error reading " + configFile.getAbsolutePath() + " ! " + e.getMessage(), e);
            }
        }
    }

    protected void startEvent() {
        if (this._dropList != null) {
            for (EventDrop drop : this._dropList) {
                EventDroplist.getInstance().addGlobalDrop(this._dropPeriod, drop);
            }
        }
        long millisToEventEnd = this._eventPeriod.getEndDate().getTime() - System.currentTimeMillis();
        if (this._spawnList != null) {
            for (NpcSpawn spawn : this._spawnList) {
                if (spawn.x == 0 && spawn.y == 0 && spawn.z == 0 && spawn.heading == 0) {
                    for (Location location : EventNpcAligner.getSpawns()) {
                        EventNpcAligner.align(LongTimeEvent.addSpawn(spawn.npc, location, false, millisToEventEnd));
                    }
                    continue;
                }
                L2Npc npc = LongTimeEvent.addSpawn(spawn.npc, spawn.x, spawn.y, spawn.z, spawn.heading, false, millisToEventEnd, false, 0);
                if (npc instanceof L2Attackable) continue;
                EventNpcAligner.alignRight(npc);
            }
        }
        String[] enterMsgs = this._onEnterMsg.split(messageSplitPattern);
        this.announceToAll(enterMsgs);
        Announcements.getInstance().addEventAnnouncement(this._eventPeriod, enterMsgs);
        ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

            @Override
            public void run() {
                LongTimeEvent.this.endEvent();
            }
        }, millisToEventEnd);
    }

    protected void endEvent() {
        String[] endMsgs = this._onEndMsg.split(messageSplitPattern);
        this.announceToAll(endMsgs);
    }

    public void announceToAll(String[] messageList) {
        for (String msg : messageList) {
            Broadcast.toAllOnlinePlayers(new CreatureSay(0, 10, "", msg));
        }
    }

    public DateRange getEventPeriod() {
        return this._eventPeriod;
    }

    public boolean isEventPeriod() {
        return this._eventPeriod.isWithinRange(new Date());
    }

    public boolean isDropPeriod() {
        return this._dropPeriod.isWithinRange(new Date());
    }

    private class NpcSpawn {
        protected final int npc;
        protected final int x;
        protected final int y;
        protected final int z;
        protected final int heading;

        protected NpcSpawn(int pNpcId, int pX, int pY, int pZ, int pHeading) {
            this.npc = pNpcId;
            this.x = pX;
            this.y = pY;
            this.z = pZ;
            this.heading = pHeading;
        }
    }
}

