/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.model.StatsSet;

public class GrandBossState {
    static final String[] _stateName = new String[4];
    private int _bossId;
    private StatsSet _stateSet;

    public int getBossId() {
        return this._bossId;
    }

    public void setBossId(int newId) {
        this._bossId = newId;
    }

    public int getState() {
        return GrandBossManager.getInstance().getBossStatus(this._bossId);
    }

    public String getStateName() {
        return _stateName[GrandBossManager.getInstance().getBossStatus(this._bossId)];
    }

    public void setState(int status) {
        GrandBossManager.getInstance().setBossStatus(this._bossId, status);
    }

    public void setRespawnDate(long interval) {
        this._stateSet.set("respawn_time", System.currentTimeMillis() + interval);
    }

    public GrandBossState(int bossId) {
        this._bossId = bossId;
        this._stateSet = GrandBossManager.getInstance().getStatsSet(this._bossId);
    }

    public void update() {
        GrandBossManager.getInstance().setStatsSet(this._bossId, this._stateSet);
    }

    public void setNextRespawnDate(long newRespawnDate) {
        this._stateSet.set("respawn_time", newRespawnDate);
    }

    public long getInterval() {
        long interval = this._stateSet.getLong("respawn_time") - System.currentTimeMillis();
        if (interval < 0L) {
            return 0L;
        }
        return interval;
    }

    public String respawnTimeFormat() {
        return GrandBossManager.respawnTimeFormat(this._stateSet);
    }

    static {
        GrandBossState._stateName[0] = "NOTSPAWN";
        GrandBossState._stateName[1] = "ALIVE";
        GrandBossState._stateName[2] = "DEAD";
        GrandBossState._stateName[3] = "INTERVAL";
    }

    public static class StateEnum {
        public static final int NOTSPAWN = 0;
        public static final int ALIVE = 1;
        public static final int DEAD = 2;
        public static final int INTERVAL = 3;
    }
}

