/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.enums.DuelResult;
import com.l2jserver.gameserver.enums.Team;
import com.l2jserver.gameserver.instancemanager.DuelManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExDuelEnd;
import com.l2jserver.gameserver.network.serverpackets.ExDuelReady;
import com.l2jserver.gameserver.network.serverpackets.ExDuelStart;
import com.l2jserver.gameserver.network.serverpackets.ExDuelUpdateUserInfo;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class Duel {
    protected static final Logger _log = Logger.getLogger(Duel.class.getName());
    public static final int DUELSTATE_NODUEL = 0;
    public static final int DUELSTATE_DUELLING = 1;
    public static final int DUELSTATE_DEAD = 2;
    public static final int DUELSTATE_WINNER = 3;
    public static final int DUELSTATE_INTERRUPTED = 4;
    private final int _duelId;
    private L2PcInstance _playerA;
    private L2PcInstance _playerB;
    private final boolean _partyDuel;
    private final Calendar _duelEndTime;
    private int _surrenderRequest = 0;
    private int _countdown = 4;
    private boolean _finished = false;
    private FastList<PlayerCondition> _playerConditions;

    public Duel(L2PcInstance playerA, L2PcInstance playerB, int partyDuel, int duelId) {
        this._duelId = duelId;
        this._playerA = playerA;
        this._playerB = playerB;
        this._partyDuel = partyDuel == 1;
        this._duelEndTime = Calendar.getInstance();
        if (this._partyDuel) {
            this._duelEndTime.add(13, 300);
        } else {
            this._duelEndTime.add(13, 120);
        }
        this._playerConditions = new FastList();
        this.setFinished(false);
        if (this._partyDuel) {
            ++this._countdown;
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.IN_A_MOMENT_YOU_WILL_BE_TRANSPORTED_TO_THE_SITE_WHERE_THE_DUEL_WILL_TAKE_PLACE);
            this.broadcastToTeam1(sm);
            this.broadcastToTeam2(sm);
        }
        ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartDuelTask(this), 3000L);
    }

    private void stopFighting() {
        ActionFailed af = ActionFailed.STATIC_PACKET;
        if (this._partyDuel) {
            for (L2PcInstance temp : this._playerA.getParty().getMembers()) {
                temp.abortCast();
                temp.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                temp.setTarget(null);
                temp.sendPacket(af);
            }
            for (L2PcInstance temp : this._playerB.getParty().getMembers()) {
                temp.abortCast();
                temp.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                temp.setTarget(null);
                temp.sendPacket(af);
            }
        } else {
            this._playerA.abortCast();
            this._playerB.abortCast();
            this._playerA.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            this._playerA.setTarget(null);
            this._playerB.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            this._playerB.setTarget(null);
            this._playerA.sendPacket(af);
            this._playerB.sendPacket(af);
        }
    }

    public boolean isDuelistInPvp(boolean sendMessage) {
        if (this._partyDuel) {
            return false;
        }
        if (this._playerA.getPvpFlag() != 0 || this._playerB.getPvpFlag() != 0) {
            if (sendMessage) {
                String engagedInPvP = "The duel was canceled because a duelist engaged in PvP combat.";
                this._playerA.sendMessage(engagedInPvP);
                this._playerB.sendMessage(engagedInPvP);
            }
            return true;
        }
        return false;
    }

    public void startDuel() {
        ExDuelReady ready;
        this.savePlayerConditions();
        if (this._playerA == null || this._playerB == null || this._playerA.isInDuel() || this._playerB.isInDuel()) {
            this._playerConditions.clear();
            this._playerConditions = null;
            DuelManager.getInstance().removeDuel(this);
            return;
        }
        if (this._partyDuel) {
            for (L2PcInstance temp : this._playerA.getParty().getMembers()) {
                temp.cancelActiveTrade();
                temp.setIsInDuel(this._duelId);
                temp.setTeam(Team.BLUE);
                temp.broadcastUserInfo();
                this.broadcastToTeam2(new ExDuelUpdateUserInfo(temp));
            }
            for (L2PcInstance temp : this._playerB.getParty().getMembers()) {
                temp.cancelActiveTrade();
                temp.setIsInDuel(this._duelId);
                temp.setTeam(Team.RED);
                temp.broadcastUserInfo();
                this.broadcastToTeam1(new ExDuelUpdateUserInfo(temp));
            }
            ready = new ExDuelReady(1);
            ExDuelStart start = new ExDuelStart(1);
            this.broadcastToTeam1(ready);
            this.broadcastToTeam2(ready);
            this.broadcastToTeam1(start);
            this.broadcastToTeam2(start);
        } else {
            this._playerA.setIsInDuel(this._duelId);
            this._playerA.setTeam(Team.BLUE);
            this._playerB.setIsInDuel(this._duelId);
            this._playerB.setTeam(Team.RED);
            ready = new ExDuelReady(0);
            ExDuelStart start = new ExDuelStart(0);
            this.broadcastToTeam1(ready);
            this.broadcastToTeam2(ready);
            this.broadcastToTeam1(start);
            this.broadcastToTeam2(start);
            this.broadcastToTeam1(new ExDuelUpdateUserInfo(this._playerB));
            this.broadcastToTeam2(new ExDuelUpdateUserInfo(this._playerA));
            this._playerA.broadcastUserInfo();
            this._playerB.broadcastUserInfo();
        }
        PlaySound ps = new PlaySound(1, "B04_S01", 0, 0, 0, 0, 0);
        this.broadcastToTeam1(ps);
        this.broadcastToTeam2(ps);
        ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleDuelTask(this), 1000L);
    }

    public void savePlayerConditions() {
        if (this._partyDuel) {
            for (L2PcInstance temp : this._playerA.getParty().getMembers()) {
                this._playerConditions.add((Object)new PlayerCondition(temp, this._partyDuel));
            }
            for (L2PcInstance temp : this._playerB.getParty().getMembers()) {
                this._playerConditions.add((Object)new PlayerCondition(temp, this._partyDuel));
            }
        } else {
            this._playerConditions.add((Object)new PlayerCondition(this._playerA, this._partyDuel));
            this._playerConditions.add((Object)new PlayerCondition(this._playerB, this._partyDuel));
        }
    }

    public void restorePlayerConditions(boolean abnormalDuelEnd) {
        if (this._partyDuel) {
            for (L2PcInstance temp : this._playerA.getParty().getMembers()) {
                temp.setIsInDuel(0);
                temp.setTeam(Team.NONE);
                temp.broadcastUserInfo();
            }
            for (L2PcInstance temp : this._playerB.getParty().getMembers()) {
                temp.setIsInDuel(0);
                temp.setTeam(Team.NONE);
                temp.broadcastUserInfo();
            }
        } else {
            this._playerA.setIsInDuel(0);
            this._playerA.setTeam(Team.NONE);
            this._playerA.broadcastUserInfo();
            this._playerB.setIsInDuel(0);
            this._playerB.setTeam(Team.NONE);
            this._playerB.broadcastUserInfo();
        }
        if (abnormalDuelEnd) {
            return;
        }
        for (PlayerCondition cond : this._playerConditions) {
            cond.restoreCondition();
        }
    }

    public int getId() {
        return this._duelId;
    }

    public int getRemainingTime() {
        return (int)(this._duelEndTime.getTimeInMillis() - System.currentTimeMillis());
    }

    public L2PcInstance getPlayerA() {
        return this._playerA;
    }

    public L2PcInstance getPlayerB() {
        return this._playerB;
    }

    public boolean isPartyDuel() {
        return this._partyDuel;
    }

    public void setFinished(boolean mode) {
        this._finished = mode;
    }

    public boolean getFinished() {
        return this._finished;
    }

    public void teleportPlayers(int x, int y, int z) {
        if (!this._partyDuel) {
            return;
        }
        int offset = 0;
        for (L2PcInstance temp : this._playerA.getParty().getMembers()) {
            temp.teleToLocation(x + offset - 180, y - 150, z);
            offset += 40;
        }
        offset = 0;
        for (L2PcInstance temp : this._playerB.getParty().getMembers()) {
            temp.teleToLocation(x + offset - 180, y + 150, z);
            offset += 40;
        }
    }

    public void broadcastToTeam1(L2GameServerPacket packet) {
        if (this._playerA == null) {
            return;
        }
        if (this._partyDuel && this._playerA.getParty() != null) {
            for (L2PcInstance temp : this._playerA.getParty().getMembers()) {
                temp.sendPacket(packet);
            }
        } else {
            this._playerA.sendPacket(packet);
        }
    }

    public void broadcastToTeam2(L2GameServerPacket packet) {
        if (this._playerB == null) {
            return;
        }
        if (this._partyDuel && this._playerB.getParty() != null) {
            for (L2PcInstance temp : this._playerB.getParty().getMembers()) {
                temp.sendPacket(packet);
            }
        } else {
            this._playerB.sendPacket(packet);
        }
    }

    public L2PcInstance getWinner() {
        if (!this.getFinished() || this._playerA == null || this._playerB == null) {
            return null;
        }
        if (this._playerA.getDuelState() == 3) {
            return this._playerA;
        }
        if (this._playerB.getDuelState() == 3) {
            return this._playerB;
        }
        return null;
    }

    public L2PcInstance getLooser() {
        if (!this.getFinished() || this._playerA == null || this._playerB == null) {
            return null;
        }
        if (this._playerA.getDuelState() == 3) {
            return this._playerB;
        }
        if (this._playerB.getDuelState() == 3) {
            return this._playerA;
        }
        return null;
    }

    public void playKneelAnimation() {
        L2PcInstance looser = this.getLooser();
        if (looser == null) {
            return;
        }
        if (this._partyDuel && looser.getParty() != null) {
            for (L2PcInstance temp : looser.getParty().getMembers()) {
                temp.broadcastPacket(new SocialAction(temp.getObjectId(), 7));
            }
        } else {
            looser.broadcastPacket(new SocialAction(looser.getObjectId(), 7));
        }
    }

    public int countdown() {
        --this._countdown;
        if (this._countdown > 3) {
            return this._countdown;
        }
        SystemMessage sm = null;
        if (this._countdown > 0) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.THE_DUEL_WILL_BEGIN_IN_S1_SECONDS);
            sm.addInt(this._countdown);
        } else {
            sm = SystemMessage.getSystemMessage(SystemMessageId.LET_THE_DUEL_BEGIN);
        }
        this.broadcastToTeam1(sm);
        this.broadcastToTeam2(sm);
        return this._countdown;
    }

    public void endDuel(DuelResult result) {
        if (this._playerA == null || this._playerB == null) {
            this._playerConditions.clear();
            this._playerConditions = null;
            DuelManager.getInstance().removeDuel(this);
            return;
        }
        SystemMessage sm = null;
        switch (result) {
            case Team1Win: 
            case Team2Surrender: {
                this.restorePlayerConditions(false);
                sm = this._partyDuel ? SystemMessage.getSystemMessage(SystemMessageId.C1_PARTY_HAS_WON_THE_DUEL) : SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_WON_THE_DUEL);
                sm.addString(this._playerA.getName());
                this.broadcastToTeam1(sm);
                this.broadcastToTeam2(sm);
                break;
            }
            case Team1Surrender: 
            case Team2Win: {
                this.restorePlayerConditions(false);
                sm = this._partyDuel ? SystemMessage.getSystemMessage(SystemMessageId.C1_PARTY_HAS_WON_THE_DUEL) : SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_WON_THE_DUEL);
                sm.addString(this._playerB.getName());
                this.broadcastToTeam1(sm);
                this.broadcastToTeam2(sm);
                break;
            }
            case Canceled: {
                this.stopFighting();
                this.restorePlayerConditions(true);
                sm = SystemMessage.getSystemMessage(SystemMessageId.THE_DUEL_HAS_ENDED_IN_A_TIE);
                this.broadcastToTeam1(sm);
                this.broadcastToTeam2(sm);
                break;
            }
            case Timeout: {
                this.stopFighting();
                this.restorePlayerConditions(false);
                sm = SystemMessage.getSystemMessage(SystemMessageId.THE_DUEL_HAS_ENDED_IN_A_TIE);
                this.broadcastToTeam1(sm);
                this.broadcastToTeam2(sm);
            }
        }
        ExDuelEnd duelEnd = null;
        duelEnd = this._partyDuel ? new ExDuelEnd(1) : new ExDuelEnd(0);
        this.broadcastToTeam1(duelEnd);
        this.broadcastToTeam2(duelEnd);
        this._playerConditions.clear();
        this._playerConditions = null;
        DuelManager.getInstance().removeDuel(this);
    }

    public DuelResult checkEndDuelCondition() {
        if (this._playerA == null || this._playerB == null) {
            return DuelResult.Canceled;
        }
        if (this._surrenderRequest != 0) {
            if (this._surrenderRequest == 1) {
                return DuelResult.Team1Surrender;
            }
            return DuelResult.Team2Surrender;
        }
        if (this.getRemainingTime() <= 0) {
            return DuelResult.Timeout;
        }
        if (this._playerA.getDuelState() == 3) {
            this.stopFighting();
            return DuelResult.Team1Win;
        }
        if (this._playerB.getDuelState() == 3) {
            this.stopFighting();
            return DuelResult.Team2Win;
        }
        if (!this._partyDuel) {
            if (this._playerA.getDuelState() == 4 || this._playerB.getDuelState() == 4) {
                return DuelResult.Canceled;
            }
            if (!this._playerA.isInsideRadius(this._playerB, 1600, false, false)) {
                return DuelResult.Canceled;
            }
            if (this.isDuelistInPvp(true)) {
                return DuelResult.Canceled;
            }
            if (this._playerA.isInsideZone(ZoneId.PEACE) || this._playerB.isInsideZone(ZoneId.PEACE) || this._playerA.isInsideZone(ZoneId.SIEGE) || this._playerB.isInsideZone(ZoneId.SIEGE) || this._playerA.isInsideZone(ZoneId.PVP) || this._playerB.isInsideZone(ZoneId.PVP)) {
                return DuelResult.Canceled;
            }
        }
        return DuelResult.Continue;
    }

    public void doSurrender(L2PcInstance player) {
        if (this._surrenderRequest != 0) {
            return;
        }
        this.stopFighting();
        if (this._partyDuel) {
            if (this._playerA.getParty().getMembers().contains(player)) {
                this._surrenderRequest = 1;
                for (L2PcInstance temp : this._playerA.getParty().getMembers()) {
                    temp.setDuelState(2);
                }
                for (L2PcInstance temp : this._playerB.getParty().getMembers()) {
                    temp.setDuelState(3);
                }
            } else if (this._playerB.getParty().getMembers().contains(player)) {
                this._surrenderRequest = 2;
                for (L2PcInstance temp : this._playerB.getParty().getMembers()) {
                    temp.setDuelState(2);
                }
                for (L2PcInstance temp : this._playerA.getParty().getMembers()) {
                    temp.setDuelState(3);
                }
            }
        } else if (player == this._playerA) {
            this._surrenderRequest = 1;
            this._playerA.setDuelState(2);
            this._playerB.setDuelState(3);
        } else if (player == this._playerB) {
            this._surrenderRequest = 2;
            this._playerB.setDuelState(2);
            this._playerA.setDuelState(3);
        }
    }

    public void onPlayerDefeat(L2PcInstance player) {
        player.setDuelState(2);
        if (this._partyDuel) {
            boolean teamdefeated = true;
            for (L2PcInstance temp : player.getParty().getMembers()) {
                if (temp.getDuelState() != 1) continue;
                teamdefeated = false;
                break;
            }
            if (teamdefeated) {
                L2PcInstance winner = this._playerA;
                if (this._playerA.getParty().getMembers().contains(player)) {
                    winner = this._playerB;
                }
                for (L2PcInstance temp : winner.getParty().getMembers()) {
                    temp.setDuelState(3);
                }
            }
        } else {
            if (player != this._playerA && player != this._playerB) {
                _log.warning("Error in onPlayerDefeat(): player is not part of this 1vs1 duel");
            }
            if (this._playerA == player) {
                this._playerB.setDuelState(3);
            } else {
                this._playerA.setDuelState(3);
            }
        }
    }

    public void onRemoveFromParty(L2PcInstance player) {
        if (!this._partyDuel) {
            return;
        }
        if (player == this._playerA || player == this._playerB) {
            for (PlayerCondition cond : this._playerConditions) {
                cond.teleportBack();
                cond.getPlayer().setIsInDuel(0);
            }
            this._playerA = null;
            this._playerB = null;
        } else {
            for (PlayerCondition cond : this._playerConditions) {
                if (cond.getPlayer() != player) continue;
                cond.teleportBack();
                this._playerConditions.remove((Object)cond);
                break;
            }
            player.setIsInDuel(0);
        }
    }

    public void onBuff(L2PcInstance player, Skill debuff) {
        for (PlayerCondition cond : this._playerConditions) {
            if (cond.getPlayer() != player) continue;
            cond.registerDebuff(debuff);
            return;
        }
    }

    public static class ScheduleEndDuelTask
    implements Runnable {
        private final Duel _duel;
        private final DuelResult _result;

        public ScheduleEndDuelTask(Duel duel, DuelResult result) {
            this._duel = duel;
            this._result = result;
        }

        @Override
        public void run() {
            try {
                this._duel.endDuel(this._result);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    public static class ScheduleStartDuelTask
    implements Runnable {
        private final Duel _duel;

        public ScheduleStartDuelTask(Duel duel) {
            this._duel = duel;
        }

        @Override
        public void run() {
            try {
                int count = this._duel.countdown();
                if (count == 4) {
                    this._duel.teleportPlayers(-83760, -238825, -3331);
                    ThreadPoolManager.getInstance().scheduleGeneral(this, 20000L);
                } else if (count > 0) {
                    ThreadPoolManager.getInstance().scheduleGeneral(this, 1000L);
                } else {
                    this._duel.startDuel();
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    public class ScheduleDuelTask
    implements Runnable {
        private final Duel _duel;

        public ScheduleDuelTask(Duel duel2) {
            this._duel = duel2;
        }

        @Override
        public void run() {
            try {
                DuelResult status = this._duel.checkEndDuelCondition();
                if (status == DuelResult.Canceled) {
                    Duel.this.setFinished(true);
                    this._duel.endDuel(status);
                } else if (status != DuelResult.Continue) {
                    Duel.this.setFinished(true);
                    Duel.this.playKneelAnimation();
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndDuelTask(this._duel, status), 5000L);
                } else {
                    ThreadPoolManager.getInstance().scheduleGeneral(this, 1000L);
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    public static class PlayerCondition {
        private L2PcInstance _player;
        private double _hp;
        private double _mp;
        private double _cp;
        private boolean _paDuel;
        private int _x;
        private int _y;
        private int _z;
        private FastList<Skill> _debuffs;

        public PlayerCondition(L2PcInstance player, boolean partyDuel) {
            if (player == null) {
                return;
            }
            this._player = player;
            this._hp = this._player.getCurrentHp();
            this._mp = this._player.getCurrentMp();
            this._cp = this._player.getCurrentCp();
            this._paDuel = partyDuel;
            if (this._paDuel) {
                this._x = this._player.getX();
                this._y = this._player.getY();
                this._z = this._player.getZ();
            }
        }

        public void restoreCondition() {
            if (this._player == null) {
                return;
            }
            this._player.setCurrentHp(this._hp);
            this._player.setCurrentMp(this._mp);
            this._player.setCurrentCp(this._cp);
            if (this._paDuel) {
                this.teleportBack();
            }
            if (this._debuffs != null) {
                for (Skill skill : this._debuffs) {
                    if (skill == null) continue;
                    this._player.stopSkillEffects(true, skill.getId());
                }
            }
        }

        public void registerDebuff(Skill debuff) {
            if (this._debuffs == null) {
                this._debuffs = new FastList();
            }
            this._debuffs.add((Object)debuff);
        }

        public void teleportBack() {
            if (this._paDuel) {
                this._player.teleToLocation(this._x, this._y, this._z);
            }
        }

        public L2PcInstance getPlayer() {
            return this._player;
        }
    }
}

