/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.drops;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.drops.IDropItem;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.util.Rnd;
import java.util.ArrayList;
import java.util.List;

public class GeneralDropItem
implements IDropItem {
    private final int _itemId;
    private final long _min;
    private final long _max;
    private final double _chance;

    public GeneralDropItem(int itemId, long min, long max, double chance) {
        this._itemId = itemId;
        this._min = min;
        this._max = max;
        this._chance = chance;
    }

    public int getItemId() {
        return this._itemId;
    }

    public long getMin() {
        return this._min;
    }

    public long getMin(L2Character victim, L2Character killer) {
        Float dropChanceMultiplier;
        double multiplier = 1.0;
        if (victim.isChampion()) {
            multiplier *= this.getItemId() != 57 ? (double)Config.L2JMOD_CHAMPION_REWARDS : (double)Config.L2JMOD_CHAMPION_ADENAS_REWARDS;
        }
        if ((dropChanceMultiplier = Config.RATE_DROP_AMOUNT_MULTIPLIER.get(this.getItemId())) != null) {
            multiplier *= (double)dropChanceMultiplier.floatValue();
        }
        return (long)((double)this.getMin() * multiplier);
    }

    public long getMax() {
        return this._max;
    }

    public long getMax(L2Character victim, L2Character killer) {
        Float dropChanceMultiplier;
        double multiplier = 1.0;
        if (victim.isChampion()) {
            multiplier *= this.getItemId() != 57 ? (double)Config.L2JMOD_CHAMPION_REWARDS : (double)Config.L2JMOD_CHAMPION_ADENAS_REWARDS;
        }
        if ((dropChanceMultiplier = Config.RATE_DROP_AMOUNT_MULTIPLIER.get(this.getItemId())) != null) {
            multiplier *= (double)dropChanceMultiplier.floatValue();
        }
        return (long)((double)this.getMax() * multiplier);
    }

    public double getChance() {
        return this._chance;
    }

    public double getChance(L2Character victim, L2Character killer) {
        float multiplier = 1.0f;
        Float dropChanceMultiplier = Config.RATE_DROP_CHANCE_MULTIPLIER.get(this.getItemId());
        if (dropChanceMultiplier != null) {
            multiplier *= dropChanceMultiplier.floatValue();
        }
        return this.getChance() * (double)multiplier;
    }

    @Override
    public List<ItemHolder> calculateDrops(L2Character victim, L2Character killer) {
        double levelGapChanceToDrop;
        int levelDifference = victim.getLevel() - killer.getLevel();
        if (this.getItemId() == 57) {
            if (levelDifference >= -8) {
                levelGapChanceToDrop = 100.0;
            } else if (levelDifference >= -15) {
                levelGapChanceToDrop = levelDifference;
                levelGapChanceToDrop *= 12.857;
                levelGapChanceToDrop += 202.857;
            } else {
                levelGapChanceToDrop = 10.0;
            }
        } else if (levelDifference >= -5) {
            levelGapChanceToDrop = 100.0;
        } else if (levelDifference >= -10) {
            levelGapChanceToDrop = levelDifference;
            levelGapChanceToDrop *= 18.0;
            levelGapChanceToDrop += 190.0;
        } else {
            levelGapChanceToDrop = 10.0;
        }
        if (levelGapChanceToDrop < Rnd.nextDouble() * 100.0) {
            return null;
        }
        if (this.getChance(victim, killer) > Rnd.nextDouble() * 100.0) {
            long amount = Rnd.get(this.getMin(victim, killer), this.getMax(victim, killer));
            ArrayList<ItemHolder> items = new ArrayList<ItemHolder>(1);
            items.add(new ItemHolder(this.getItemId(), amount));
            return items;
        }
        return null;
    }
}

