/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;

public class ConditionPlayerCanTakeFort
extends Condition {
    private final boolean _val;

    public ConditionPlayerCanTakeFort(boolean val) {
        this._val = val;
    }

    @Override
    public boolean testImpl(Env env) {
        Fort fort;
        boolean canTakeFort = true;
        if (env.getPlayer() == null || env.getPlayer().isAlikeDead() || env.getPlayer().isCursedWeaponEquipped() || env.getPlayer().getClan() == null) {
            canTakeFort = false;
        }
        if ((fort = FortManager.getInstance().getFort(env.getPlayer())) == null || fort.getResidenceId() <= 0 || !fort.getSiege().getIsInProgress() || fort.getSiege().getAttackerClan(env.getPlayer().getClan()) == null) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(env.getSkill());
            env.getPlayer().sendPacket(sm);
            canTakeFort = false;
        } else if (fort.getFlagPole() != env.getTarget()) {
            env.getPlayer().sendPacket(SystemMessageId.INCORRECT_TARGET);
            canTakeFort = false;
        } else if (!Util.checkIfInRange(200, env.getPlayer(), env.getTarget(), true)) {
            env.getPlayer().sendPacket(SystemMessageId.DIST_TOO_FAR_CASTING_STOPPED);
            canTakeFort = false;
        }
        return this._val == canTakeFort;
    }
}

