/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;

public class ConditionPlayerCanCreateOutpost
extends Condition {
    private final boolean _val;

    public ConditionPlayerCanCreateOutpost(boolean val) {
        this._val = val;
    }

    @Override
    public boolean testImpl(Env env) {
        boolean canCreateOutpost = true;
        if (env.getPlayer() == null || env.getPlayer().isAlikeDead() || env.getPlayer().isCursedWeaponEquipped() || env.getPlayer().getClan() == null) {
            canCreateOutpost = false;
        }
        Castle castle = CastleManager.getInstance().getCastle(env.getPlayer());
        Fort fort = FortManager.getInstance().getFort(env.getPlayer());
        if (castle == null && fort == null) {
            canCreateOutpost = false;
        }
        L2PcInstance player = env.getPlayer().getActingPlayer();
        if (fort != null && fort.getResidenceId() == 0 || castle != null && castle.getResidenceId() == 0) {
            player.sendMessage("You must be on fort or castle ground to construct an outpost or flag.");
            canCreateOutpost = false;
        } else if (fort != null && !fort.getZone().isActive() || castle != null && !castle.getZone().isActive()) {
            player.sendMessage("You can only construct an outpost or flag on siege field.");
            canCreateOutpost = false;
        } else if (!player.isClanLeader()) {
            player.sendMessage("You must be a clan leader to construct an outpost or flag.");
            canCreateOutpost = false;
        } else if (TerritoryWarManager.getInstance().getHQForClan(player.getClan()) != null) {
            player.sendPacket(SystemMessageId.NOT_ANOTHER_HEADQUARTERS);
            canCreateOutpost = false;
        } else if (TerritoryWarManager.getInstance().getFlagForClan(player.getClan()) != null) {
            player.sendPacket(SystemMessageId.A_FLAG_IS_ALREADY_BEING_DISPLAYED_ANOTHER_FLAG_CANNOT_BE_DISPLAYED);
            canCreateOutpost = false;
        } else if (!player.isInsideZone(ZoneId.HQ)) {
            player.sendPacket(SystemMessageId.NOT_SET_UP_BASE_HERE);
            canCreateOutpost = false;
        }
        return this._val == canCreateOutpost;
    }
}

