/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.BaseStat;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.stats.Env;

public class ConditionPlayerBaseStats
extends Condition {
    private final BaseStat _stat;
    private final int _value;

    public ConditionPlayerBaseStats(L2Character player, BaseStat stat, int value) {
        this._stat = stat;
        this._value = value;
    }

    @Override
    public boolean testImpl(Env env) {
        if (env.getPlayer() == null) {
            return false;
        }
        L2PcInstance player = env.getPlayer();
        switch (this._stat) {
            case Int: {
                return player.getINT() >= this._value;
            }
            case Str: {
                return player.getSTR() >= this._value;
            }
            case Con: {
                return player.getCON() >= this._value;
            }
            case Dex: {
                return player.getDEX() >= this._value;
            }
            case Men: {
                return player.getMEN() >= this._value;
            }
            case Wit: {
                return player.getWIT() >= this._value;
            }
        }
        return false;
    }
}

