/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.status;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.instancemanager.DuelManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.stat.PcStat;
import com.l2jserver.gameserver.model.actor.status.PlayableStatus;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.stats.Formulas;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;

public class PcStatus
extends PlayableStatus {
    private double _currentCp = 0.0;

    public PcStatus(L2PcInstance activeChar) {
        super(activeChar);
    }

    @Override
    public final void reduceCp(int value) {
        if (this.getCurrentCp() > (double)value) {
            this.setCurrentCp(this.getCurrentCp() - (double)value);
        } else {
            this.setCurrentCp(0.0);
        }
    }

    @Override
    public final void reduceHp(double value, L2Character attacker) {
        this.reduceHp(value, attacker, true, false, false, false);
    }

    @Override
    public final void reduceHp(double value, L2Character attacker, boolean awake, boolean isDOT, boolean isHPConsumption) {
        this.reduceHp(value, attacker, awake, isDOT, isHPConsumption, false);
    }

    public final void reduceHp(double value, L2Character attacker, boolean awake, boolean isDOT, boolean isHPConsumption, boolean ignoreCP) {
        if (this.getActiveChar().isDead()) {
            return;
        }
        if (Config.OFFLINE_MODE_NO_DAMAGE && this.getActiveChar().getClient() != null && this.getActiveChar().getClient().isDetached() && (Config.OFFLINE_TRADE_ENABLE && (this.getActiveChar().getPrivateStoreType() == PrivateStoreType.SELL || this.getActiveChar().getPrivateStoreType() == PrivateStoreType.BUY) || Config.OFFLINE_CRAFT_ENABLE && (this.getActiveChar().isInCraftMode() || this.getActiveChar().getPrivateStoreType() == PrivateStoreType.MANUFACTURE))) {
            return;
        }
        if (this.getActiveChar().isInvul() && !isDOT && !isHPConsumption) {
            return;
        }
        if (!isHPConsumption) {
            this.getActiveChar().stopEffectsOnDamage(awake);
            if (this.getActiveChar().isInCraftMode() || this.getActiveChar().isInStoreMode()) {
                this.getActiveChar().setPrivateStoreType(PrivateStoreType.NONE);
                this.getActiveChar().standUp();
                this.getActiveChar().broadcastUserInfo();
            } else if (this.getActiveChar().isSitting()) {
                this.getActiveChar().standUp();
            }
            if (!isDOT && this.getActiveChar().isStunned() && Rnd.get(10) == 0) {
                this.getActiveChar().stopStunning(true);
            }
        }
        int fullValue = (int)value;
        int tDmg = 0;
        int mpDam = 0;
        if (attacker != null && attacker != this.getActiveChar()) {
            L2PcInstance caster;
            L2PcInstance attackerPlayer = attacker.getActingPlayer();
            if (attackerPlayer != null) {
                if (attackerPlayer.isGM() && !attackerPlayer.getAccessLevel().canGiveDamage()) {
                    return;
                }
                if (this.getActiveChar().isInDuel()) {
                    if (this.getActiveChar().getDuelState() == 2) {
                        return;
                    }
                    if (this.getActiveChar().getDuelState() == 3) {
                        return;
                    }
                    if (attackerPlayer.getDuelId() != this.getActiveChar().getDuelId()) {
                        this.getActiveChar().setDuelState(4);
                    }
                }
            }
            L2Summon summon = this.getActiveChar().getSummon();
            if (this.getActiveChar().hasServitor() && Util.checkIfInRange(1000, this.getActiveChar(), summon, true)) {
                tDmg = (int)value * (int)this.getActiveChar().getStat().calcStat(Stats.TRANSFER_DAMAGE_PERCENT, 0.0, null, null) / 100;
                tDmg = Math.min((int)summon.getCurrentHp() - 1, tDmg);
                if (tDmg > 0) {
                    summon.reduceCurrentHp(tDmg, attacker, null);
                    fullValue = (int)(value -= (double)tDmg);
                }
            }
            if ((mpDam = (int)value * (int)this.getActiveChar().getStat().calcStat(Stats.MANA_SHIELD_PERCENT, 0.0, null, null) / 100) > 0) {
                if ((double)(mpDam = (int)(value - (double)mpDam)) > this.getActiveChar().getCurrentMp()) {
                    this.getActiveChar().sendPacket(SystemMessageId.MP_BECAME_0_ARCANE_SHIELD_DISAPPEARING);
                    this.getActiveChar().stopSkillEffects(true, 1556);
                    value = (double)mpDam - this.getActiveChar().getCurrentMp();
                    this.getActiveChar().setCurrentMp(0.0);
                } else {
                    this.getActiveChar().reduceCurrentMp(mpDam);
                    SystemMessage smsg = SystemMessage.getSystemMessage(SystemMessageId.ARCANE_SHIELD_DECREASED_YOUR_MP_BY_S1_INSTEAD_OF_HP);
                    smsg.addInt(mpDam);
                    this.getActiveChar().sendPacket(smsg);
                    return;
                }
            }
            if ((caster = this.getActiveChar().getTransferingDamageTo()) != null && this.getActiveChar().getParty() != null && Util.checkIfInRange(1000, this.getActiveChar(), caster, true) && !caster.isDead() && this.getActiveChar() != caster && this.getActiveChar().getParty().getMembers().contains(caster)) {
                int transferDmg = 0;
                transferDmg = (int)value * (int)this.getActiveChar().getStat().calcStat(Stats.TRANSFER_DAMAGE_TO_PLAYER, 0.0, null, null) / 100;
                transferDmg = Math.min((int)caster.getCurrentHp() - 1, transferDmg);
                if (transferDmg > 0) {
                    int membersInRange = 0;
                    for (L2PcInstance member : caster.getParty().getMembers()) {
                        if (!Util.checkIfInRange(1000, member, caster, false) || member == caster) continue;
                        ++membersInRange;
                    }
                    if (attacker instanceof L2Playable && caster.getCurrentCp() > 0.0) {
                        if (caster.getCurrentCp() > (double)transferDmg) {
                            caster.getStatus().reduceCp(transferDmg);
                        } else {
                            transferDmg = (int)((double)transferDmg - caster.getCurrentCp());
                            caster.getStatus().reduceCp((int)caster.getCurrentCp());
                        }
                    }
                    if (membersInRange > 0) {
                        caster.reduceCurrentHp(transferDmg / membersInRange, attacker, null);
                        fullValue = (int)(value -= (double)transferDmg);
                    }
                }
            }
            if (!ignoreCP && attacker instanceof L2Playable) {
                if (this.getCurrentCp() >= value) {
                    this.setCurrentCp(this.getCurrentCp() - value);
                    value = 0.0;
                } else {
                    value -= this.getCurrentCp();
                    this.setCurrentCp(0.0, false);
                }
            }
            if (fullValue > 0 && !isDOT) {
                SystemMessage smsg = SystemMessage.getSystemMessage(SystemMessageId.C1_RECEIVED_DAMAGE_OF_S3_FROM_C2);
                smsg.addString(this.getActiveChar().getName());
                smsg.addCharName(attacker);
                smsg.addInt(fullValue);
                this.getActiveChar().sendPacket(smsg);
                if (tDmg > 0) {
                    smsg = SystemMessage.getSystemMessage(SystemMessageId.C1_RECEIVED_DAMAGE_OF_S3_FROM_C2);
                    smsg.addString(this.getActiveChar().getSummon().getName());
                    smsg.addCharName(attacker);
                    smsg.addInt(tDmg);
                    this.getActiveChar().sendPacket(smsg);
                    if (attackerPlayer != null) {
                        smsg = SystemMessage.getSystemMessage(SystemMessageId.GIVEN_S1_DAMAGE_TO_YOUR_TARGET_AND_S2_DAMAGE_TO_SERVITOR);
                        smsg.addInt(fullValue);
                        smsg.addInt(tDmg);
                        attackerPlayer.sendPacket(smsg);
                    }
                }
            }
        }
        if (value > 0.0) {
            value = this.getCurrentHp() - value;
            if (value <= 0.0) {
                if (this.getActiveChar().isInDuel()) {
                    this.getActiveChar().disableAllSkills();
                    this.stopHpMpRegeneration();
                    if (attacker != null) {
                        attacker.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                        attacker.sendPacket(ActionFailed.STATIC_PACKET);
                    }
                    DuelManager.getInstance().onPlayerDefeat(this.getActiveChar());
                    value = 1.0;
                } else {
                    value = 0.0;
                }
            }
            this.setCurrentHp(value);
        }
        if (this.getActiveChar().getCurrentHp() < 0.5) {
            QuestState qs;
            this.getActiveChar().abortAttack();
            this.getActiveChar().abortCast();
            if (this.getActiveChar().isInOlympiadMode()) {
                this.stopHpMpRegeneration();
                this.getActiveChar().setIsDead(true);
                this.getActiveChar().setIsPendingRevive(true);
                if (this.getActiveChar().hasSummon()) {
                    this.getActiveChar().getSummon().getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE, null);
                }
                return;
            }
            this.getActiveChar().doDie(attacker);
            if (!Config.DISABLE_TUTORIAL && (qs = this.getActiveChar().getQuestState("255_Tutorial")) != null) {
                qs.getQuest().notifyEvent("CE30", null, this.getActiveChar());
            }
        }
    }

    @Override
    public final boolean setCurrentHp(double newHp, boolean broadcastPacket) {
        QuestState qs;
        boolean result = super.setCurrentHp(newHp, broadcastPacket);
        if (!Config.DISABLE_TUTORIAL && this.getCurrentHp() <= (double)this.getActiveChar().getStat().getMaxHp() * 0.3 && (qs = this.getActiveChar().getQuestState("255_Tutorial")) != null) {
            qs.getQuest().notifyEvent("CE45", null, this.getActiveChar());
        }
        return result;
    }

    @Override
    public final double getCurrentCp() {
        return this._currentCp;
    }

    @Override
    public final void setCurrentCp(double newCp) {
        this.setCurrentCp(newCp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCurrentCp(double newCp, boolean broadcastPacket) {
        int currentCp = (int)this.getCurrentCp();
        int maxCp = this.getActiveChar().getStat().getMaxCp();
        PcStatus pcStatus = this;
        synchronized (pcStatus) {
            if (this.getActiveChar().isDead()) {
                return;
            }
            if (newCp < 0.0) {
                newCp = 0.0;
            }
            if (newCp >= (double)maxCp) {
                this._currentCp = maxCp;
                this._flagsRegenActive = (byte)(this._flagsRegenActive & 0xFFFFFFFB);
                if (this._flagsRegenActive == 0) {
                    this.stopHpMpRegeneration();
                }
            } else {
                this._currentCp = newCp;
                this._flagsRegenActive = (byte)(this._flagsRegenActive | 4);
                this.startHpMpRegeneration();
            }
        }
        if ((double)currentCp != this._currentCp && broadcastPacket) {
            this.getActiveChar().broadcastStatusUpdate();
        }
    }

    @Override
    protected void doRegeneration() {
        PcStat charstat = this.getActiveChar().getStat();
        if (this.getCurrentCp() < (double)charstat.getMaxRecoverableCp()) {
            this.setCurrentCp(this.getCurrentCp() + Formulas.calcCpRegen(this.getActiveChar()), false);
        }
        if (this.getCurrentHp() < (double)charstat.getMaxRecoverableHp()) {
            this.setCurrentHp(this.getCurrentHp() + Formulas.calcHpRegen(this.getActiveChar()), false);
        }
        if (this.getCurrentMp() < (double)charstat.getMaxRecoverableMp()) {
            this.setCurrentMp(this.getCurrentMp() + Formulas.calcMpRegen(this.getActiveChar()), false);
        }
        this.getActiveChar().broadcastStatusUpdate();
    }

    @Override
    public L2PcInstance getActiveChar() {
        return (L2PcInstance)this._activeChar;
    }
}

