/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.util.Evolve;

public class L2PetManagerInstance
extends L2MerchantInstance {
    public L2PetManagerInstance(int objectID, L2NpcTemplate template) {
        super(objectID, template);
        this.setInstanceType(InstanceType.L2PetManagerInstance);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/petmanager/", npcId, val);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        String filename = "data/html/petmanager/" + this.getId() + ".htm";
        if (this.getId() == 36478 && player.hasSummon()) {
            filename = "data/html/petmanager/restore-unsummonpet.htm";
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        if (Config.ALLOW_RENTPET && Config.LIST_PET_RENT_NPC.contains(this.getId())) {
            html.replace((CharSequence)"_Quest", "_RentPet\">\u30da\u30c3\u30c8\u3092\u30ec\u30f3\u30bf\u30eb\u3059\u308b\u3002</a><br><a action=\"bypass -h npc_%objectId%_Quest");
        }
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%npcname%", this.getName());
        player.sendPacket(html);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("exchange")) {
            String[] params = command.split(" ");
            int val = Integer.parseInt(params[1]);
            switch (val) {
                case 1: {
                    this.exchange(player, 7585, 6650);
                    break;
                }
                case 2: {
                    this.exchange(player, 7583, 6648);
                    break;
                }
                case 3: {
                    this.exchange(player, 7584, 6649);
                }
            }
            return;
        }
        if (command.startsWith("evolve")) {
            String[] params = command.split(" ");
            int val = Integer.parseInt(params[1]);
            boolean ok = false;
            switch (val) {
                case 1: {
                    ok = Evolve.doEvolve(player, this, 2375, 9882, 55);
                    break;
                }
                case 2: {
                    ok = Evolve.doEvolve(player, this, 9882, 10426, 70);
                    break;
                }
                case 3: {
                    ok = Evolve.doEvolve(player, this, 6648, 10311, 55);
                    break;
                }
                case 4: {
                    ok = Evolve.doEvolve(player, this, 6650, 10313, 55);
                    break;
                }
                case 5: {
                    ok = Evolve.doEvolve(player, this, 6649, 10312, 55);
                }
            }
            if (!ok) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/petmanager/evolve_no.htm");
                player.sendPacket(html);
            }
            return;
        }
        if (command.startsWith("restore")) {
            String[] params = command.split(" ");
            int val = Integer.parseInt(params[1]);
            boolean ok = false;
            switch (val) {
                case 1: {
                    ok = Evolve.doRestore(player, this, 10307, 9882, 55);
                    break;
                }
                case 2: {
                    ok = Evolve.doRestore(player, this, 10611, 10426, 70);
                    break;
                }
                case 3: {
                    ok = Evolve.doRestore(player, this, 10308, 4422, 55);
                    break;
                }
                case 4: {
                    ok = Evolve.doRestore(player, this, 10309, 4423, 55);
                    break;
                }
                case 5: {
                    ok = Evolve.doRestore(player, this, 10310, 4424, 55);
                }
            }
            if (!ok) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/petmanager/restore_no.htm");
                player.sendPacket(html);
            }
            return;
        }
        super.onBypassFeedback(player, command);
    }

    public final void exchange(L2PcInstance player, int itemIdtake, int itemIdgive) {
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        if (player.destroyItemByItemId("Consume", itemIdtake, 1L, this, true)) {
            player.addItem("", itemIdgive, 1L, this, true);
            html.setFile(player.getHtmlPrefix(), "data/html/petmanager/" + this.getId() + ".htm");
            player.sendPacket(html);
        } else {
            html.setFile(player.getHtmlPrefix(), "data/html/petmanager/exchange_no.htm");
            player.sendPacket(html);
        }
    }
}

