/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.events.PlayableEvents;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.PlayableKnownList;
import com.l2jserver.gameserver.model.actor.stat.PlayableStat;
import com.l2jserver.gameserver.model.actor.status.PlayableStatus;
import com.l2jserver.gameserver.model.actor.templates.L2CharTemplate;
import com.l2jserver.gameserver.model.effects.EffectFlag;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.skills.Skill;

public abstract class L2Playable
extends L2Character {
    private L2Character _lockedTarget = null;
    private L2PcInstance transferDmgTo = null;

    public L2Playable(int objectId, L2CharTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2Playable);
        this.setIsInvul(false);
    }

    @Override
    public PlayableKnownList getKnownList() {
        return (PlayableKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new PlayableKnownList(this));
    }

    @Override
    public PlayableStat getStat() {
        return (PlayableStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new PlayableStat(this));
    }

    @Override
    public PlayableStatus getStatus() {
        return (PlayableStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new PlayableStatus(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doDie(L2Character killer) {
        L2PcInstance player;
        Instance instance;
        L2PcInstance actingPlayer;
        if (!this.getEvents().onDeath(killer)) {
            return false;
        }
        L2Playable l2Playable = this;
        synchronized (l2Playable) {
            if (this.isDead()) {
                return false;
            }
            this.setCurrentHp(0.0);
            this.setIsDead(true);
        }
        this.setTarget(null);
        this.stopMove(null);
        this.getStatus().stopHpMpRegeneration();
        if (this.isPhoenixBlessed()) {
            if (this.isCharmOfLuckAffected()) {
                this.stopEffects(L2EffectType.CHARM_OF_LUCK);
            }
            if (this.isNoblesseBlessed()) {
                this.stopEffects(L2EffectType.NOBLESSE_BLESSING);
            }
        } else if (this.isNoblesseBlessed()) {
            this.stopEffects(L2EffectType.NOBLESSE_BLESSING);
            if (this.isCharmOfLuckAffected()) {
                this.stopEffects(L2EffectType.CHARM_OF_LUCK);
            }
        } else {
            this.stopAllEffectsExceptThoseThatLastThroughDeath();
        }
        this.broadcastStatusUpdate();
        if (this.getWorldRegion() != null) {
            this.getWorldRegion().onDeath(this);
        }
        if (!(actingPlayer = this.getActingPlayer()).isNotifyQuestOfDeathEmpty()) {
            for (QuestState qs : actingPlayer.getNotifyQuestOfDeath()) {
                qs.getQuest().notifyDeath(killer == null ? this : killer, this, qs);
            }
        }
        if (this.getInstanceId() > 0 && (instance = InstanceManager.getInstance().getInstance(this.getInstanceId())) != null) {
            instance.notifyDeath(killer, this);
        }
        if (killer != null && (player = killer.getActingPlayer()) != null) {
            player.onKillUpdatePvPKarma(this);
        }
        this.getAI().notifyEvent(CtrlEvent.EVT_DEAD);
        return true;
    }

    public boolean checkIfPvP(L2Character target) {
        if (target == null) {
            return false;
        }
        if (target == this) {
            return false;
        }
        if (!target.isPlayable()) {
            return false;
        }
        L2PcInstance player = this.getActingPlayer();
        if (player == null) {
            return false;
        }
        if (player.getKarma() != 0) {
            return false;
        }
        L2PcInstance targetPlayer = target.getActingPlayer();
        if (targetPlayer == null) {
            return false;
        }
        if (targetPlayer == this) {
            return false;
        }
        if (targetPlayer.getKarma() != 0) {
            return false;
        }
        return targetPlayer.getPvpFlag() != 0;
    }

    @Override
    public boolean canBeAttacked() {
        return true;
    }

    public final boolean isNoblesseBlessed() {
        return this.isAffected(EffectFlag.NOBLESS_BLESSING);
    }

    public final boolean isPhoenixBlessed() {
        return this.isAffected(EffectFlag.PHOENIX_BLESSING);
    }

    public boolean isSilentMoving() {
        return this.isAffected(EffectFlag.SILENT_MOVE);
    }

    public final boolean isProtectionBlessingAffected() {
        return this.isAffected(EffectFlag.PROTECTION_BLESSING);
    }

    public final boolean isCharmOfLuckAffected() {
        return this.isAffected(EffectFlag.CHARM_OF_LUCK);
    }

    @Override
    public void updateEffectIcons(boolean partyOnly) {
        this.getEffectList().updateEffectIcons(partyOnly);
    }

    public boolean isLockedTarget() {
        return this._lockedTarget != null;
    }

    public L2Character getLockedTarget() {
        return this._lockedTarget;
    }

    public void setLockedTarget(L2Character cha) {
        this._lockedTarget = cha;
    }

    public void setTransferDamageTo(L2PcInstance val) {
        this.transferDmgTo = val;
    }

    public L2PcInstance getTransferingDamageTo() {
        return this.transferDmgTo;
    }

    @Override
    public void initCharEvents() {
        this.setCharEvents(new PlayableEvents(this));
    }

    @Override
    public PlayableEvents getEvents() {
        return (PlayableEvents)super.getEvents();
    }

    public abstract int getKarma();

    public abstract byte getPvpFlag();

    public abstract boolean useMagic(Skill var1, boolean var2, boolean var3);

    public abstract void storeMe();

    public abstract void storeEffect(boolean var1);

    public abstract void restoreEffects();

    @Override
    public boolean isPlayable() {
        return true;
    }
}

