/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ItemsAutoDestroy;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.CategoryData;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.NpcPersonalAIData;
import com.l2jserver.gameserver.enums.AISkillScope;
import com.l2jserver.gameserver.enums.AIType;
import com.l2jserver.gameserver.enums.CategoryType;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.NpcRace;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.enums.ShotType;
import com.l2jserver.gameserver.enums.Team;
import com.l2jserver.gameserver.handler.BypassHandler;
import com.l2jserver.gameserver.handler.IBypassHandler;
import com.l2jserver.gameserver.instancemanager.CHSiegeManager;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.TownManager;
import com.l2jserver.gameserver.instancemanager.WalkingManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2ClanHallManagerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoormenInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FestivalGuideInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FishermanInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TeleporterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TrainerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2WarehouseInstance;
import com.l2jserver.gameserver.model.actor.knownlist.NpcKnownList;
import com.l2jserver.gameserver.model.actor.stat.NpcStat;
import com.l2jserver.gameserver.model.actor.status.NpcStatus;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.targets.L2TargetType;
import com.l2jserver.gameserver.model.variables.NpcVariables;
import com.l2jserver.gameserver.model.zone.type.L2TownZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExChangeNpcState;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.ServerObjectInfo;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.util.Rnd;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;

public class L2Npc
extends L2Character {
    public static final int INTERACTION_DISTANCE = 150;
    public static final int RANDOM_ITEM_DROP_LIMIT = 70;
    private L2Spawn _spawn;
    private boolean _isBusy = false;
    private String _busyMessage = "";
    private volatile boolean _isDecayed = false;
    private int _castleIndex = -2;
    private int _fortIndex = -2;
    private boolean _eventMob = false;
    private boolean _isInTown = false;
    private boolean _isAutoAttackable = false;
    private long _lastSocialBroadcast = 0L;
    private final int _minimalSocialInterval = 6000;
    private boolean _isRandomAnimationEnabled = true;
    protected RandomAnimationTask _rAniTask = null;
    private int _currentLHandId;
    private int _currentRHandId;
    private int _currentEnchant;
    private double _currentCollisionHeight;
    private double _currentCollisionRadius;
    private int _soulshotamount = 0;
    private int _spiritshotamount = 0;
    private int _displayEffect = 0;
    private int _shotsMask = 0;

    public int getSoulShotChance() {
        return this.getTemplate().getSoulShotChance();
    }

    public int getSpiritShotChance() {
        return this.getTemplate().getSpiritShotChance();
    }

    public int getPrimarySkillId() {
        return this.getTemplate().getPrimarySkillId();
    }

    public int getMinSkillChance() {
        return this.getTemplate().getMinSkillChance();
    }

    public int getMaxSkillChance() {
        return this.getTemplate().getMaxSkillChance();
    }

    public int getSkillChance() {
        return Rnd.get(this.getMinSkillChance(), this.getMaxSkillChance());
    }

    public boolean canMove() {
        return this.getTemplate().canMove();
    }

    public boolean isChaos() {
        return this.getTemplate().isChaos();
    }

    public int getDodge() {
        return this.getTemplate().getDodge();
    }

    public int getSSkillChance() {
        return this.getTemplate().getShortRangeSkillChance();
    }

    public int getLSkillChance() {
        return this.getTemplate().getLongRangeSkillChance();
    }

    public boolean hasLSkill() {
        return this.getTemplate().getLongRangeSkillId() > 0;
    }

    public boolean hasSSkill() {
        return this.getTemplate().getShortRangeSkillId() > 0;
    }

    public List<Skill> getLongRangeSkill() {
        ArrayList<Skill> skilldata = new ArrayList<Skill>();
        if (this.getTemplate().getLongRangeSkillId() == 0) {
            return skilldata;
        }
        switch (this.getTemplate().getLongRangeSkillId()) {
            case -1: {
                Collection<Skill> skills = this.getAllSkills();
                if (skills == null) break;
                for (Skill sk : skills) {
                    if (sk == null || sk.isPassive() || sk.getTargetType() == L2TargetType.SELF || sk.getCastRange() < 200) continue;
                    skilldata.add(sk);
                }
                break;
            }
            case 1: {
                for (Skill sk : this.getTemplate().getAISkills(AISkillScope.UNIVERSAL)) {
                    if (sk.getCastRange() < 200) continue;
                    skilldata.add(sk);
                }
                break;
            }
            default: {
                for (Skill sk : this.getAllSkills()) {
                    if (sk.getId() != this.getTemplate().getLongRangeSkillId()) continue;
                    skilldata.add(sk);
                }
            }
        }
        return skilldata;
    }

    public List<Skill> getShortRangeSkill() {
        ArrayList<Skill> skilldata = new ArrayList<Skill>();
        if (this.getTemplate().getShortRangeSkillId() == 0) {
            return skilldata;
        }
        switch (this.getTemplate().getShortRangeSkillId()) {
            case -1: {
                Collection<Skill> skills = this.getAllSkills();
                if (skills == null) break;
                for (Skill sk : skills) {
                    if (sk == null || sk.isPassive() || sk.getTargetType() == L2TargetType.SELF || sk.getCastRange() > 200) continue;
                    skilldata.add(sk);
                }
                break;
            }
            case 1: {
                for (Skill sk : this.getTemplate().getAISkills(AISkillScope.UNIVERSAL)) {
                    if (sk.getCastRange() > 200) continue;
                    skilldata.add(sk);
                }
                break;
            }
            default: {
                for (Skill sk : this.getAllSkills()) {
                    if (sk.getId() != this.getTemplate().getShortRangeSkillId()) continue;
                    skilldata.add(sk);
                }
            }
        }
        return skilldata;
    }

    public void onRandomAnimation(int animationId) {
        long now = System.currentTimeMillis();
        if (now - this._lastSocialBroadcast > 6000L) {
            this._lastSocialBroadcast = now;
            this.broadcastPacket(new SocialAction(this.getObjectId(), animationId));
        }
    }

    public void startRandomAnimationTimer() {
        this.startRandomAnimationTimer(null);
    }

    void startRandomAnimationTimer(RandomAnimationTask task) {
        if (!this.isInActiveRegion() || this.isDead() || !this.isVisible() || this.isInCombat() || !this.isRandomAnimationEnabled()) {
            this._rAniTask = null;
            return;
        }
        int minWait = this.isMob() ? Config.MIN_MONSTER_ANIMATION : Config.MIN_NPC_ANIMATION;
        int maxWait = this.isMob() ? Config.MAX_MONSTER_ANIMATION : Config.MAX_NPC_ANIMATION;
        int interval = Rnd.get(minWait, maxWait) * 1000;
        if (task == null) {
            task = new RandomAnimationTask();
        }
        this._rAniTask = task;
        ThreadPoolManager.getInstance().scheduleGeneral(task, interval);
    }

    public boolean hasRandomAnimation() {
        return Config.MAX_NPC_ANIMATION > 0 && this._isRandomAnimationEnabled;
    }

    public final void setRandomAnimationEnabled(boolean val) {
        this._isRandomAnimationEnabled = val;
    }

    public final boolean isRandomAnimationEnabled() {
        return this._isRandomAnimationEnabled;
    }

    public L2Npc(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2Npc);
        this.initCharStatusUpdateValues();
        this._currentLHandId = this.getTemplate().getLHandId();
        this._currentRHandId = this.getTemplate().getRHandId();
        this._currentEnchant = Config.ENABLE_RANDOM_ENCHANT_EFFECT ? Rnd.get(4, 21) : this.getTemplate().getWeaponEnchant();
        this._currentCollisionHeight = this.getTemplate().getfCollisionHeight();
        this._currentCollisionRadius = this.getTemplate().getfCollisionRadius();
        this.setName(template.getName());
        this.setTitle(template.getTitle());
        if (template.getAIType() == AIType.CORPSE) {
            this._isRandomAnimationEnabled = false;
        }
        if (Arrays.binarySearch(Config.NON_RANDOM_ANIMATION_NPCS, this.getNpcId()) >= 0) {
            this._isRandomAnimationEnabled = false;
        }
    }

    @Override
    public NpcKnownList getKnownList() {
        return (NpcKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new NpcKnownList(this));
    }

    @Override
    public NpcStat getStat() {
        return (NpcStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new NpcStat(this));
    }

    @Override
    public NpcStatus getStatus() {
        return (NpcStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new NpcStatus(this));
    }

    @Override
    public final L2NpcTemplate getTemplate() {
        return (L2NpcTemplate)super.getTemplate();
    }

    @Override
    public int getId() {
        return this.getTemplate().getId();
    }

    public int getNpcId() {
        return this.getId();
    }

    @Override
    public boolean canBeAttacked() {
        return Config.ALT_ATTACKABLE_NPCS;
    }

    @Override
    public final int getLevel() {
        return this.getTemplate().getLevel();
    }

    public boolean isAggressive() {
        return false;
    }

    public int getAggroRange() {
        return this.getAIValue("aggroRange", this.getTemplate().getAggroRange());
    }

    public boolean isInMyClan(L2Npc npc) {
        return this.getTemplate().isClan(npc.getTemplate().getClans());
    }

    public boolean isInEnemyClan(L2Npc npc) {
        return this.getTemplate().isEnemyClan(npc.getTemplate().getClans());
    }

    @Override
    public boolean isUndead() {
        return this.getTemplate().getRace() == NpcRace.UNDEAD;
    }

    @Override
    public void updateAbnormalEffect() {
        Collection plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null) continue;
            if (this.getRunSpeed() == 0) {
                player.sendPacket(new ServerObjectInfo(this, player));
                continue;
            }
            player.sendPacket(new AbstractNpcInfo.NpcInfo(this, player));
        }
    }

    public int getDistanceToWatchObject(L2Object object) {
        if (object instanceof L2FestivalGuideInstance) {
            return 10000;
        }
        if (object instanceof L2NpcInstance || !(object instanceof L2Character)) {
            return 0;
        }
        if (object instanceof L2Playable) {
            return 1500;
        }
        return 500;
    }

    public int getDistanceToForgetObject(L2Object object) {
        return 2 * this.getDistanceToWatchObject(object);
    }

    public boolean isEventMob() {
        return this._eventMob;
    }

    public void setEventMob(boolean val) {
        this._eventMob = val;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return this._isAutoAttackable;
    }

    public void setAutoAttackable(boolean flag) {
        this._isAutoAttackable = flag;
    }

    public int getLeftHandItem() {
        return this._currentLHandId;
    }

    public int getRightHandItem() {
        return this._currentRHandId;
    }

    public int getEnchantEffect() {
        return this._currentEnchant;
    }

    public final boolean isBusy() {
        return this._isBusy;
    }

    public void setBusy(boolean isBusy) {
        this._isBusy = isBusy;
    }

    public final String getBusyMessage() {
        return this._busyMessage;
    }

    public void setBusyMessage(String message) {
        this._busyMessage = message;
    }

    public boolean isWarehouse() {
        return this.getId() == 32478;
    }

    public boolean canTarget(L2PcInstance player) {
        if (player.isOutOfControl()) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (player.isLockedTarget() && player.getLockedTarget() != this) {
            player.sendPacket(SystemMessageId.FAILED_CHANGE_TARGET);
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        return true;
    }

    public boolean canInteract(L2PcInstance player) {
        if (player.isCastingNow() || player.isCastingSimultaneouslyNow()) {
            return false;
        }
        if (player.isDead() || player.isFakeDeath()) {
            return false;
        }
        if (player.isSitting()) {
            return false;
        }
        if (player.getPrivateStoreType() != PrivateStoreType.NONE) {
            return false;
        }
        if (!this.isInsideRadius(player, 150, true, false)) {
            return false;
        }
        if (player.getInstanceId() != this.getInstanceId() && player.getInstanceId() != -1) {
            return false;
        }
        return !this.isBusy();
    }

    public final Castle getCastle() {
        if (this._castleIndex < 0) {
            L2TownZone town = TownManager.getTown(this.getX(), this.getY(), this.getZ());
            if (town != null) {
                this._castleIndex = CastleManager.getInstance().getCastleIndex(town.getTaxById());
            }
            if (this._castleIndex < 0) {
                this._castleIndex = CastleManager.getInstance().findNearestCastleIndex(this);
            } else {
                this._isInTown = true;
            }
        }
        if (this._castleIndex < 0) {
            return null;
        }
        return CastleManager.getInstance().getCastles().get(this._castleIndex);
    }

    public boolean isMyLord(L2PcInstance player) {
        if (player.isClanLeader()) {
            int castleId = this.getCastle() != null ? this.getCastle().getResidenceId() : -1;
            int fortId = this.getFort() != null ? this.getFort().getResidenceId() : -1;
            return player.getClan().getCastleId() == castleId || player.getClan().getFortId() == fortId;
        }
        return false;
    }

    public final SiegableHall getConquerableHall() {
        return CHSiegeManager.getInstance().getNearbyClanHall(this.getX(), this.getY(), 10000);
    }

    public final Castle getCastle(long maxDistance) {
        int index = CastleManager.getInstance().findNearestCastleIndex(this, maxDistance);
        if (index < 0) {
            return null;
        }
        return CastleManager.getInstance().getCastles().get(index);
    }

    public final Fort getFort() {
        if (this._fortIndex < 0) {
            Fort fort = FortManager.getInstance().getFort(this.getX(), this.getY(), this.getZ());
            if (fort != null) {
                this._fortIndex = FortManager.getInstance().getFortIndex(fort.getResidenceId());
            }
            if (this._fortIndex < 0) {
                this._fortIndex = FortManager.getInstance().findNearestFortIndex(this);
            }
        }
        if (this._fortIndex < 0) {
            return null;
        }
        return FortManager.getInstance().getForts().get(this._fortIndex);
    }

    public final Fort getFort(long maxDistance) {
        int index = FortManager.getInstance().findNearestFortIndex(this, maxDistance);
        if (index < 0) {
            return null;
        }
        return FortManager.getInstance().getForts().get(index);
    }

    public final boolean getIsInTown() {
        if (this._castleIndex < 0) {
            this.getCastle();
        }
        return this._isInTown;
    }

    public void onBypassFeedback(L2PcInstance player, String command) {
        if (this.isBusy() && this.getBusyMessage().length() > 0) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile(player.getHtmlPrefix(), "data/html/npcbusy.htm");
            html.replace((CharSequence)"%busymessage%", this.getBusyMessage());
            html.replace((CharSequence)"%npcname%", this.getName());
            html.replace((CharSequence)"%playername%", player.getName());
            player.sendPacket(html);
        } else {
            IBypassHandler handler = BypassHandler.getInstance().getHandler(command);
            if (handler != null) {
                handler.useBypass(command, player, this);
            } else {
                _log.info(this.getClass().getSimpleName() + ": Unknown NPC bypass: \"" + command + "\" NpcId: " + this.getId());
            }
        }
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        int weaponId = this.getTemplate().getRHandId();
        if (weaponId < 1) {
            return null;
        }
        L2Item item = ItemTable.getInstance().getTemplate(this.getTemplate().getRHandId());
        if (!(item instanceof L2Weapon)) {
            return null;
        }
        return (L2Weapon)item;
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        int weaponId = this.getTemplate().getLHandId();
        if (weaponId < 1) {
            return null;
        }
        L2Item item = ItemTable.getInstance().getTemplate(this.getTemplate().getLHandId());
        if (!(item instanceof L2Weapon)) {
            return null;
        }
        return (L2Weapon)item;
    }

    public void insertObjectIdAndShowChatWindow(L2PcInstance player, String content) {
        content = content.replaceAll("%objectId%", String.valueOf(this.getObjectId()));
        player.sendPacket(new NpcHtmlMessage(this.getObjectId(), content));
    }

    public String getHtmlPath(String prefix, int npcId, int val) {
        StringBuilder pom = new StringBuilder(64).append(prefix);
        if (npcId != 0) {
            pom.append(npcId);
        }
        if (val != 0) {
            pom.append('-').append(val);
        }
        return pom.append(".htm").toString();
    }

    public String getHtmlPath(String prefix, int npcId, int val, String defaultPath) {
        String temp = this.getHtmlPath(prefix, npcId, val);
        if (HtmCache.getInstance().getHtm(null, temp) != null) {
            return temp;
        }
        if (defaultPath != null) {
            return defaultPath;
        }
        return "data/html/npcdefault.htm";
    }

    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/default/", npcId, val, null);
    }

    public void showChatWindow(L2PcInstance player) {
        this.showChatWindow(player, 0);
    }

    private boolean showPkDenyChatWindow(L2PcInstance player, String type) {
        String html = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/" + type + "/" + this.getId() + "-pk.htm");
        if (html != null) {
            this.insertObjectIdAndShowChatWindow(player, html);
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return true;
        }
        return false;
    }

    public void showChatWindow(L2PcInstance player, int val) {
        if (Config.NON_TALKING_NPCS.contains(this.getId())) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!(!player.isCursedWeaponEquipped() || player.getTarget() instanceof L2ClanHallManagerInstance && player.getTarget() instanceof L2DoormenInstance)) {
            player.setTarget(player);
            return;
        }
        if (player.getKarma() > 0 && (!Config.ALT_GAME_KARMA_PLAYER_CAN_SHOP && this instanceof L2MerchantInstance ? this.showPkDenyChatWindow(player, "merchant") : (!Config.ALT_GAME_KARMA_PLAYER_CAN_USE_GK && this instanceof L2TeleporterInstance ? this.showPkDenyChatWindow(player, "teleporter") : (!Config.ALT_GAME_KARMA_PLAYER_CAN_USE_WAREHOUSE && this instanceof L2WarehouseInstance ? this.showPkDenyChatWindow(player, "warehouse") : !Config.ALT_GAME_KARMA_PLAYER_CAN_SHOP && this instanceof L2FishermanInstance && this.showPkDenyChatWindow(player, "fisherman"))))) {
            return;
        }
        if (this.getTemplate().isType("L2Auctioneer") && val == 0) {
            return;
        }
        int npcId = this.getTemplate().getId();
        String filename = "data/html/seven_signs/";
        int sealAvariceOwner = SevenSigns.getInstance().getSealOwner(1);
        int sealGnosisOwner = SevenSigns.getInstance().getSealOwner(2);
        int playerCabal = SevenSigns.getInstance().getPlayerCabal(player.getObjectId());
        int compWinner = SevenSigns.getInstance().getCabalHighestScore();
        switch (npcId) {
            case 31127: 
            case 31128: 
            case 31129: 
            case 31130: 
            case 31131: {
                filename = filename + "festival/dawn_guide.htm";
                break;
            }
            case 31137: 
            case 31138: 
            case 31139: 
            case 31140: 
            case 31141: {
                filename = filename + "festival/dusk_guide.htm";
                break;
            }
            case 31092: {
                filename = filename + "blkmrkt_1.htm";
                break;
            }
            case 31113: {
                if (Config.ALT_STRICT_SEVENSIGNS) {
                    switch (compWinner) {
                        case 2: {
                            if (playerCabal == compWinner && playerCabal == sealAvariceOwner) break;
                            player.sendPacket(SystemMessageId.CAN_BE_USED_BY_DAWN);
                            player.sendPacket(ActionFailed.STATIC_PACKET);
                            return;
                        }
                        case 1: {
                            if (playerCabal == compWinner && playerCabal == sealAvariceOwner) break;
                            player.sendPacket(SystemMessageId.CAN_BE_USED_BY_DUSK);
                            player.sendPacket(ActionFailed.STATIC_PACKET);
                            return;
                        }
                        default: {
                            player.sendPacket(SystemMessageId.SSQ_COMPETITION_UNDERWAY);
                            return;
                        }
                    }
                }
                filename = filename + "mammmerch_1.htm";
                break;
            }
            case 31126: {
                if (Config.ALT_STRICT_SEVENSIGNS) {
                    switch (compWinner) {
                        case 2: {
                            if (playerCabal == compWinner && playerCabal == sealGnosisOwner) break;
                            player.sendPacket(SystemMessageId.CAN_BE_USED_BY_DAWN);
                            player.sendPacket(ActionFailed.STATIC_PACKET);
                            return;
                        }
                        case 1: {
                            if (playerCabal == compWinner && playerCabal == sealGnosisOwner) break;
                            player.sendPacket(SystemMessageId.CAN_BE_USED_BY_DUSK);
                            player.sendPacket(ActionFailed.STATIC_PACKET);
                            return;
                        }
                        default: {
                            player.sendPacket(SystemMessageId.SSQ_COMPETITION_UNDERWAY);
                            return;
                        }
                    }
                }
                filename = filename + "mammblack_1.htm";
                break;
            }
            case 31132: 
            case 31133: 
            case 31134: 
            case 31135: 
            case 31136: 
            case 31142: 
            case 31143: 
            case 31144: 
            case 31145: 
            case 31146: {
                filename = filename + "festival/festival_witch.htm";
                break;
            }
            case 31688: {
                if (player.isNoble()) {
                    filename = "data/html/olympiad/noble_main.htm";
                    break;
                }
                filename = this.getHtmlPath(npcId, val);
                break;
            }
            case 31690: 
            case 31769: 
            case 31770: 
            case 31771: 
            case 31772: {
                if (player.isHero() || player.isNoble()) {
                    filename = "data/html/olympiad/hero_main.htm";
                    break;
                }
                filename = this.getHtmlPath(npcId, val);
                break;
            }
            case 36402: {
                if (player.olyBuff > 0) {
                    filename = player.olyBuff == 5 ? "data/html/olympiad/olympiad_buffs.htm" : "data/html/olympiad/olympiad_5buffs.htm";
                    break;
                }
                filename = "data/html/olympiad/olympiad_nobuffs.htm";
                break;
            }
            case 30298: {
                if (player.isAcademyMember()) {
                    filename = this.getHtmlPath(npcId, 1);
                    break;
                }
                filename = this.getHtmlPath(npcId, val);
                break;
            }
            default: {
                if (npcId >= 31865 && npcId <= 31918) {
                    if (val == 0) {
                        filename = filename + "rift/GuardianOfBorder.htm";
                        break;
                    }
                    filename = filename + "rift/GuardianOfBorder-" + val + ".htm";
                    break;
                }
                if (npcId >= 31093 && npcId <= 31094 || npcId >= 31172 && npcId <= 31201 || npcId >= 31239 && npcId <= 31254) {
                    return;
                }
                filename = this.getHtmlPath(npcId, val);
            }
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        if (Config.ALLOW_RENTPET && this instanceof L2MerchantInstance && Config.LIST_PET_RENT_NPC.contains(npcId)) {
            html.replace((CharSequence)"_Quest", "_RentPet\">\u30da\u30c3\u30c8\u3092\u30ec\u30f3\u30bf\u30eb\u3059\u308b\u3002</a><br><a action=\"bypass -h npc_%objectId%_Quest");
        }
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%festivalMins%", SevenSignsFestival.getInstance().getTimeToNextFestivalStr());
        player.sendPacket(html);
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void showChatWindow(L2PcInstance player, String filename) {
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        player.sendPacket(html);
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public long getExpReward() {
        return (long)((double)(this.getLevel() * this.getLevel()) * this.getTemplate().getExpRate() * (double)Config.RATE_XP);
    }

    public int getSpReward() {
        return (int)(this.getTemplate().getSP() * (double)Config.RATE_SP);
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        this._currentLHandId = this.getTemplate().getLHandId();
        this._currentRHandId = this.getTemplate().getRHandId();
        this._currentCollisionHeight = this.getTemplate().getfCollisionHeight();
        this._currentCollisionRadius = this.getTemplate().getfCollisionRadius();
        DecayTaskManager.getInstance().add(this);
        return true;
    }

    public void setSpawn(L2Spawn spawn) {
        this._spawn = spawn;
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this._soulshotamount = this.getTemplate().getSoulShot();
        this._spiritshotamount = this.getTemplate().getSpiritShot();
        List<Quest> eventQuests = this.getTemplate().getEventQuests(QuestEventType.ON_SPAWN);
        if (eventQuests != null) {
            for (Quest quest : eventQuests) {
                quest.notifySpawn(this);
            }
        }
        if (!this.isTeleporting()) {
            WalkingManager.getInstance().onSpawn(this);
        }
    }

    @Override
    public void onDecay() {
        if (this.isDecayed()) {
            return;
        }
        this.setDecayed(true);
        super.onDecay();
        if (this._spawn != null) {
            this._spawn.decreaseCount(this);
        }
        WalkingManager.getInstance().onDeath(this);
    }

    @Override
    public boolean deleteMe() {
        L2WorldRegion oldRegion = this.getWorldRegion();
        try {
            this.onDecay();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed decayMe().", e);
        }
        if (this.isChannelized()) {
            this.getSkillChannelized().abortChannelization();
        }
        if (oldRegion != null) {
            oldRegion.removeFromZones(this);
        }
        try {
            this.getKnownList().removeAllKnownObjects();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed removing cleaning knownlist.", e);
        }
        L2World.getInstance().removeObject(this);
        return super.deleteMe();
    }

    public L2Spawn getSpawn() {
        return this._spawn;
    }

    public final ILocational getSpawnPoint() {
        return this.getSpawn().getLocation(this);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.getName() + "(" + this.getId() + ")" + "[" + this.getObjectId() + "]";
    }

    public boolean isDecayed() {
        return this._isDecayed;
    }

    public void setDecayed(boolean decayed) {
        this._isDecayed = decayed;
    }

    public void endDecayTask() {
        if (!this.isDecayed()) {
            DecayTaskManager.getInstance().cancel(this);
            this.onDecay();
        }
    }

    public boolean isMob() {
        return false;
    }

    public void setLHandId(int newWeaponId) {
        this._currentLHandId = newWeaponId;
        this.updateAbnormalEffect();
    }

    public void setRHandId(int newWeaponId) {
        this._currentRHandId = newWeaponId;
        this.updateAbnormalEffect();
    }

    public void setLRHandId(int newLWeaponId, int newRWeaponId) {
        this._currentRHandId = newRWeaponId;
        this._currentLHandId = newLWeaponId;
        this.updateAbnormalEffect();
    }

    public void setEnchant(int newEnchantValue) {
        this._currentEnchant = newEnchantValue;
        this.updateAbnormalEffect();
    }

    public boolean isShowName() {
        return this.getTemplate().isShowName();
    }

    @Override
    public boolean isTargetable() {
        return this.getTemplate().isTargetable();
    }

    public void setCollisionHeight(double height) {
        this._currentCollisionHeight = height;
    }

    public void setCollisionRadius(double radius) {
        this._currentCollisionRadius = radius;
    }

    public double getCollisionHeight() {
        return this._currentCollisionHeight;
    }

    public double getCollisionRadius() {
        return this._currentCollisionRadius;
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (Config.CHECK_KNOWN && activeChar.isGM()) {
            activeChar.sendMessage("Added NPC: " + this.getName());
        }
        if (this.getRunSpeed() == 0) {
            activeChar.sendPacket(new ServerObjectInfo(this, activeChar));
        } else {
            activeChar.sendPacket(new AbstractNpcInfo.NpcInfo(this, activeChar));
        }
    }

    public void showNoTeachHtml(L2PcInstance player) {
        int npcId = this.getId();
        String html = "";
        if (this instanceof L2WarehouseInstance) {
            html = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/warehouse/" + npcId + "-noteach.htm");
        } else if (this instanceof L2TrainerInstance && (html = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/trainer/" + npcId + "-noteach.htm")) == null) {
            html = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/scripts/ai/npc/Trainers/HealerTrainer/" + npcId + "-noteach.html");
        }
        NpcHtmlMessage noTeachMsg = new NpcHtmlMessage(this.getObjectId());
        if (html == null) {
            _log.warning("Npc " + npcId + " missing noTeach html!");
            noTeachMsg.setHtml("<html><body>I cannot teach you any skills.<br>You must find your current class teachers.</body></html>");
        } else {
            noTeachMsg.setHtml(html);
            noTeachMsg.replace((CharSequence)"%objectId%", this.getObjectId());
        }
        player.sendPacket(noTeachMsg);
    }

    public L2Npc scheduleDespawn(long delay) {
        ThreadPoolManager.getInstance().scheduleGeneral(new DespawnTask(), delay);
        return this;
    }

    @Override
    protected final void notifyQuestEventSkillFinished(Skill skill, L2Object target) {
        try {
            List<Quest> eventQuests = this.getTemplate().getEventQuests(QuestEventType.ON_SPELL_FINISHED);
            if (eventQuests != null) {
                L2PcInstance player = null;
                if (target != null) {
                    player = target.getActingPlayer();
                }
                for (Quest quest : eventQuests) {
                    quest.notifySpellFinished(this, player, skill);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "", e);
        }
    }

    @Override
    public boolean isMovementDisabled() {
        return super.isMovementDisabled() || !this.canMove() || this.getAiType() == AIType.CORPSE;
    }

    public AIType getAiType() {
        return this.getTemplate().getAIType();
    }

    public void setDisplayEffect(int val) {
        if (val != this._displayEffect) {
            this._displayEffect = val;
            this.broadcastPacket(new ExChangeNpcState(this.getObjectId(), val));
        }
    }

    public int getDisplayEffect() {
        return this._displayEffect;
    }

    public int getColorEffect() {
        return 0;
    }

    @Override
    public boolean isNpc() {
        return true;
    }

    @Override
    public void setTeam(Team team) {
        super.setTeam(team);
        for (L2PcInstance player : this.getKnownList().getKnownPlayers().values()) {
            player.sendPacket(new AbstractNpcInfo.NpcInfo(this, player));
        }
    }

    @Override
    public boolean isWalker() {
        return WalkingManager.getInstance().isRegistered(this);
    }

    @Override
    public boolean isChargedShot(ShotType type) {
        return (this._shotsMask & type.getMask()) != 0;
    }

    @Override
    public void setChargedShot(ShotType type, boolean charged) {
        this._shotsMask = charged ? (this._shotsMask |= type.getMask()) : (this._shotsMask &= ~type.getMask());
    }

    @Override
    public void rechargeShots(boolean physical, boolean magic) {
        if (this._soulshotamount > 0 || this._spiritshotamount > 0) {
            if (physical) {
                if (this._soulshotamount == 0) {
                    return;
                }
                if (Rnd.get(100) > this.getSoulShotChance()) {
                    return;
                }
                --this._soulshotamount;
                Broadcast.toSelfAndKnownPlayersInRadius(this, new MagicSkillUse(this, this, 2154, 1, 0, 0), 600);
                this.setChargedShot(ShotType.SOULSHOTS, true);
            }
            if (magic) {
                if (this._spiritshotamount == 0) {
                    return;
                }
                if (Rnd.get(100) > this.getSpiritShotChance()) {
                    return;
                }
                --this._spiritshotamount;
                Broadcast.toSelfAndKnownPlayersInRadius(this, new MagicSkillUse(this, this, 2061, 1, 0, 0), 600);
                this.setChargedShot(ShotType.SPIRITSHOTS, true);
            }
        }
    }

    public int getScriptValue() {
        return this.getVariables().getInt("SCRIPT_VAL");
    }

    public void setScriptValue(int val) {
        this.getVariables().set("SCRIPT_VAL", val);
    }

    public boolean isScriptValue(int val) {
        return this.getVariables().getInt("SCRIPT_VAL") == val;
    }

    public boolean compareAndSetScriptValue(int expect, int update) {
        assert (expect != update);
        NpcVariables npcVariables = this.getVariables();
        if (npcVariables.getInt("SCRIPT_VAL") == expect) {
            npcVariables.set("SCRIPT_VAL", update);
            return true;
        }
        return false;
    }

    public boolean compareAndSetScriptValue(String key, boolean expect, boolean update) {
        assert (expect != update);
        NpcVariables npcVariables = this.getVariables();
        if (npcVariables.getBoolean(key, false) == expect) {
            npcVariables.set(key, update);
            return true;
        }
        return false;
    }

    public int getAIValue(String paramName) {
        return this.getAIValue(paramName, -1);
    }

    public int getAIValue(String paramName, int defaultValue) {
        L2Spawn spawn = this.getSpawn();
        if (spawn == null) {
            return defaultValue;
        }
        String name = spawn.getName();
        if (name == null) {
            return defaultValue;
        }
        return NpcPersonalAIData.getInstance().getAIValue(name, paramName, defaultValue);
    }

    public boolean hasAIValue(String paramName) {
        String name;
        L2Spawn spawn = this.getSpawn();
        return spawn != null && (name = spawn.getName()) != null && NpcPersonalAIData.getInstance().hasAIValue(name, paramName);
    }

    public boolean isInMySpawnGroup(L2Npc npc) {
        L2Spawn npcSpawn;
        L2Spawn mySpawn = this.getSpawn();
        return mySpawn != null && (npcSpawn = npc.getSpawn()) != null && mySpawn.getName() != null && mySpawn.getName().equals(npcSpawn.getName());
    }

    public boolean staysInSpawnLoc() {
        L2Spawn spawn = this.getSpawn();
        return spawn != null && spawn.getX(this) == this.getX() && spawn.getY(this) == this.getY();
    }

    public boolean hasVariables() {
        return this.getScript(NpcVariables.class) != null;
    }

    public NpcVariables getVariables() {
        NpcVariables vars = this.getScript(NpcVariables.class);
        return vars != null ? vars : this.addScript(new NpcVariables());
    }

    @Deprecated
    public void broadcastEvent(String eventName, int radius, L2Object reference) {
        for (L2Object obj : L2World.getInstance().getVisibleObjects(this, radius)) {
            List<Quest> eventQuests;
            if (!obj.isNpc() || (eventQuests = ((L2Npc)obj).getTemplate().getEventQuests(QuestEventType.ON_EVENT_RECEIVED)) == null) continue;
            for (Quest quest : eventQuests) {
                quest.notifyEventReceived(eventName, this, (L2Npc)obj, reference);
            }
        }
    }

    public Location getPointInRange(int radiusMin, int radiusMax) {
        if (radiusMax == 0 || radiusMax < radiusMin) {
            return new Location(this.getX(), this.getY(), this.getZ());
        }
        int radius = Rnd.get(radiusMin, radiusMax);
        double angle = Rnd.nextDouble() * 2.0 * Math.PI;
        return new Location((int)((double)this.getX() + (double)radius * Math.cos(angle)), (int)((double)this.getY() + (double)radius * Math.sin(angle)), this.getZ());
    }

    @Override
    public boolean isInCategory(CategoryType type) {
        return CategoryData.getInstance().isInCategory(type, this.getId());
    }

    public L2ItemInstance dropItem(L2PcInstance player, int itemId, long itemCount) {
        L2ItemInstance item = null;
        int i = 0;
        while ((long)i < itemCount) {
            int newX = this.getX() + Rnd.get(-70, 70);
            int newY = this.getY() + Rnd.get(-70, 70);
            int newZ = this.getZ() + 20;
            if (ItemTable.getInstance().getTemplate(itemId) == null) {
                _log.log(Level.SEVERE, "Item doesn't exist so cannot be dropped. Item ID: " + itemId + " Quest: " + this.getName());
                return null;
            }
            item = ItemTable.getInstance().createItem("Loot", itemId, itemCount, player, this);
            if (item == null) {
                return null;
            }
            if (player != null) {
                item.getDropProtection().protect(player);
            }
            item.dropMe(this, newX, newY, newZ);
            if (!Config.LIST_PROTECTED_ITEMS.contains(itemId) && (Config.AUTODESTROY_ITEM_AFTER > 0 && !item.getItem().hasExImmediateEffect() || Config.HERB_AUTO_DESTROY_TIME > 0 && item.getItem().hasExImmediateEffect())) {
                ItemsAutoDestroy.getInstance().addItem(item);
            }
            item.setProtected(false);
            if (item.isStackable() || !Config.MULTIPLE_ITEM_DROP) break;
            ++i;
        }
        return item;
    }

    public L2ItemInstance dropItem(L2PcInstance player, ItemHolder item) {
        return this.dropItem(player, item.getId(), item.getCount());
    }

    @Override
    public final String getName() {
        return super.getName();
    }

    protected class DespawnTask
    implements Runnable {
        protected DespawnTask() {
        }

        @Override
        public void run() {
            if (!L2Npc.this.isDecayed()) {
                L2Npc.this.deleteMe();
            }
        }
    }

    protected class RandomAnimationTask
    implements Runnable {
        protected RandomAnimationTask() {
        }

        @Override
        public void run() {
            try {
                if (this != L2Npc.this._rAniTask) {
                    return;
                }
                if (!L2Npc.this.isInActiveRegion() || L2Npc.this.isDead() || !L2Npc.this.isVisible() || L2Npc.this.isInCombat() || !L2Npc.this.isRandomAnimationEnabled()) {
                    L2Npc.this._rAniTask = null;
                    return;
                }
                if (L2Npc.this.isMob() && (!L2Npc.this.hasAI() || L2Npc.this.getAI().getIntention() != CtrlIntention.AI_INTENTION_ACTIVE)) {
                    L2Npc.this._rAniTask = null;
                    return;
                }
                if (!(L2Npc.this.getKnownList().getKnownPlayers().isEmpty() || L2Npc.this.isMoving() || L2Npc.this.isStunned() || L2Npc.this.isSleeping() || L2Npc.this.isParalyzed())) {
                    L2Npc.this.onRandomAnimation(Rnd.get(2, 3));
                }
                L2Npc.this.startRandomAnimationTimer(this);
            }
            catch (Exception e) {
                L2Character._log.log(Level.SEVERE, "", e);
            }
        }
    }
}

