/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class TerritoryWard {
    protected L2PcInstance _player = null;
    public int playerId = 0;
    private L2ItemInstance _item = null;
    private L2Npc _npc = null;
    private Location _location;
    private Location _oldLocation;
    private final int _itemId;
    private int _ownerCastleId;
    private final int _territoryId;

    public TerritoryWard(int territory_id, int x, int y, int z, int heading, int item_id, int castleId, L2Npc npc) {
        this._territoryId = territory_id;
        this._location = new Location(x, y, z, heading);
        this._itemId = item_id;
        this._ownerCastleId = castleId;
        this._npc = npc;
    }

    public int getTerritoryId() {
        return this._territoryId;
    }

    public int getOwnerCastleId() {
        return this._ownerCastleId;
    }

    public void setOwnerCastleId(int newOwner) {
        this._ownerCastleId = newOwner;
    }

    public L2Npc getNpc() {
        return this._npc;
    }

    public void setNpc(L2Npc npc) {
        this._npc = npc;
    }

    public L2PcInstance getPlayer() {
        return this._player;
    }

    public synchronized void spawnBack() {
        if (this._player != null) {
            this.dropIt();
        }
        this._npc = TerritoryWarManager.getInstance().spawnNPC(36491 + this._territoryId, this._oldLocation);
    }

    public synchronized void spawnMe() {
        if (this._player != null) {
            this.dropIt();
        }
        this._npc = TerritoryWarManager.getInstance().spawnNPC(36491 + this._territoryId, this._location);
    }

    public synchronized void unSpawnMe() {
        if (this._player != null) {
            this.dropIt();
        }
        if (this._npc != null && !this._npc.isDecayed()) {
            this._npc.deleteMe();
        }
    }

    public boolean activate(L2PcInstance player, L2ItemInstance item) {
        if (player.isMounted()) {
            player.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
            player.destroyItem("CombatFlag", item, null, true);
            this.spawnMe();
            return false;
        }
        if (TerritoryWarManager.getInstance().getRegisteredTerritoryId(player) == 0) {
            player.sendMessage("Non participants can't pickup Territory Wards!");
            player.destroyItem("CombatFlag", item, null, true);
            this.spawnMe();
            return false;
        }
        this._player = player;
        this.playerId = this._player.getObjectId();
        this._oldLocation = new Location(this._npc.getX(), this._npc.getY(), this._npc.getZ(), this._npc.getHeading());
        this._npc = null;
        this._item = item == null ? ItemTable.getInstance().createItem("Combat", this._itemId, 1L, null, null) : item;
        this._player.getInventory().equipItem(this._item);
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_EQUIPPED);
        sm.addItemName(this._item);
        this._player.sendPacket(sm);
        if (!Config.FORCE_INVENTORY_UPDATE) {
            InventoryUpdate iu = new InventoryUpdate();
            iu.addItem(this._item);
            this._player.sendPacket(iu);
        } else {
            this._player.sendPacket(new ItemList(this._player, false));
        }
        this._player.broadcastUserInfo();
        this._player.setCombatFlagEquipped(true);
        this._player.sendPacket(SystemMessageId.YOU_VE_ACQUIRED_THE_WARD);
        TerritoryWarManager.getInstance().giveTWPoint(player, this._territoryId, 5);
        return true;
    }

    public void dropIt() {
        this._player.setCombatFlagEquipped(false);
        int slot = this._player.getInventory().getSlotFromItem(this._item);
        this._player.getInventory().unEquipItemInBodySlot(slot);
        this._player.destroyItem("CombatFlag", this._item, null, true);
        this._item = null;
        this._player.broadcastUserInfo();
        this._location = new Location(this._player.getX(), this._player.getY(), this._player.getZ(), this._player.getHeading());
        this._player = null;
        this.playerId = 0;
    }
}

