/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.enums.ShortcutType;
import com.l2jserver.gameserver.model.Shortcut;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.interfaces.IRestorable;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.L2EtcItemType;
import com.l2jserver.gameserver.network.serverpackets.ExAutoSoulShot;
import com.l2jserver.gameserver.network.serverpackets.ShortCutInit;
import com.l2jserver.gameserver.network.serverpackets.ShortCutRegister;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.l2j.troja.FastIntObjectMap;

public class ShortCuts
implements IRestorable {
    private static Logger _log = Logger.getLogger(ShortCuts.class.getName());
    private static final int MAX_SHORTCUTS_PER_BAR = 12;
    private final L2PcInstance _owner;
    private final FastIntObjectMap<Shortcut> _shortCuts = new FastIntObjectMap();

    public ShortCuts(L2PcInstance owner) {
        this._owner = owner;
    }

    public Collection<Shortcut> getAllShortCuts() {
        return this._shortCuts.values();
    }

    public Shortcut getShortCut(int slot, int page) {
        Shortcut sc = (Shortcut)this._shortCuts.get(slot + page * 12);
        if (sc != null && sc.getType() == ShortcutType.ITEM && this._owner.getInventory().getItemByObjectId(sc.getId()) == null) {
            this.deleteShortCut(sc.getSlot(), sc.getPage());
            sc = null;
        }
        return sc;
    }

    public synchronized void registerShortCut(Shortcut shortcut) {
        if (shortcut.getType() == ShortcutType.ITEM) {
            L2ItemInstance item = this._owner.getInventory().getItemByObjectId(shortcut.getId());
            if (item == null) {
                return;
            }
            shortcut.setSharedReuseGroup(item.getSharedReuseGroup());
        }
        Shortcut oldShortCut = (Shortcut)this._shortCuts.put(shortcut.getSlot() + shortcut.getPage() * 12, (Object)shortcut);
        this.registerShortCutInDb(shortcut, oldShortCut);
    }

    private void registerShortCutInDb(Shortcut shortcut, Shortcut oldShortCut) {
        if (oldShortCut != null) {
            this.deleteShortCutFromDb(oldShortCut);
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("REPLACE INTO character_shortcuts (charId,slot,page,type,shortcut_id,level,class_index) values(?,?,?,?,?,?,?)");){
            statement.setInt(1, this._owner.getObjectId());
            statement.setInt(2, shortcut.getSlot());
            statement.setInt(3, shortcut.getPage());
            statement.setInt(4, shortcut.getType().ordinal());
            statement.setInt(5, shortcut.getId());
            statement.setInt(6, shortcut.getLevel());
            statement.setInt(7, this._owner.getClassIndex());
            statement.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not store character shortcut: " + e.getMessage(), e);
        }
    }

    public synchronized void deleteShortCut(int slot, int page) {
        L2ItemInstance item;
        Shortcut old = (Shortcut)this._shortCuts.remove(slot + page * 12);
        if (old == null || this._owner == null) {
            return;
        }
        this.deleteShortCutFromDb(old);
        if (old.getType() == ShortcutType.ITEM && (item = this._owner.getInventory().getItemByObjectId(old.getId())) != null && item.getItemType() == L2EtcItemType.SHOT && this._owner.removeAutoSoulShot(item.getId())) {
            this._owner.sendPacket(new ExAutoSoulShot(item.getId(), 0));
        }
        this._owner.sendPacket(new ShortCutInit(this._owner));
        for (int shotId : this._owner.getAutoSoulShot()) {
            this._owner.sendPacket(new ExAutoSoulShot(shotId, 1));
        }
    }

    public synchronized void deleteShortCutByObjectId(int objectId) {
        for (Shortcut shortcut : this._shortCuts.values()) {
            if (shortcut.getType() != ShortcutType.ITEM || shortcut.getId() != objectId) continue;
            this.deleteShortCut(shortcut.getSlot(), shortcut.getPage());
            break;
        }
    }

    private void deleteShortCutFromDb(Shortcut shortcut) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("DELETE FROM character_shortcuts WHERE charId=? AND slot=? AND page=? AND class_index=?");){
            statement.setInt(1, this._owner.getObjectId());
            statement.setInt(2, shortcut.getSlot());
            statement.setInt(3, shortcut.getPage());
            statement.setInt(4, this._owner.getClassIndex());
            statement.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not delete character shortcut: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean restoreMe() {
        this._shortCuts.clear();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT charId, slot, page, type, shortcut_id, level FROM character_shortcuts WHERE charId=? AND class_index=?");){
            statement.setInt(1, this._owner.getObjectId());
            statement.setInt(2, this._owner.getClassIndex());
            try (ResultSet rset = statement.executeQuery();){
                while (rset.next()) {
                    int slot = rset.getInt("slot");
                    int page = rset.getInt("page");
                    int type = rset.getInt("type");
                    int id = rset.getInt("shortcut_id");
                    int level = rset.getInt("level");
                    this._shortCuts.put(slot + page * 12, (Object)new Shortcut(slot, page, ShortcutType.values()[type], id, level, 1));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore character shortcuts: " + e.getMessage(), e);
            return false;
        }
        for (Shortcut sc : this.getAllShortCuts()) {
            if (sc.getType() != ShortcutType.ITEM) continue;
            L2ItemInstance item = this._owner.getInventory().getItemByObjectId(sc.getId());
            if (item == null) {
                this.deleteShortCut(sc.getSlot(), sc.getPage());
                continue;
            }
            if (!item.isEtcItem()) continue;
            sc.setSharedReuseGroup(item.getEtcItem().getSharedReuseGroup());
        }
        return true;
    }

    public synchronized void updateShortCuts(int skillId, int skillLevel) {
        for (Shortcut sc : this._shortCuts.values()) {
            if (sc.getId() != skillId || sc.getType() != ShortcutType.SKILL) continue;
            Shortcut newsc = new Shortcut(sc.getSlot(), sc.getPage(), sc.getType(), sc.getId(), skillLevel, 1);
            this._owner.sendPacket(new ShortCutRegister(newsc));
            this._owner.registerShortCut(newsc);
        }
    }
}

