/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class L2ContactList {
    private final Logger _log = Logger.getLogger(this.getClass().getName());
    private final L2PcInstance activeChar;
    private final List<String> _contacts;
    private final String QUERY_ADD = "INSERT INTO character_contacts (charId, contactId) VALUES (?, ?)";
    private final String QUERY_REMOVE = "DELETE FROM character_contacts WHERE charId = ? and contactId = ?";
    private final String QUERY_LOAD = "SELECT contactId FROM character_contacts WHERE charId = ?";

    public L2ContactList(L2PcInstance player) {
        this.activeChar = player;
        this._contacts = new FastList().shared();
        this.restore();
    }

    public void restore() {
        this._contacts.clear();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT contactId FROM character_contacts WHERE charId = ?");){
            statement.setInt(1, this.activeChar.getObjectId());
            try (ResultSet rset = statement.executeQuery();){
                while (rset.next()) {
                    int contactId = rset.getInt(1);
                    String contactName = CharNameTable.getInstance().getNameById(contactId);
                    if (contactName == null || contactName.equals(this.activeChar.getName()) || contactId == this.activeChar.getObjectId()) continue;
                    this._contacts.add(contactName);
                }
            }
        }
        catch (Exception e) {
            this._log.log(Level.WARNING, "Error found in " + this.activeChar.getName() + "'s ContactsList: " + e.getMessage(), e);
        }
    }

    public boolean add(String name) {
        int contactId = CharNameTable.getInstance().getIdByName(name);
        if (this._contacts.contains(name)) {
            this.activeChar.sendPacket(SystemMessageId.NAME_ALREADY_EXIST_ON_CONTACT_LIST);
            return false;
        }
        if (this.activeChar.getName().equals(name)) {
            this.activeChar.sendPacket(SystemMessageId.CANNOT_ADD_YOUR_NAME_ON_CONTACT_LIST);
            return false;
        }
        if (this._contacts.size() >= 100) {
            this.activeChar.sendPacket(SystemMessageId.CONTACT_LIST_LIMIT_REACHED);
            return false;
        }
        if (contactId < 1) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.NAME_S1_NOT_EXIST_TRY_ANOTHER_NAME);
            sm.addString(name);
            this.activeChar.sendPacket(sm);
            return false;
        }
        for (String contactName : this._contacts) {
            if (!contactName.equalsIgnoreCase(name)) continue;
            this.activeChar.sendPacket(SystemMessageId.NAME_ALREADY_EXIST_ON_CONTACT_LIST);
            return false;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("INSERT INTO character_contacts (charId, contactId) VALUES (?, ?)");){
            statement.setInt(1, this.activeChar.getObjectId());
            statement.setInt(2, contactId);
            statement.execute();
            this._contacts.add(name);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_SUCCESSFULLY_ADDED_TO_CONTACT_LIST);
            sm.addString(name);
            this.activeChar.sendPacket(sm);
        }
        catch (Exception e) {
            this._log.log(Level.WARNING, "Error found in " + this.activeChar.getName() + "'s ContactsList: " + e.getMessage(), e);
        }
        return true;
    }

    public void remove(String name) {
        int contactId = CharNameTable.getInstance().getIdByName(name);
        if (!this._contacts.contains(name)) {
            this.activeChar.sendPacket(SystemMessageId.NAME_NOT_REGISTERED_ON_CONTACT_LIST);
            return;
        }
        if (contactId < 1) {
            return;
        }
        this._contacts.remove(name);
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("DELETE FROM character_contacts WHERE charId = ? and contactId = ?");){
            statement.setInt(1, this.activeChar.getObjectId());
            statement.setInt(2, contactId);
            statement.execute();
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_SUCCESFULLY_DELETED_FROM_CONTACT_LIST);
            sm.addString(name);
            this.activeChar.sendPacket(sm);
        }
        catch (Exception e) {
            this._log.log(Level.WARNING, "Error found in " + this.activeChar.getName() + "'s ContactsList: " + e.getMessage(), e);
        }
    }

    public List<String> getAllContacts() {
        return this._contacts;
    }
}

