/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2NpcWalkerNode;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2WalkRoute;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.WalkInfo;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.holders.NpcRoutesHolder;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import jp.sf.l2j.troja.FastIntObjectMap;
import jp.sf.l2j.troja.IntObjectMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class WalkingManager
extends DocumentParser {
    public static final byte REPEAT_GO_BACK = 0;
    public static final byte REPEAT_GO_FIRST = 1;
    public static final byte REPEAT_TELE_FIRST = 2;
    public static final byte REPEAT_RANDOM = 3;
    private final HashMap<String, L2WalkRoute> _routes = new HashMap();
    private final FastIntObjectMap<WalkInfo> _activeRoutes = new FastIntObjectMap();
    private final FastIntObjectMap<NpcRoutesHolder> _routesToAttach = new FastIntObjectMap();
    private static final int MARKER_NPC = 1032467;
    private static final int MARKER_ITEM = 57;

    protected WalkingManager() {
        this.load();
    }

    @Override
    public final void load() {
        File[] walkerRoutesFiles;
        final Pattern pattern = Pattern.compile("Routes.*\\.xml");
        for (File file : walkerRoutesFiles = new File(Config.DATAPACK_ROOT, "data").listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && pattern.matcher(file.getName()).matches();
            }
        })) {
            this._log.info(this.getClass().getSimpleName() + ": Loading " + file.getName());
            this.parseFile(file);
        }
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + this._routes.size() + " walking routes.");
    }

    @Override
    protected void parseDocument() {
        Node n = this.getCurrentDocument().getFirstChild();
        for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
            if (!d.getNodeName().equals("route")) continue;
            String routeName = this.parseString(d.getAttributes(), "name");
            boolean repeat = this.parseBool(d.getAttributes(), "repeat");
            String repeatStyle = d.getAttributes().getNamedItem("repeatStyle").getNodeValue();
            byte repeatType = repeatStyle.equalsIgnoreCase("back") ? (byte)0 : (repeatStyle.equalsIgnoreCase("cycle") ? (byte)1 : (repeatStyle.equalsIgnoreCase("conveyor") ? (byte)2 : (repeatStyle.equalsIgnoreCase("random") ? (byte)3 : -1)));
            ArrayList<L2NpcWalkerNode> list = new ArrayList<L2NpcWalkerNode>();
            for (Node r = d.getFirstChild(); r != null; r = r.getNextSibling()) {
                NamedNodeMap attrs;
                if (r.getNodeName().equals("point")) {
                    attrs = r.getAttributes();
                    int x = this.parseInt(attrs, "X");
                    int y = this.parseInt(attrs, "Y");
                    int z = this.parseInt(attrs, "Z");
                    int delay = this.parseInt(attrs, "delay");
                    boolean run = this.parseBool(attrs, "run");
                    NpcStringId npcString = null;
                    String chatString = null;
                    Node node = attrs.getNamedItem("string");
                    if (node != null) {
                        chatString = node.getNodeValue();
                    } else {
                        node = attrs.getNamedItem("npcString");
                        if (node != null) {
                            npcString = NpcStringId.getNpcStringId(node.getNodeValue());
                            if (npcString == null) {
                                this._log.warning(this.getClass().getSimpleName() + ": Unknown npcString '" + node.getNodeValue() + "' for route '" + routeName + "'");
                                continue;
                            }
                        } else {
                            node = attrs.getNamedItem("npcStringId");
                            if (node != null && (npcString = NpcStringId.getNpcStringId(Integer.parseInt(node.getNodeValue()))) == null) {
                                this._log.warning(this.getClass().getSimpleName() + ": Unknown npcString '" + node.getNodeValue() + "' for route '" + routeName + "'");
                                continue;
                            }
                        }
                    }
                    list.add(new L2NpcWalkerNode(x, y, z, delay, run, npcString, chatString));
                    continue;
                }
                if (!r.getNodeName().equals("target")) continue;
                attrs = r.getAttributes();
                try {
                    int npcId = Integer.parseInt(attrs.getNamedItem("id").getNodeValue());
                    int x = Integer.parseInt(attrs.getNamedItem("spawnX").getNodeValue());
                    int y = Integer.parseInt(attrs.getNamedItem("spawnY").getNodeValue());
                    int z = Integer.parseInt(attrs.getNamedItem("spawnZ").getNodeValue());
                    NpcRoutesHolder holder = (NpcRoutesHolder)this._routesToAttach.get(npcId);
                    if (holder == null) {
                        holder = new NpcRoutesHolder();
                    }
                    holder.addRoute(routeName, new Location(x, y, z));
                    this._routesToAttach.put(npcId, (Object)holder);
                    L2NpcTemplate t = NpcData.getInstance().getTemplate(npcId);
                    if (t == null) {
                        this._log.log(Level.WARNING, "WalkingManager: Unknown npc. " + this.getCurrentFile().getName() + " <target id=" + npcId + " spawnX=" + x + " spawnY=" + y + " spawnZ=" + z + " />");
                        continue;
                    }
                    if (t.canMove()) continue;
                    this._log.log(Level.WARNING, "WalkingManager: Not canMove npc. " + this.getCurrentFile().getName() + " <target id=" + npcId + " spawnX=" + x + " spawnY=" + y + " spawnZ=" + z + " />");
                    continue;
                }
                catch (Exception e) {
                    this._log.warning(this.getClass().getSimpleName() + ": Error in target definition for route '" + routeName + "'");
                }
            }
            this._routes.put(routeName, new L2WalkRoute(routeName, list, repeat, false, repeatType));
        }
    }

    public boolean isOnWalk(L2Npc npc) {
        WalkInfo walk;
        L2MonsterInstance monster = null;
        if (npc.isMonster()) {
            monster = ((L2MonsterInstance)npc).getLeader() == null ? (L2MonsterInstance)npc : ((L2MonsterInstance)npc).getLeader();
        }
        if (monster != null && !this.isRegistered(monster) || !this.isRegistered(npc)) {
            return false;
        }
        WalkInfo walkInfo = walk = monster != null ? (WalkInfo)this._activeRoutes.get(monster.getObjectId()) : (WalkInfo)this._activeRoutes.get(npc.getObjectId());
        if (walk == null) {
            return false;
        }
        return !walk.isStoppedByAttack() && !walk.isSuspended();
    }

    public L2WalkRoute getRoute(String route) {
        return this._routes.get(route);
    }

    public boolean isRegistered(L2Npc npc) {
        return this._activeRoutes.containsKey(npc.getObjectId());
    }

    public String getRouteName(L2Npc npc) {
        WalkInfo walk = (WalkInfo)this._activeRoutes.get(npc.getObjectId());
        return walk != null ? walk.getRouteName() : "";
    }

    public void setWalker(L2Npc npc, boolean set) {
        if (set) {
            this._activeRoutes.put(npc.getObjectId(), null);
        } else {
            this._activeRoutes.remove(npc.getObjectId());
        }
    }

    public void startMoving(L2Npc npc, String routeName) {
        if (this._routes.containsKey(routeName) && !npc.isDead()) {
            WalkInfo walk = (WalkInfo)this._activeRoutes.get(npc.getObjectId());
            if (walk == null) {
                walk = new WalkInfo(routeName);
                L2WalkRoute route = walk.getRoute();
                CtrlIntention intention = npc.getAI().getIntention();
                if (intention == CtrlIntention.AI_INTENTION_ACTIVE || intention == CtrlIntention.AI_INTENTION_IDLE) {
                    L2NpcWalkerNode node;
                    if (npc.isDebug()) {
                        walk.setLastAction(System.currentTimeMillis());
                    }
                    if (!npc.isInsideRadius(node = walk.getCurrentNode(), 3000, true, false)) {
                        String message = "Route '" + routeName + "': NPC (id=" + npc.getId() + ", x=" + npc.getX() + ", y=" + npc.getY() + ", z=" + npc.getZ() + ") is too far from starting point (node x=" + node.getX() + ", y=" + node.getY() + ", z=" + node.getZ() + ", range=" + npc.calculateDistance(node, true, true) + "), walking will not start";
                        this._log.warning(this.getClass().getSimpleName() + ": " + message);
                        npc.sendDebugMessage(message);
                        return;
                    }
                    if (npc.isMonster() && route.getRepeatType() != 3 && route.repeatWalk()) {
                        do {
                            walk.setNodeId(Rnd.get(route.getNodesCount()));
                            node = walk.getCurrentNode();
                        } while (npc.getX() == node.getX() && npc.getY() == node.getY());
                        npc.setXYZ(node.getX() + 10, node.getY() + 10, node.getZ());
                    } else if (npc.getX() == node.getX() && npc.getY() == node.getY()) {
                        walk.calculateNextNode(npc);
                        node = walk.getCurrentNode();
                        npc.sendDebugMessage("Route '" + routeName + "': spawn point is same with first waypoint, adjusted to next");
                    }
                    npc.sendDebugMessage("Starting to move at route '" + routeName + "'");
                    npc.setIsRunning(node.runToLocation());
                    npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, node);
                    walk.setWalkCheckTask(ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new StartMovingTask(npc, walk), 60000L, 60000L));
                    npc.getKnownList().startTrackingTask();
                    this._activeRoutes.put(npc.getObjectId(), (Object)walk);
                    if (npc instanceof L2Attackable) {
                        L2Attackable mob = (L2Attackable)npc;
                        mob.setIsNoRndWalk(true);
                        mob.setCanReturnToSpawnPoint(false);
                        mob.setRandomAnimationEnabled(false);
                    }
                } else {
                    npc.sendDebugMessage("Failed to start moving along route '" + routeName + "', scheduled");
                    ThreadPoolManager.getInstance().scheduleGeneral(new StartMovingTask(npc, walk), 60000L);
                }
            } else if (walk.isSuspended()) {
                npc.sendDebugMessage("Failed to continue moving along route '" + routeName + "' (operation is suspended)");
            } else {
                CtrlIntention intention = npc.getAI().getIntention();
                if (intention == CtrlIntention.AI_INTENTION_ACTIVE || intention == CtrlIntention.AI_INTENTION_IDLE) {
                    L2NpcWalkerNode node = walk.getCurrentNode();
                    npc.sendDebugMessage("Route '" + routeName + "', continuing to node " + walk.getCurrentNodeId());
                    npc.setIsRunning(node.runToLocation());
                    npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, node);
                    walk.setStoppedByAttack(false);
                } else {
                    npc.sendDebugMessage("Failed to continue moving along route '" + routeName + "' (wrong AI state - " + (Object)((Object)npc.getAI().getIntention()) + ")");
                }
            }
        }
    }

    public synchronized void cancelMoving(L2Npc npc) {
        WalkInfo walk = (WalkInfo)this._activeRoutes.remove(npc.getObjectId());
        if (walk != null) {
            walk.getWalkCheckTask().cancel(true);
            npc.getKnownList().stopTrackingTask();
        }
    }

    public void resumeMoving(L2Npc npc) {
        WalkInfo walk = (WalkInfo)this._activeRoutes.get(npc.getObjectId());
        if (walk == null) {
            return;
        }
        walk.setSuspended(false);
        walk.setStoppedByAttack(false);
        this.startMoving(npc, walk.getRouteName());
    }

    public void stopMoving(L2Npc npc, boolean suspend, boolean stoppedByAttack) {
        L2MonsterInstance monster = null;
        if (npc.isMonster()) {
            monster = ((L2MonsterInstance)npc).getLeader() == null ? (L2MonsterInstance)npc : ((L2MonsterInstance)npc).getLeader();
        }
        if (monster != null && !this.isRegistered(monster) || !this.isRegistered(npc)) {
            return;
        }
        WalkInfo walk = monster != null ? (WalkInfo)this._activeRoutes.get(monster.getObjectId()) : (WalkInfo)this._activeRoutes.get(npc.getObjectId());
        walk.setSuspended(suspend);
        walk.setStoppedByAttack(stoppedByAttack);
        if (monster != null) {
            if (monster.getAI().getIntention() != CtrlIntention.AI_INTENTION_MOVE_TO) {
                return;
            }
            monster.stopMove(null);
            monster.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        } else {
            if (npc.getAI().getIntention() != CtrlIntention.AI_INTENTION_MOVE_TO) {
                return;
            }
            npc.stopMove(null);
            npc.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
    }

    public boolean onArrived(L2Npc npc) {
        WalkInfo walk = (WalkInfo)this._activeRoutes.get(npc.getObjectId());
        if (walk != null) {
            L2NpcWalkerNode node = walk.getCurrentNode();
            if (npc.getX() == node.getX() && npc.getY() == node.getY()) {
                walk.setBlocked(true);
                npc.sendDebugMessage("Route '" + walk.getRouteName() + "', arrived to node " + walk.getCurrentNodeId());
                npc.sendDebugMessage("Done in " + (System.currentTimeMillis() - walk.getLastAction()) / 1000L + " s");
                walk.calculateNextNode(npc);
                L2NpcWalkerNode nextNode = walk.getCurrentNode();
                boolean override = false;
                List<Quest> eventQuests = npc.getTemplate().getEventQuests(QuestEventType.ON_NODE_ARRIVED);
                if (eventQuests != null) {
                    for (Quest quest : eventQuests) {
                        override |= quest.notifyNodeArrived(npc);
                    }
                }
                if (override) {
                    walk.setBlocked(false);
                    return true;
                }
                NpcStringId npcString = node.getNpcString();
                if (npcString != null) {
                    Broadcast.toKnownPlayers(npc, new NpcSay(npc, 22, npcString));
                } else {
                    String chatText = node.getChatText();
                    if (chatText != null && !chatText.isEmpty()) {
                        Broadcast.toKnownPlayers(npc, npc.getTemplate().isUsingServerSideName() ? new CreatureSay(npc, 22, chatText) : new NpcSay(npc, 22, chatText));
                    }
                }
                if (npc.isDebug()) {
                    walk.setLastAction(System.currentTimeMillis());
                }
                if (node.getDelay() == 0) {
                    if (walk.isSuspended()) {
                        walk.setBlocked(false);
                        return false;
                    }
                    npc.setIsRunning(nextNode.runToLocation());
                    npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, nextNode);
                    walk.setBlocked(false);
                    return true;
                }
                assert (walk.isBlocked());
                npc.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                ThreadPoolManager.getInstance().scheduleGeneral(new ArrivedTask(npc, walk), (long)node.getDelay() * 1000L);
                return false;
            }
        }
        return false;
    }

    public void onDeath(L2Npc npc) {
        this.cancelMoving(npc);
    }

    public void onSpawn(L2Npc npc) {
        String routeName;
        NpcRoutesHolder root = (NpcRoutesHolder)this._routesToAttach.get(npc.getId());
        if (root != null && (routeName = root.getRouteName(npc)) != null) {
            this.startMoving(npc, routeName);
        }
    }

    public static final WalkingManager getInstance() {
        return SingletonHolder._instance;
    }

    public void visualize(String routeName, L2PcInstance player) {
        this.visualize(this._routes.get(routeName), player);
    }

    public void visualize(L2Npc walker, L2PcInstance player) {
        this.visualize(((WalkInfo)this._activeRoutes.get(walker.getObjectId())).getRoute(), player);
    }

    public void visualize(L2WalkRoute route, L2PcInstance player) {
        try {
            String name = route.getName();
            List<L2NpcWalkerNode> WALKS = route.getNodeList();
            assert (WALKS instanceof ArrayList);
            L2NpcTemplate markerNpcTemplate = NpcData.getInstance().getTemplate(1032467);
            int length = WALKS.size();
            for (int index = 0; index < length; ++index) {
                L2NpcWalkerNode node = WALKS.get(index);
                L2NpcWalkerNode next = WALKS.get((index + 1) % length);
                int x1 = node.getX();
                int y1 = node.getY();
                int z1 = node.getZ();
                int x2 = next.getX();
                int y2 = next.getY();
                int z2 = next.getZ();
                double dx = x2 - x1;
                double dy = y2 - y1;
                double dz = z2 - z1;
                double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                double pitch = 50.0;
                if (markerNpcTemplate != null) {
                    L2Spawn spawn = new L2Spawn(markerNpcTemplate);
                    spawn.setX(x1);
                    spawn.setY(y1);
                    spawn.setZ(z1);
                    spawn.setHeading(Util.calculateHeadingFrom(x1, y1, x2, y2));
                    spawn.stopRespawn();
                    L2Npc n = spawn.spawnOne(false);
                    n.setTitle("#" + index);
                    n.setName(name);
                    n.broadcastPacket(new AbstractNpcInfo.NpcInfo(n, null));
                }
                if (route.getRepeatType() == 1 || index + 1 != length) {
                    for (double p = 50.0; p < distance; p += 50.0) {
                        double a = p / distance;
                        int x = x1 + (int)Math.round(dx * a);
                        int y = y1 + (int)Math.round(dy * a);
                        int z = z1 + (int)Math.round(dz * a) + 20;
                        L2ItemInstance i = new L2ItemInstance(IdFactory.getInstance().getNextId(), 57);
                        if (player != null) {
                            i.setOwnerId(player.getObjectId());
                        }
                        L2ItemInstance l2ItemInstance = i;
                        l2ItemInstance.getClass();
                        new L2ItemInstance.ItemDropTask(l2ItemInstance, i, null, x, y, z).run();
                        i.setProtected(false);
                        L2World.getInstance().storeObject(i);
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dump() {
        for (L2WalkRoute route : this._routes.values()) {
            String repeatStyle;
            switch (route.getRepeatType()) {
                case 0: {
                    repeatStyle = "back";
                    break;
                }
                case 1: {
                    repeatStyle = "cycle";
                    break;
                }
                case 2: {
                    repeatStyle = "conveyor";
                    break;
                }
                case 3: {
                    repeatStyle = "random";
                    break;
                }
                default: {
                    repeatStyle = "?";
                }
            }
            System.out.println("<route name=\"" + route.getName() + "\" repeat=" + route.repeatWalk() + " repeatStyle=" + repeatStyle + ">");
            for (IntObjectMap.Entry a : this._routesToAttach.entrySet()) {
                NpcRoutesHolder nr = (NpcRoutesHolder)a.getValue();
                for (Map.Entry<String, String> c : nr.getCorrespondences().entrySet()) {
                    String uniqueKey = c.getKey();
                    String routeName = c.getValue();
                    if (!routeName.equals(route.getName())) continue;
                    String[] spawn = uniqueKey.split(",");
                    int npcId = a.getKey();
                    L2NpcTemplate t = NpcData.getInstance().getTemplate(npcId);
                    System.out.println("\t<target id=" + npcId + " spawnX=" + spawn[0] + " spawnY=" + spawn[1] + " spawnZ=" + spawn[2] + " /> <!-- " + (t.getTitle() + " " + t.getName()).trim() + " -->");
                }
            }
            List<L2NpcWalkerNode> nodeList = route.getNodeList();
            int length = nodeList.size();
            StringBuilder sb = new StringBuilder(256);
            for (int index = 0; index < length; ++index) {
                int n;
                L2NpcWalkerNode prev = nodeList.get((index - 1 + length) % length);
                L2NpcWalkerNode node = nodeList.get(index);
                int x0 = prev.getX();
                int y0 = prev.getY();
                int z0 = prev.getZ();
                int x1 = node.getX();
                int y1 = node.getY();
                int z1 = node.getZ();
                if (route.getRepeatType() == 1 || index != 0) {
                    long rax = x0 - x1;
                    long l = rax * rax;
                    rax = y0 - y1;
                    long l2 = l + rax * rax;
                    rax = z0 - z1;
                    n = (int)Math.sqrt(l2 + rax * rax);
                } else {
                    n = -1;
                }
                int distance = n;
                L2WorldRegion nodeWorldRegion0 = L2World.getInstance().getRegion(x0, y0);
                L2WorldRegion nodeWorldRegion1 = L2World.getInstance().getRegion(x1, y1);
                sb.setLength(0);
                if (distance >= 0) {
                    sb.append(" D=").append(distance);
                }
                sb.append(" Grid").append(nodeWorldRegion1.getName());
                if (nodeWorldRegion0 != null && nodeWorldRegion0 != nodeWorldRegion1) {
                    sb.append('#');
                }
                String rem = sb.length() > 0 ? "<!--" + sb + "-->" : "";
                nodeWorldRegion0 = nodeWorldRegion1;
                if (node.getNpcString() != null) {
                    System.out.println("\t<point npcStringId=" + node.getNpcString().getId() + " X=" + x1 + " Y=" + y1 + " Z=" + z1 + " delay=" + node.getDelay() + " run=" + node.runToLocation() + " />" + rem);
                    continue;
                }
                if (node.getChatText() != null && node.getChatText().length() > 0) {
                    System.out.println("\t<point string=\"" + node.getChatText() + "\" X=" + x1 + " Y=" + y1 + " Z=" + z1 + " delay=" + node.getDelay() + " run=" + node.runToLocation() + " />" + rem);
                    continue;
                }
                System.out.println("\t<point X=" + x1 + " Y=" + y1 + " Z=" + z1 + " delay=" + node.getDelay() + " run=" + node.runToLocation() + " />" + rem);
            }
            System.out.println("</route>");
        }
    }

    private static class SingletonHolder {
        protected static final WalkingManager _instance = new WalkingManager();

        private SingletonHolder() {
        }
    }

    private final class StartMovingTask
    implements Runnable {
        final L2Npc _npc;
        final WalkInfo _walk;

        public StartMovingTask(L2Npc npc, WalkInfo walk) {
            this._npc = npc;
            this._walk = walk;
        }

        @Override
        public void run() {
            if (this._walk.isBlocked()) {
                this._npc.sendDebugMessage("Failed to continue moving along route '" + this._walk.getRouteName() + "' (operation is blocked)");
                return;
            }
            WalkingManager.this.startMoving(this._npc, this._walk.getRouteName());
        }
    }

    private final class ArrivedTask
    implements Runnable {
        private final WalkInfo _walk;
        private final L2Npc _npc;

        public ArrivedTask(L2Npc npc, WalkInfo walk) {
            assert (walk.isBlocked());
            this._npc = npc;
            this._walk = walk;
        }

        @Override
        public void run() {
            WalkingManager.this.startMoving(this._npc, this._walk.getRouteName());
            this._walk.setBlocked(false);
        }
    }
}

