/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.instancezone.InstanceWorld;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import jp.sf.l2j.troja.FastIntObjectMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class InstanceManager
extends DocumentParser {
    private static final FastIntObjectMap<Instance> _instanceList = new FastIntObjectMap();
    private final FastIntObjectMap<InstanceWorld> _instanceWorlds = new FastIntObjectMap();
    private int _dynamic = 300000;
    private static String[] _instanceIdNames;
    private final FastIntObjectMap<FastIntObjectMap<Long>> _playerInstanceTimes = new FastIntObjectMap();
    private static final String ADD_INSTANCE_TIME = "INSERT INTO character_instance_time (charId,instanceId,time) values (?,?,?) ON DUPLICATE KEY UPDATE time=?";
    private static final String RESTORE_INSTANCE_TIMES = "SELECT instanceId,time FROM character_instance_time WHERE charId=?";
    private static final String DELETE_INSTANCE_TIME = "DELETE FROM character_instance_time WHERE charId=? AND instanceId=?";

    protected InstanceManager() {
        _instanceList.put(-1, (Object)new Instance(-1, "multiverse"));
        this._log.info(this.getClass().getSimpleName() + ": Multiverse Instance created.");
        _instanceList.put(0, (Object)new Instance(0, "universe"));
        this._log.info(this.getClass().getSimpleName() + ": Universe Instance created.");
        this.load();
    }

    @Override
    public void load() {
        _instanceIdNames = new String[0];
        this.parseDatapackFile("data/instancenames.xml");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + _instanceIdNames.length + " instance names.");
    }

    public long getInstanceTime(int playerObjId, int id) {
        this.restoreInstanceTimes(playerObjId);
        Long time = (Long)((FastIntObjectMap)this._playerInstanceTimes.get(playerObjId)).get(id);
        if (time != null) {
            return time;
        }
        return -1L;
    }

    public FastIntObjectMap<Long> getAllInstanceTimes(int playerObjId) {
        this.restoreInstanceTimes(playerObjId);
        return (FastIntObjectMap)this._playerInstanceTimes.get(playerObjId);
    }

    public void setInstanceTime(int playerObjId, int id, long time) {
        this.restoreInstanceTimes(playerObjId);
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement(ADD_INSTANCE_TIME);){
            ps.setInt(1, playerObjId);
            ps.setInt(2, id);
            ps.setLong(3, time);
            ps.setLong(4, time);
            ps.execute();
            ((FastIntObjectMap)this._playerInstanceTimes.get(playerObjId)).put(id, (Object)time);
        }
        catch (Exception e) {
            this._log.warning(this.getClass().getSimpleName() + ": Could not insert character instance time data: " + e.getMessage());
        }
    }

    public void deleteInstanceTime(int playerObjId, int id) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement(DELETE_INSTANCE_TIME);){
            ps.setInt(1, playerObjId);
            ps.setInt(2, id);
            ps.execute();
            ((FastIntObjectMap)this._playerInstanceTimes.get(playerObjId)).remove(id);
        }
        catch (Exception e) {
            this._log.warning(this.getClass().getSimpleName() + ": Could not delete character instance time data: " + e.getMessage());
        }
    }

    public void restoreInstanceTimes(int playerObjId) {
        if (this._playerInstanceTimes.containsKey(playerObjId)) {
            return;
        }
        FastIntObjectMap times = new FastIntObjectMap();
        this._playerInstanceTimes.put(playerObjId, (Object)times);
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement(RESTORE_INSTANCE_TIMES);){
            ps.setInt(1, playerObjId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int id = rs.getInt("instanceId");
                    long time = rs.getLong("time");
                    if (time < System.currentTimeMillis()) {
                        this.deleteInstanceTime(playerObjId, id);
                        continue;
                    }
                    times.put(id, (Object)time);
                }
            }
        }
        catch (Exception e) {
            this._log.warning(this.getClass().getSimpleName() + ": Could not delete character instance time data: " + e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getInstanceIdName(int id) {
        void var2_2;
        String name;
        return id < 0 || id >= _instanceIdNames.length || (name = _instanceIdNames[id]) == null ? "UnknownInstance" : var2_2;
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equals(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"instance".equals(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                int id = this.parseInteger(attrs, "id");
                String name = attrs.getNamedItem("name").getNodeValue();
                if (_instanceIdNames.length <= id) {
                    _instanceIdNames = Arrays.copyOf(_instanceIdNames, id + 1);
                }
                InstanceManager._instanceIdNames[id] = name;
            }
        }
    }

    public void addWorld(InstanceWorld world) {
        this._instanceWorlds.put(world.getInstanceId(), (Object)world);
    }

    public InstanceWorld getWorld(int instanceId) {
        return (InstanceWorld)this._instanceWorlds.get(instanceId);
    }

    public InstanceWorld getPlayerWorld(L2PcInstance player) {
        for (InstanceWorld temp : this._instanceWorlds.values()) {
            if (temp == null || !temp.isAllowed(player.getObjectId())) continue;
            return temp;
        }
        return null;
    }

    public void destroyInstance(int instanceid) {
        if (instanceid <= 0) {
            return;
        }
        this._instanceWorlds.remove(instanceid);
        Instance temp = (Instance)_instanceList.remove(instanceid);
        if (temp != null) {
            temp.cancelQuestTimers();
            temp.removeNpcs();
            temp.removePlayers();
            temp.removeDoors();
            temp.cancelTimer();
        }
    }

    public Instance getInstance(int instanceid) {
        return (Instance)_instanceList.get(instanceid);
    }

    public FastIntObjectMap<Instance> getInstances() {
        return _instanceList;
    }

    public int getPlayerInstance(int objectId) {
        for (Instance temp : _instanceList.values()) {
            if (temp == null || !temp.containsPlayer(objectId)) continue;
            return temp.getId();
        }
        return 0;
    }

    public boolean createInstance(int id) {
        if (this.getInstance(id) != null) {
            return false;
        }
        Instance instance = new Instance(id);
        _instanceList.put(id, (Object)instance);
        return true;
    }

    public boolean createInstanceFromTemplate(int id, String template) {
        if (this.getInstance(id) != null) {
            return false;
        }
        Instance instance = new Instance(id);
        _instanceList.put(id, (Object)instance);
        instance.loadInstanceTemplate(template);
        return true;
    }

    public int createDynamicInstance(String template) {
        while (this.getInstance(this._dynamic) != null) {
            ++this._dynamic;
            if (this._dynamic != Integer.MAX_VALUE) continue;
            this._log.warning(this.getClass().getSimpleName() + ": More then " + 2147183647 + " instances created");
            this._dynamic = 300000;
        }
        Instance instance = new Instance(this._dynamic);
        _instanceList.put(this._dynamic, (Object)instance);
        if (template != null) {
            instance.loadInstanceTemplate(template);
        }
        return this._dynamic++;
    }

    public static final InstanceManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final InstanceManager _instance = new InstanceManager();

        private SingletonHolder() {
        }
    }
}

