/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.variables.AbstractVariables;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GlobalVariablesManager
extends AbstractVariables {
    private static final Logger _log = Logger.getLogger(GlobalVariablesManager.class.getName());
    private static final String SELECT_QUERY = "SELECT * FROM global_variables";
    private static final String DELETE_QUERY = "DELETE FROM global_variables";
    private static final String INSERT_QUERY = "INSERT INTO global_variables (var, value) VALUES (?, ?)";

    protected GlobalVariablesManager() {
        this.restoreMe();
    }

    @Override
    public boolean restoreMe() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement st = con.createStatement();
             ResultSet rset = st.executeQuery(SELECT_QUERY);){
            while (rset.next()) {
                this.set(rset.getString("var"), rset.getString("value"));
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Couldn't restore global variables");
            return false;
        }
        _log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded " + this.getSet().size() + " variables.");
        return true;
    }

    @Override
    public boolean storeMe() {
        if (!this.getAndResetChanges()) {
            return false;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement del = con.createStatement();
             PreparedStatement st = con.prepareStatement(INSERT_QUERY);){
            del.execute(DELETE_QUERY);
            for (Map.Entry<String, Object> entry : this.getSet().entrySet()) {
                st.setString(1, entry.getKey());
                st.setString(2, String.valueOf(entry.getValue()));
                st.addBatch();
            }
            st.executeBatch();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Couldn't save global variables to database.", e);
            return false;
        }
        _log.log(Level.INFO, this.getClass().getSimpleName() + ": Stored " + this.getSet().size() + " variables.");
        return true;
    }

    public static final GlobalVariablesManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final GlobalVariablesManager _instance = new GlobalVariablesManager();

        private SingletonHolder() {
        }
    }
}

