/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.model.CombatFlag;
import com.l2jserver.gameserver.model.FortSiegeSpawn;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.FortSiege;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public final class FortSiegeManager {
    private static final Logger _log = Logger.getLogger(FortSiegeManager.class.getName());
    private int _attackerMaxClans = 500;
    private FastMap<Integer, FastList<FortSiegeSpawn>> _commanderSpawnList;
    private FastMap<Integer, FastList<CombatFlag>> _flagList;
    private boolean _justToTerritory = true;
    private int _flagMaxCount = 1;
    private int _siegeClanMinLevel = 4;
    private int _siegeLength = 60;
    private int _countDownLength = 10;
    private int _suspiciousMerchantRespawnDelay = 180;
    private List<FortSiege> _sieges;

    protected FortSiegeManager() {
        this.load();
    }

    public final void addSiegeSkills(L2PcInstance character) {
        character.addSkill(CommonSkill.SEAL_OF_RULER.getSkill(), false);
        character.addSkill(CommonSkill.BUILD_HEADQUARTERS.getSkill(), false);
    }

    public final boolean checkIfOkToSummon(L2Character activeChar, boolean isCheckOnly) {
        if (!(activeChar instanceof L2PcInstance)) {
            return false;
        }
        String text = "";
        L2PcInstance player = (L2PcInstance)activeChar;
        Fort fort = FortManager.getInstance().getFort(player);
        if (fort == null || fort.getResidenceId() <= 0) {
            text = "You must be on fort ground to summon this";
        } else if (!fort.getSiege().getIsInProgress()) {
            text = "You can only summon this during a siege.";
        } else if (player.getClanId() != 0 && fort.getSiege().getAttackerClan(player.getClanId()) == null) {
            text = "You can only summon this as a registered attacker.";
        } else {
            return true;
        }
        if (!isCheckOnly) {
            player.sendMessage(text);
        }
        return false;
    }

    public final boolean checkIsRegistered(L2Clan clan, int fortid) {
        if (clan == null) {
            return false;
        }
        boolean register = false;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT clan_id FROM fortsiege_clans where clan_id=? and fort_id=?");){
            ps.setInt(1, clan.getId());
            ps.setInt(2, fortid);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    register = true;
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: checkIsRegistered(): " + e.getMessage(), e);
        }
        return register;
    }

    public final void removeSiegeSkills(L2PcInstance character) {
        character.removeSkill(CommonSkill.SEAL_OF_RULER.getSkill());
        character.removeSkill(CommonSkill.BUILD_HEADQUARTERS.getSkill());
    }

    private final void load() {
        Properties siegeSettings = new Properties();
        try (FileInputStream is = new FileInputStream("./config/FortSiege.properties");){
            siegeSettings.load(is);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while loading Fort Siege Manager settings!", e);
        }
        this._justToTerritory = Boolean.parseBoolean(siegeSettings.getProperty("JustToTerritory", "true"));
        this._attackerMaxClans = Integer.decode(siegeSettings.getProperty("AttackerMaxClans", "500"));
        this._flagMaxCount = Integer.decode(siegeSettings.getProperty("MaxFlags", "1"));
        this._siegeClanMinLevel = Integer.decode(siegeSettings.getProperty("SiegeClanMinLevel", "4"));
        this._siegeLength = Integer.decode(siegeSettings.getProperty("SiegeLength", "60"));
        this._countDownLength = Integer.decode(siegeSettings.getProperty("CountDownLength", "10"));
        this._suspiciousMerchantRespawnDelay = Integer.decode(siegeSettings.getProperty("SuspiciousMerchantRespawnDelay", "180"));
        this._commanderSpawnList = new FastMap();
        this._flagList = new FastMap();
        for (Fort fort : FortManager.getInstance().getForts()) {
            int z;
            int y;
            StringTokenizer st;
            String _spawnParams;
            int i;
            FastList _commanderSpawns = new FastList();
            FastList _flagSpawns = new FastList();
            for (i = 1; i < 5 && !(_spawnParams = siegeSettings.getProperty(fort.getName().replace(" ", "") + "Commander" + i, "")).isEmpty(); ++i) {
                st = new StringTokenizer(_spawnParams.trim(), ",");
                try {
                    int x = Integer.parseInt(st.nextToken());
                    y = Integer.parseInt(st.nextToken());
                    z = Integer.parseInt(st.nextToken());
                    int heading = Integer.parseInt(st.nextToken());
                    int npc_id = Integer.parseInt(st.nextToken());
                    _commanderSpawns.add((Object)new FortSiegeSpawn(fort.getResidenceId(), x, y, z, heading, npc_id, i));
                    continue;
                }
                catch (Exception e) {
                    _log.warning("Error while loading commander(s) for " + fort.getName() + " fort.");
                }
            }
            this._commanderSpawnList.put((Object)fort.getResidenceId(), (Object)_commanderSpawns);
            for (i = 1; i < 4 && !(_spawnParams = siegeSettings.getProperty(fort.getName().replace(" ", "") + "Flag" + i, "")).isEmpty(); ++i) {
                st = new StringTokenizer(_spawnParams.trim(), ",");
                try {
                    int x = Integer.parseInt(st.nextToken());
                    y = Integer.parseInt(st.nextToken());
                    z = Integer.parseInt(st.nextToken());
                    int flag_id = Integer.parseInt(st.nextToken());
                    _flagSpawns.add((Object)new CombatFlag(fort.getResidenceId(), x, y, z, 0, flag_id));
                    continue;
                }
                catch (Exception e) {
                    _log.warning("Error while loading flag(s) for " + fort.getName() + " fort.");
                }
            }
            this._flagList.put((Object)fort.getResidenceId(), (Object)_flagSpawns);
        }
    }

    public final FastList<FortSiegeSpawn> getCommanderSpawnList(int _fortId) {
        if (this._commanderSpawnList.containsKey((Object)_fortId)) {
            return (FastList)this._commanderSpawnList.get((Object)_fortId);
        }
        return null;
    }

    public final FastList<CombatFlag> getFlagList(int _fortId) {
        if (this._flagList.containsKey((Object)_fortId)) {
            return (FastList)this._flagList.get((Object)_fortId);
        }
        return null;
    }

    public final int getAttackerMaxClans() {
        return this._attackerMaxClans;
    }

    public final int getFlagMaxCount() {
        return this._flagMaxCount;
    }

    public final boolean canRegisterJustTerritory() {
        return this._justToTerritory;
    }

    public final int getSuspiciousMerchantRespawnDelay() {
        return this._suspiciousMerchantRespawnDelay;
    }

    public final FortSiege getSiege(L2Object activeObject) {
        return this.getSiege(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public final FortSiege getSiege(int x, int y, int z) {
        for (Fort fort : FortManager.getInstance().getForts()) {
            if (!fort.getSiege().checkIfInZone(x, y, z)) continue;
            return fort.getSiege();
        }
        return null;
    }

    public final int getSiegeClanMinLevel() {
        return this._siegeClanMinLevel;
    }

    public final int getSiegeLength() {
        return this._siegeLength;
    }

    public final int getCountDownLength() {
        return this._countDownLength;
    }

    public final List<FortSiege> getSieges() {
        if (this._sieges == null) {
            this._sieges = new FastList();
        }
        return this._sieges;
    }

    public final void addSiege(FortSiege fortSiege) {
        if (this._sieges == null) {
            this._sieges = new FastList();
        }
        this._sieges.add(fortSiege);
    }

    public boolean isCombat(int itemId) {
        return itemId == 9819;
    }

    public boolean activateCombatFlag(L2PcInstance player, L2ItemInstance item) {
        if (!this.checkIfCanPickup(player)) {
            return false;
        }
        Fort fort = FortManager.getInstance().getFort(player);
        FastList fcf = (FastList)this._flagList.get((Object)fort.getResidenceId());
        for (CombatFlag cf : fcf) {
            if (cf.getCombatFlagInstance() != item) continue;
            cf.activate(player, item);
        }
        return true;
    }

    public boolean checkIfCanPickup(L2PcInstance player) {
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_FORTRESS_BATTLE_OF_S1_HAS_FINISHED);
        sm.addItemName(9819);
        if (player.isCombatFlagEquipped()) {
            player.sendPacket(sm);
            return false;
        }
        Fort fort = FortManager.getInstance().getFort(player);
        if (fort == null || fort.getResidenceId() <= 0) {
            player.sendPacket(sm);
            return false;
        }
        if (!fort.getSiege().getIsInProgress()) {
            player.sendPacket(sm);
            return false;
        }
        if (fort.getSiege().getAttackerClan(player.getClan()) == null) {
            player.sendPacket(sm);
            return false;
        }
        return true;
    }

    public void dropCombatFlag(L2PcInstance player, int fortId) {
        Fort fort = FortManager.getInstance().getFortById(fortId);
        FastList fcf = (FastList)this._flagList.get((Object)fort.getResidenceId());
        for (CombatFlag cf : fcf) {
            if (cf.getPlayerObjectId() != player.getObjectId()) continue;
            cf.dropIt();
            if (!fort.getSiege().getIsInProgress()) continue;
            cf.spawnMe();
        }
    }

    public static final FortSiegeManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final FortSiegeManager _instance = new FortSiegeManager();

        private SingletonHolder() {
        }
    }
}

