/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import java.util.Map;
import javolution.util.FastMap;
import jp.sf.l2j.troja.FastIntObjectMap;

public final class AntiFeedManager {
    public static final int GAME_ID = 0;
    public static final int OLYMPIAD_ID = 1;
    public static final int TVT_ID = 2;
    public static final int L2EVENT_ID = 3;
    private final FastIntObjectMap<Long> _lastDeathTimes = new FastIntObjectMap().shared();
    private final FastIntObjectMap<FastMap<Integer, Connections>> _eventIPs = new FastIntObjectMap();

    protected AntiFeedManager() {
    }

    public final void setLastDeathTime(int objectId) {
        this._lastDeathTimes.put(objectId, (Object)System.currentTimeMillis());
    }

    public final boolean check(L2Character attacker, L2Character target) {
        if (!Config.L2JMOD_ANTIFEED_ENABLE) {
            return true;
        }
        if (target == null) {
            return false;
        }
        L2PcInstance targetPlayer = target.getActingPlayer();
        if (targetPlayer == null) {
            return false;
        }
        if (Config.L2JMOD_ANTIFEED_INTERVAL > 0 && this._lastDeathTimes.containsKey(targetPlayer.getObjectId()) && System.currentTimeMillis() - (Long)this._lastDeathTimes.get(targetPlayer.getObjectId()) < (long)Config.L2JMOD_ANTIFEED_INTERVAL) {
            return false;
        }
        if (Config.L2JMOD_ANTIFEED_DUALBOX && attacker != null) {
            L2PcInstance attackerPlayer = attacker.getActingPlayer();
            if (attackerPlayer == null) {
                return false;
            }
            L2GameClient targetClient = targetPlayer.getClient();
            L2GameClient attackerClient = attackerPlayer.getClient();
            if (targetClient == null || attackerClient == null || targetClient.isDetached() || attackerClient.isDetached()) {
                return !Config.L2JMOD_ANTIFEED_DISCONNECTED_AS_DUALBOX;
            }
            return !targetClient.getConnectionAddress().equals(attackerClient.getConnectionAddress());
        }
        return true;
    }

    public final void clear() {
        this._lastDeathTimes.clear();
    }

    public final void registerEvent(int eventId) {
        if (!this._eventIPs.containsKey(eventId)) {
            this._eventIPs.put(eventId, (Object)new FastMap());
        }
    }

    public final boolean tryAddPlayer(int eventId, L2PcInstance player, int max) {
        return this.tryAddClient(eventId, player.getClient(), max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryAddClient(int eventId, L2GameClient client, int max) {
        Connections conns;
        if (client == null) {
            return false;
        }
        Map event = (Map)this._eventIPs.get(eventId);
        if (event == null) {
            return false;
        }
        Integer addrHash = client.getConnectionAddress().hashCode();
        int limit = max;
        if (Config.L2JMOD_DUALBOX_CHECK_WHITELIST.containsKey(addrHash)) {
            limit += Config.L2JMOD_DUALBOX_CHECK_WHITELIST.get(addrHash).intValue();
        }
        Map map = event;
        synchronized (map) {
            conns = (Connections)event.get(addrHash);
            if (conns == null) {
                conns = new Connections();
                event.put(addrHash, conns);
            }
        }
        return conns.testAndIncrement(limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removePlayer(int eventId, L2PcInstance player) {
        L2GameClient client = player.getClient();
        if (client == null) {
            return false;
        }
        Map event = (Map)this._eventIPs.get(eventId);
        if (event == null) {
            return false;
        }
        Integer addrHash = client.getConnectionAddress().hashCode();
        Connections conns = (Connections)event.get(addrHash);
        if (conns == null) {
            return false;
        }
        Map map = event;
        synchronized (map) {
            if (conns.testAndDecrement()) {
                event.remove(addrHash);
            }
        }
        return true;
    }

    public final void onDisconnect(L2GameClient client) {
        if (client == null) {
            return;
        }
        Integer addrHash = client.getConnectionAddress().hashCode();
        for (FastMap v : this._eventIPs.values()) {
            this.disconnectProcedure((FastMap<Integer, Connections>)v, addrHash);
        }
    }

    public final void clear(int eventId) {
        Map event = (Map)this._eventIPs.get(eventId);
        if (event != null) {
            event.clear();
        }
    }

    public final int getLimit(L2PcInstance player, int max) {
        return this.getLimit(player.getClient(), max);
    }

    public final int getLimit(L2GameClient client, int max) {
        if (client == null) {
            return max;
        }
        Integer addrHash = client.getConnectionAddress().hashCode();
        int limit = max;
        if (Config.L2JMOD_DUALBOX_CHECK_WHITELIST.containsKey(addrHash)) {
            limit += Config.L2JMOD_DUALBOX_CHECK_WHITELIST.get(addrHash).intValue();
        }
        return limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void disconnectProcedure(FastMap<Integer, Connections> event, Integer _addrHash) {
        Connections conns = (Connections)event.get((Object)_addrHash);
        if (conns != null) {
            FastMap<Integer, Connections> fastMap = event;
            synchronized (fastMap) {
                if (conns.testAndDecrement()) {
                    event.remove((Object)_addrHash);
                }
            }
        }
    }

    public static final AntiFeedManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final AntiFeedManager _instance = new AntiFeedManager();

        private SingletonHolder() {
        }
    }

    protected static final class Connections {
        private int _num = 0;

        protected Connections() {
        }

        public final synchronized boolean testAndIncrement(int max) {
            if (this._num < max) {
                ++this._num;
                return true;
            }
            return false;
        }

        public final synchronized boolean testAndDecrement() {
            if (this._num > 0) {
                --this._num;
            }
            return this._num == 0;
        }
    }
}

