/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handler;

import com.l2jserver.gameserver.handler.IHandler;
import com.l2jserver.gameserver.handler.ITelnetHandler;
import java.util.HashMap;
import java.util.Map;

public class TelnetHandler
implements IHandler<ITelnetHandler, String> {
    private final Map<String, ITelnetHandler> _telnetHandlers = new HashMap<String, ITelnetHandler>();

    protected TelnetHandler() {
    }

    @Override
    public void registerHandler(ITelnetHandler handler) {
        for (String element : handler.getCommandList()) {
            this._telnetHandlers.put(element.toLowerCase(), handler);
        }
    }

    @Override
    public synchronized void removeHandler(ITelnetHandler handler) {
        for (String element : handler.getCommandList()) {
            this._telnetHandlers.remove(element.toLowerCase());
        }
    }

    @Override
    public ITelnetHandler getHandler(String command) {
        if (command.contains(" ")) {
            command = command.substring(0, command.indexOf(" "));
        }
        return this._telnetHandlers.get(command.toLowerCase());
    }

    @Override
    public int size() {
        return this._telnetHandlers.size();
    }

    public static TelnetHandler getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final TelnetHandler _instance = new TelnetHandler();

        private SingletonHolder() {
        }
    }
}

