/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.enums.PcRace;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.AcquireSkillType;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.base.SocialClass;
import com.l2jserver.gameserver.model.base.SubClass;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.holders.PlayerSkillHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.interfaces.ISkillsHolder;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.model.skills.Skill;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sf.l2j.troja.FastIntObjectMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class SkillTreesData
extends DocumentParser {
    private static final Map<ClassId, Map<Integer, L2SkillLearn>> _classSkillTrees = new HashMap<ClassId, Map<Integer, L2SkillLearn>>();
    private static final Map<ClassId, Map<Integer, L2SkillLearn>> _transferSkillTrees = new HashMap<ClassId, Map<Integer, L2SkillLearn>>();
    private static final Map<Integer, L2SkillLearn> _collectSkillTree = new HashMap<Integer, L2SkillLearn>();
    private static final Map<Integer, L2SkillLearn> _fishingSkillTree = new HashMap<Integer, L2SkillLearn>();
    private static final Map<Integer, L2SkillLearn> _pledgeSkillTree = new HashMap<Integer, L2SkillLearn>();
    private static final Map<Integer, L2SkillLearn> _subClassSkillTree = new HashMap<Integer, L2SkillLearn>();
    private static final Map<Integer, L2SkillLearn> _subPledgeSkillTree = new HashMap<Integer, L2SkillLearn>();
    private static final Map<Integer, L2SkillLearn> _transformSkillTree = new HashMap<Integer, L2SkillLearn>();
    private static final Map<Integer, L2SkillLearn> _commonSkillTree = new HashMap<Integer, L2SkillLearn>();
    private static final Map<Integer, L2SkillLearn> _nobleSkillTree = new HashMap<Integer, L2SkillLearn>();
    private static final Map<Integer, L2SkillLearn> _heroSkillTree = new HashMap<Integer, L2SkillLearn>();
    private static final Map<Integer, L2SkillLearn> _gameMasterSkillTree = new HashMap<Integer, L2SkillLearn>();
    private static final Map<Integer, L2SkillLearn> _gameMasterAuraSkillTree = new HashMap<Integer, L2SkillLearn>();
    private FastIntObjectMap<int[]> _skillsByClassIdHashCodes;
    private FastIntObjectMap<int[]> _skillsByRaceHashCodes;
    private int[] _allSkillsHashCodes;
    private boolean _loading = true;
    private static final Map<ClassId, ClassId> _parentClassMap = new HashMap<ClassId, ClassId>();

    protected SkillTreesData() {
        this.load();
    }

    @Override
    public void load() {
        this._loading = true;
        _classSkillTrees.clear();
        _collectSkillTree.clear();
        _fishingSkillTree.clear();
        _pledgeSkillTree.clear();
        _subClassSkillTree.clear();
        _subPledgeSkillTree.clear();
        _transferSkillTrees.clear();
        _transformSkillTree.clear();
        _nobleSkillTree.clear();
        _heroSkillTree.clear();
        _gameMasterSkillTree.clear();
        _gameMasterAuraSkillTree.clear();
        this.parseDatapackDirectory("data/skillTrees/", false);
        this.generateCheckArrays();
        this._loading = false;
        this.report();
    }

    @Override
    protected void parseDocument() {
        String type = null;
        int cId = -1;
        int parentClassId = -1;
        ClassId classId = null;
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"skillTree".equalsIgnoreCase(d.getNodeName())) continue;
                HashMap<Integer, L2SkillLearn> classSkillTree = new HashMap<Integer, L2SkillLearn>();
                HashMap<Integer, L2SkillLearn> trasferSkillTree = new HashMap<Integer, L2SkillLearn>();
                type = d.getAttributes().getNamedItem("type").getNodeValue();
                Node attr = d.getAttributes().getNamedItem("classId");
                if (attr != null) {
                    cId = Integer.parseInt(attr.getNodeValue());
                    classId = ClassId.values()[cId];
                } else {
                    cId = -1;
                }
                attr = d.getAttributes().getNamedItem("parentClassId");
                if (attr != null) {
                    parentClassId = Integer.parseInt(attr.getNodeValue());
                    if (cId > -1 && cId != parentClassId && parentClassId > -1 && !_parentClassMap.containsKey(classId)) {
                        _parentClassMap.put(classId, ClassId.values()[parentClassId]);
                    }
                }
                block46: for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
                    if (!"skill".equalsIgnoreCase(c.getNodeName())) continue;
                    StatsSet learnSkillSet = new StatsSet();
                    NamedNodeMap attrs = c.getAttributes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        attr = attrs.item(i);
                        learnSkillSet.set(attr.getNodeName(), attr.getNodeValue());
                    }
                    L2SkillLearn skillLearn = new L2SkillLearn(learnSkillSet);
                    block48: for (Node b = c.getFirstChild(); b != null; b = b.getNextSibling()) {
                        attrs = b.getAttributes();
                        switch (b.getNodeName()) {
                            case "item": {
                                skillLearn.addRequiredItem(new ItemHolder(this.parseInteger(attrs, "id"), this.parseInteger(attrs, "count").intValue()));
                                continue block48;
                            }
                            case "preRequisiteSkill": {
                                skillLearn.addPreReqSkill(new SkillHolder(this.parseInteger(attrs, "id"), this.parseInteger(attrs, "lvl")));
                                continue block48;
                            }
                            case "race": {
                                skillLearn.addRace(PcRace.valueOf(b.getTextContent()));
                                continue block48;
                            }
                            case "residenceId": {
                                skillLearn.addResidenceId(Integer.valueOf(b.getTextContent()));
                                continue block48;
                            }
                            case "socialClass": {
                                skillLearn.setSocialClass(Enum.valueOf(SocialClass.class, b.getTextContent()));
                                continue block48;
                            }
                            case "subClassConditions": {
                                skillLearn.addSubclassConditions(this.parseInteger(attrs, "slot"), this.parseInteger(attrs, "lvl"));
                            }
                        }
                    }
                    int skillHashCode = SkillData.getSkillHashCode(skillLearn.getSkillId(), skillLearn.getSkillLevel());
                    switch (type) {
                        case "classSkillTree": {
                            if (cId != -1) {
                                classSkillTree.put(skillHashCode, skillLearn);
                                continue block46;
                            }
                            _commonSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "transferSkillTree": {
                            trasferSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "collectSkillTree": {
                            _collectSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "fishingSkillTree": {
                            _fishingSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "pledgeSkillTree": {
                            _pledgeSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "subClassSkillTree": {
                            _subClassSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "subPledgeSkillTree": {
                            _subPledgeSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "transformSkillTree": {
                            _transformSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "nobleSkillTree": {
                            _nobleSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "heroSkillTree": {
                            _heroSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "gameMasterSkillTree": {
                            _gameMasterSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "gameMasterAuraSkillTree": {
                            _gameMasterAuraSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        default: {
                            this._log.warning(this.getClass().getSimpleName() + ": Unknown Skill Tree type: " + type + "!");
                        }
                    }
                }
                if (type.equals("transferSkillTree")) {
                    _transferSkillTrees.put(classId, trasferSkillTree);
                    continue;
                }
                if (!type.equals("classSkillTree") || cId <= -1) continue;
                if (!_classSkillTrees.containsKey(classId)) {
                    _classSkillTrees.put(classId, classSkillTree);
                    continue;
                }
                _classSkillTrees.get(classId).putAll(classSkillTree);
            }
        }
    }

    public Map<Integer, L2SkillLearn> getCompleteClassSkillTree(ClassId classId) {
        HashMap<Integer, L2SkillLearn> skillTree = new HashMap<Integer, L2SkillLearn>();
        skillTree.putAll(_commonSkillTree);
        while (classId != null && _classSkillTrees.get(classId) != null) {
            skillTree.putAll(_classSkillTrees.get(classId));
            classId = _parentClassMap.get(classId);
        }
        return skillTree;
    }

    public Map<Integer, L2SkillLearn> getTransferSkillTree(ClassId classId) {
        if (classId.level() >= 3) {
            return this.getTransferSkillTree(classId.getParent());
        }
        return _transferSkillTrees.get(classId);
    }

    public Map<Integer, L2SkillLearn> getCommonSkillTree() {
        return _commonSkillTree;
    }

    public Map<Integer, L2SkillLearn> getCollectSkillTree() {
        return _collectSkillTree;
    }

    public Map<Integer, L2SkillLearn> getFishingSkillTree() {
        return _fishingSkillTree;
    }

    public Map<Integer, L2SkillLearn> getPledgeSkillTree() {
        return _pledgeSkillTree;
    }

    public Map<Integer, L2SkillLearn> getSubClassSkillTree() {
        return _subClassSkillTree;
    }

    public Map<Integer, L2SkillLearn> getSubPledgeSkillTree() {
        return _subPledgeSkillTree;
    }

    public Map<Integer, L2SkillLearn> getTransformSkillTree() {
        return _transformSkillTree;
    }

    public Map<Integer, Skill> getNobleSkillTree() {
        HashMap<Integer, Skill> tree = new HashMap<Integer, Skill>();
        SkillData st = SkillData.getInstance();
        for (Map.Entry<Integer, L2SkillLearn> e : _nobleSkillTree.entrySet()) {
            tree.put(e.getKey(), st.getSkill(e.getValue().getSkillId(), e.getValue().getSkillLevel()));
        }
        return tree;
    }

    public Map<Integer, Skill> getHeroSkillTree() {
        HashMap<Integer, Skill> tree = new HashMap<Integer, Skill>();
        SkillData st = SkillData.getInstance();
        for (Map.Entry<Integer, L2SkillLearn> e : _heroSkillTree.entrySet()) {
            tree.put(e.getKey(), st.getSkill(e.getValue().getSkillId(), e.getValue().getSkillLevel()));
        }
        return tree;
    }

    public Map<Integer, Skill> getGMSkillTree() {
        HashMap<Integer, Skill> tree = new HashMap<Integer, Skill>();
        SkillData st = SkillData.getInstance();
        for (Map.Entry<Integer, L2SkillLearn> e : _gameMasterSkillTree.entrySet()) {
            tree.put(e.getKey(), st.getSkill(e.getValue().getSkillId(), e.getValue().getSkillLevel()));
        }
        return tree;
    }

    public Map<Integer, Skill> getGMAuraSkillTree() {
        HashMap<Integer, Skill> tree = new HashMap<Integer, Skill>();
        SkillData st = SkillData.getInstance();
        for (Map.Entry<Integer, L2SkillLearn> e : _gameMasterAuraSkillTree.entrySet()) {
            tree.put(e.getKey(), st.getSkill(e.getValue().getSkillId(), e.getValue().getSkillLevel()));
        }
        return tree;
    }

    public List<L2SkillLearn> getAvailableSkills(L2PcInstance player, ClassId classId, boolean includeByFs, boolean includeAutoGet) {
        return this.getAvailableSkills(player, classId, includeByFs, includeAutoGet, player);
    }

    private List<L2SkillLearn> getAvailableSkills(L2PcInstance player, ClassId classId, boolean includeByFs, boolean includeAutoGet, ISkillsHolder holder) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        Map<Integer, L2SkillLearn> skills = this.getCompleteClassSkillTree(classId);
        if (skills.isEmpty()) {
            this._log.warning(this.getClass().getSimpleName() + ": Skilltree for class " + classId + " is not defined!");
            return result;
        }
        for (L2SkillLearn skill : skills.values()) {
            if ((!includeAutoGet || !skill.isAutoGet()) && !skill.isLearnedByNpc() && (!includeByFs || !skill.isLearnedByFS()) || player.getLevel() < skill.getGetLevel()) continue;
            Skill oldSkill = holder.getKnownSkill(skill.getSkillId());
            if (oldSkill != null) {
                if (oldSkill.getLevel() != skill.getSkillLevel() - 1) continue;
                result.add(skill);
                continue;
            }
            if (skill.getSkillLevel() != 1) continue;
            result.add(skill);
        }
        return result;
    }

    public Collection<Skill> getAllAvailableSkills(L2PcInstance player, ClassId classId, boolean includeByFs, boolean includeAutoGet) {
        int unLearnable = 0;
        PlayerSkillHolder holder = new PlayerSkillHolder(player);
        List<L2SkillLearn> learnable = this.getAvailableSkills(player, classId, includeByFs, includeAutoGet, holder);
        while (learnable.size() > unLearnable) {
            for (L2SkillLearn s : learnable) {
                Skill sk = SkillData.getInstance().getSkill(s.getSkillId(), s.getSkillLevel());
                if (sk == null || sk.getId() == CommonSkill.DIVINE_INSPIRATION.getId() && !Config.AUTO_LEARN_DIVINE_INSPIRATION && !player.isGM()) {
                    ++unLearnable;
                    continue;
                }
                holder.addSkill(sk);
            }
            learnable = this.getAvailableSkills(player, classId, includeByFs, includeAutoGet, holder);
        }
        return holder.getSkills().values();
    }

    public List<L2SkillLearn> getAvailableAutoGetSkills(L2PcInstance player) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        Map<Integer, L2SkillLearn> skills = this.getCompleteClassSkillTree(player.getClassId());
        if (skills.isEmpty()) {
            this._log.warning(this.getClass().getSimpleName() + ": Skill Tree for this class Id(" + player.getClassId() + ") is not defined!");
            return result;
        }
        PcRace race = player.getRace();
        for (L2SkillLearn skill : skills.values()) {
            if (!skill.getRaces().isEmpty() && !skill.getRaces().contains((Object)race) || !skill.isAutoGet() || player.getLevel() < skill.getGetLevel()) continue;
            Skill oldSkill = (Skill)player.getSkills().get(skill.getSkillId());
            if (oldSkill != null) {
                if (oldSkill.getLevel() >= skill.getSkillLevel()) continue;
                result.add(skill);
                continue;
            }
            result.add(skill);
        }
        return result;
    }

    public List<L2SkillLearn> getAvailableFishingSkills(L2PcInstance player) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        PcRace playerRace = player.getRace();
        for (L2SkillLearn skill : _fishingSkillTree.values()) {
            if (!skill.getRaces().isEmpty() && !skill.getRaces().contains((Object)playerRace) || !skill.isLearnedByNpc() || player.getLevel() < skill.getGetLevel()) continue;
            Skill oldSkill = (Skill)player.getSkills().get(skill.getSkillId());
            if (oldSkill != null) {
                if (oldSkill.getLevel() != skill.getSkillLevel() - 1) continue;
                result.add(skill);
                continue;
            }
            if (skill.getSkillLevel() != 1) continue;
            result.add(skill);
        }
        return result;
    }

    public List<L2SkillLearn> getAvailableCollectSkills(L2PcInstance player) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        for (L2SkillLearn skill : _collectSkillTree.values()) {
            Skill oldSkill = (Skill)player.getSkills().get(skill.getSkillId());
            if (oldSkill != null) {
                if (oldSkill.getLevel() != skill.getSkillLevel() - 1) continue;
                result.add(skill);
                continue;
            }
            if (skill.getSkillLevel() != 1) continue;
            result.add(skill);
        }
        return result;
    }

    public List<L2SkillLearn> getAvailableTransferSkills(L2PcInstance player) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        ClassId classId = player.getClassId();
        if (classId.level() == 3) {
            classId = classId.getParent();
        }
        if (!_transferSkillTrees.containsKey(classId)) {
            return result;
        }
        for (L2SkillLearn skill : _transferSkillTrees.get(classId).values()) {
            if (player.getKnownSkill(skill.getSkillId()) != null) continue;
            result.add(skill);
        }
        return result;
    }

    public List<L2SkillLearn> getAvailableTransformSkills(L2PcInstance player) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        PcRace race = player.getRace();
        for (L2SkillLearn skill : _transformSkillTree.values()) {
            if (player.getLevel() < skill.getGetLevel() || !skill.getRaces().isEmpty() && !skill.getRaces().contains((Object)race)) continue;
            Skill oldSkill = (Skill)player.getSkills().get(skill.getSkillId());
            if (oldSkill != null) {
                if (oldSkill.getLevel() != skill.getSkillLevel() - 1) continue;
                result.add(skill);
                continue;
            }
            if (skill.getSkillLevel() != 1) continue;
            result.add(skill);
        }
        return result;
    }

    public List<L2SkillLearn> getAvailablePledgeSkills(L2Clan clan) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        for (L2SkillLearn skill : _pledgeSkillTree.values()) {
            if (skill.isResidencialSkill() || clan.getLevel() < skill.getGetLevel()) continue;
            Skill oldSkill = (Skill)clan.getSkills().get(skill.getSkillId());
            if (oldSkill != null) {
                if (oldSkill.getLevel() != skill.getSkillLevel() - 1) continue;
                result.add(skill);
                continue;
            }
            if (skill.getSkillLevel() != 1) continue;
            result.add(skill);
        }
        return result;
    }

    public List<L2SkillLearn> getAvailableSubPledgeSkills(L2Clan clan) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        for (L2SkillLearn skill : _subPledgeSkillTree.values()) {
            if (clan.getLevel() < skill.getGetLevel() || !clan.isLearnableSubSkill(skill.getSkillId(), skill.getSkillLevel())) continue;
            result.add(skill);
        }
        return result;
    }

    public List<L2SkillLearn> getAvailableSubClassSkills(L2PcInstance player) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        for (L2SkillLearn skill : _subClassSkillTree.values()) {
            if (player.getLevel() < skill.getGetLevel()) continue;
            List<L2SkillLearn.SubClassData> subClassConds = null;
            for (SubClass subClass : player.getSubClasses().values()) {
                subClassConds = skill.getSubClassConditions();
                if (subClassConds.isEmpty() || subClass.getClassIndex() > subClassConds.size() || subClass.getClassIndex() != subClassConds.get(subClass.getClassIndex() - 1).getSlot() || subClassConds.get(subClass.getClassIndex() - 1).getLvl() > subClass.getLevel()) continue;
                Skill oldSkill = (Skill)player.getSkills().get(skill.getSkillId());
                if (oldSkill != null) {
                    if (oldSkill.getLevel() != skill.getSkillLevel() - 1) continue;
                    result.add(skill);
                    continue;
                }
                if (skill.getSkillLevel() != 1) continue;
                result.add(skill);
            }
        }
        return result;
    }

    public List<L2SkillLearn> getAvailableResidentialSkills(int residenceId) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        for (L2SkillLearn skill : _pledgeSkillTree.values()) {
            if (!skill.isResidencialSkill() || !skill.getResidenceIds().contains(residenceId)) continue;
            result.add(skill);
        }
        return result;
    }

    public L2SkillLearn getSkillLearn(AcquireSkillType skillType, int id, int lvl, L2PcInstance player) {
        L2SkillLearn sl = null;
        switch (skillType) {
            case CLASS: {
                sl = this.getClassSkill(id, lvl, player.getLearningClass());
                break;
            }
            case TRANSFORM: {
                sl = this.getTransformSkill(id, lvl);
                break;
            }
            case FISHING: {
                sl = this.getFishingSkill(id, lvl);
                break;
            }
            case PLEDGE: {
                sl = this.getPledgeSkill(id, lvl);
                break;
            }
            case SUBPLEDGE: {
                sl = this.getSubPledgeSkill(id, lvl);
                break;
            }
            case TRANSFER: {
                sl = this.getTransferSkill(id, lvl, player.getClassId());
                break;
            }
            case SUBCLASS: {
                sl = this.getSubClassSkill(id, lvl);
                break;
            }
            case COLLECT: {
                sl = this.getCollectSkill(id, lvl);
            }
        }
        return sl;
    }

    public L2SkillLearn getTransformSkill(int id, int lvl) {
        return _transformSkillTree.get(SkillData.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getClassSkill(int id, int lvl, ClassId classId) {
        return this.getCompleteClassSkillTree(classId).get(SkillData.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getFishingSkill(int id, int lvl) {
        return _fishingSkillTree.get(SkillData.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getPledgeSkill(int id, int lvl) {
        return _pledgeSkillTree.get(SkillData.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getSubPledgeSkill(int id, int lvl) {
        return _subPledgeSkillTree.get(SkillData.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getTransferSkill(int id, int lvl, ClassId classId) {
        ClassId parentId;
        if (classId.getParent() != null && _transferSkillTrees.get(parentId = classId.getParent()) != null) {
            return _transferSkillTrees.get(parentId).get(SkillData.getSkillHashCode(id, lvl));
        }
        return null;
    }

    public L2SkillLearn getSubClassSkill(int id, int lvl) {
        return _subClassSkillTree.get(SkillData.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getCommonSkill(int id, int lvl) {
        return _commonSkillTree.get(SkillData.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getCollectSkill(int id, int lvl) {
        return _collectSkillTree.get(SkillData.getSkillHashCode(id, lvl));
    }

    public int getMinLevelForNewSkill(L2PcInstance player, Map<Integer, L2SkillLearn> skillTree) {
        int minLevel = 0;
        if (skillTree.isEmpty()) {
            this._log.warning(this.getClass().getSimpleName() + ": SkillTree is not defined for getMinLevelForNewSkill!");
        } else {
            for (L2SkillLearn s : skillTree.values()) {
                if (!s.isLearnedByNpc() || player.getLevel() >= s.getGetLevel() || minLevel != 0 && minLevel <= s.getGetLevel()) continue;
                minLevel = s.getGetLevel();
            }
        }
        return minLevel;
    }

    public boolean isHeroSkill(int skillId, int skillLevel) {
        if (_heroSkillTree.containsKey(SkillData.getSkillHashCode(skillId, skillLevel))) {
            return true;
        }
        for (L2SkillLearn skill : _heroSkillTree.values()) {
            if (skill.getSkillId() != skillId || skillLevel != -1) continue;
            return true;
        }
        return false;
    }

    public boolean isGMSkill(int skillId, int skillLevel) {
        HashMap<Integer, L2SkillLearn> gmSkills = new HashMap<Integer, L2SkillLearn>();
        gmSkills.putAll(_gameMasterSkillTree);
        gmSkills.putAll(_gameMasterAuraSkillTree);
        if (gmSkills.containsKey(SkillData.getSkillHashCode(skillId, skillLevel))) {
            return true;
        }
        for (L2SkillLearn skill : gmSkills.values()) {
            if (skill.getSkillId() != skillId || skillLevel != -1) continue;
            return true;
        }
        return false;
    }

    public boolean isClanSkill(int skillId, int skillLevel) {
        int hashCode = SkillData.getSkillHashCode(skillId, skillId);
        return _pledgeSkillTree.containsKey(hashCode) || _subPledgeSkillTree.containsKey(hashCode);
    }

    public void addSkills(L2PcInstance gmchar, boolean auraSkills) {
        Collection<L2SkillLearn> skills = auraSkills ? _gameMasterAuraSkillTree.values() : _gameMasterSkillTree.values();
        SkillData st = SkillData.getInstance();
        for (L2SkillLearn sl : skills) {
            gmchar.addSkill(st.getSkill(sl.getSkillId(), sl.getSkillLevel()), false);
        }
    }

    private void generateCheckArrays() {
        Set<ClassId> keySet = _classSkillTrees.keySet();
        this._skillsByClassIdHashCodes = new FastIntObjectMap(keySet.size());
        for (ClassId cls : keySet) {
            int i = 0;
            Map<Integer, L2SkillLearn> tempMap = this.getCompleteClassSkillTree(cls);
            int[] array = new int[tempMap.size()];
            for (int h : tempMap.keySet()) {
                array[i++] = h;
            }
            tempMap.clear();
            Arrays.sort(array);
            this._skillsByClassIdHashCodes.put(cls.ordinal(), (Object)array);
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        this._skillsByRaceHashCodes = new FastIntObjectMap(PcRace.values().length);
        for (PcRace r : PcRace.values()) {
            for (L2SkillLearn s : _fishingSkillTree.values()) {
                if (!s.getRaces().contains((Object)r)) continue;
                list.add(SkillData.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
            }
            for (L2SkillLearn s : _transformSkillTree.values()) {
                if (!s.getRaces().contains((Object)r)) continue;
                list.add(SkillData.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
            }
            int i = 0;
            int[] array = new int[list.size()];
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                int s = (Integer)i$.next();
                array[i++] = s;
            }
            Arrays.sort(array);
            this._skillsByRaceHashCodes.put(r.ordinal(), (Object)array);
            list.clear();
        }
        for (L2SkillLearn s : _commonSkillTree.values()) {
            if (!s.getRaces().isEmpty()) continue;
            list.add(SkillData.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
        }
        for (L2SkillLearn s : _fishingSkillTree.values()) {
            if (!s.getRaces().isEmpty()) continue;
            list.add(SkillData.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
        }
        for (L2SkillLearn s : _transformSkillTree.values()) {
            if (!s.getRaces().isEmpty()) continue;
            list.add(SkillData.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
        }
        for (L2SkillLearn s : _collectSkillTree.values()) {
            list.add(SkillData.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
        }
        this._allSkillsHashCodes = new int[list.size()];
        int j = 0;
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int hashcode = (Integer)i$.next();
            this._allSkillsHashCodes[j++] = hashcode;
        }
        Arrays.sort(this._allSkillsHashCodes);
    }

    public boolean isSkillAllowed(L2PcInstance player, Skill skill) {
        if (skill.isExcludedFromCheck()) {
            return true;
        }
        if (player.isGM() && skill.isGMSkill()) {
            return true;
        }
        if (this._loading) {
            return true;
        }
        int maxLvl = SkillData.getInstance().getMaxLevel(skill.getId());
        int hashCode = SkillData.getSkillHashCode(skill.getId(), Math.min(skill.getLevel(), maxLvl));
        if (Arrays.binarySearch((int[])this._skillsByClassIdHashCodes.get(player.getClassId().ordinal()), hashCode) >= 0) {
            return true;
        }
        if (Arrays.binarySearch((int[])this._skillsByRaceHashCodes.get(player.getRace().ordinal()), hashCode) >= 0) {
            return true;
        }
        if (Arrays.binarySearch(this._allSkillsHashCodes, hashCode) >= 0) {
            return true;
        }
        return this.getTransferSkill(skill.getId(), Math.min(skill.getLevel(), maxLvl), player.getClassId()) != null;
    }

    private void report() {
        int classSkillTreeCount = 0;
        for (Map<Integer, L2SkillLearn> classSkillTree : _classSkillTrees.values()) {
            classSkillTreeCount += classSkillTree.size();
        }
        int trasferSkillTreeCount = 0;
        for (Map<Integer, L2SkillLearn> trasferSkillTree : _transferSkillTrees.values()) {
            trasferSkillTreeCount += trasferSkillTree.size();
        }
        int dwarvenOnlyFishingSkillCount = 0;
        for (L2SkillLearn fishSkill : _fishingSkillTree.values()) {
            if (!fishSkill.getRaces().contains((Object)PcRace.Dwarf)) continue;
            ++dwarvenOnlyFishingSkillCount;
        }
        int resSkillCount = 0;
        for (L2SkillLearn pledgeSkill : _pledgeSkillTree.values()) {
            if (!pledgeSkill.isResidencialSkill()) continue;
            ++resSkillCount;
        }
        String className = this.getClass().getSimpleName();
        this._log.info(className + ": Loaded " + classSkillTreeCount + " Class Skills for " + _classSkillTrees.size() + " Class Skill Trees.");
        this._log.info(className + ": Loaded " + _subClassSkillTree.size() + " Sub-Class Skills.");
        this._log.info(className + ": Loaded " + trasferSkillTreeCount + " Transfer Skills for " + _transferSkillTrees.size() + " Transfer Skill Trees.");
        this._log.info(className + ": Loaded " + _fishingSkillTree.size() + " Fishing Skills, " + dwarvenOnlyFishingSkillCount + " Dwarven only Fishing Skills.");
        this._log.info(className + ": Loaded " + _collectSkillTree.size() + " Collect Skills.");
        this._log.info(className + ": Loaded " + _pledgeSkillTree.size() + " Pledge Skills, " + (_pledgeSkillTree.size() - resSkillCount) + " for Pledge and " + resSkillCount + " Residential.");
        this._log.info(className + ": Loaded " + _subPledgeSkillTree.size() + " Sub-Pledge Skills.");
        this._log.info(className + ": Loaded " + _transformSkillTree.size() + " Transform Skills.");
        this._log.info(className + ": Loaded " + _nobleSkillTree.size() + " Noble Skills.");
        this._log.info(className + ": Loaded " + _heroSkillTree.size() + " Hero Skills.");
        this._log.info(className + ": Loaded " + _gameMasterSkillTree.size() + " Game Master Skills.");
        this._log.info(className + ": Loaded " + _gameMasterAuraSkillTree.size() + " Game Master Aura Skills.");
        int commonSkills = _commonSkillTree.size();
        if (commonSkills > 0) {
            this._log.info(className + ": Loaded " + commonSkills + " Common Skills to all classes.");
        }
    }

    public static SkillTreesData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final SkillTreesData _instance = new SkillTreesData();

        private SingletonHolder() {
        }
    }
}

