/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.script.DateRange;
import com.l2jserver.gameserver.script.EventDrop;
import java.util.Date;
import java.util.List;
import javolution.util.FastList;

public class EventDroplist {
    private static final List<DateDrop> _allNpcDateDrops = new FastList();

    public void addGlobalDrop(int[] itemIdList, int[] count, int chance, DateRange dateRange) {
        _allNpcDateDrops.add(new DateDrop(dateRange, new EventDrop(itemIdList, (long)count[0], (long)count[1], chance)));
    }

    public void addGlobalDrop(int itemId, long min, long max, int chance, DateRange dateRange) {
        _allNpcDateDrops.add(new DateDrop(dateRange, new EventDrop(itemId, min, max, chance)));
    }

    public void addGlobalDrop(DateRange dateRange, EventDrop eventDrop) {
        _allNpcDateDrops.add(new DateDrop(dateRange, eventDrop));
    }

    public List<DateDrop> getAllDrops() {
        FastList list = new FastList();
        Date currentDate = new Date();
        for (DateDrop drop : _allNpcDateDrops) {
            if (!drop._dateRange.isWithinRange(currentDate)) continue;
            list.add(drop);
        }
        return list;
    }

    public static EventDroplist getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final EventDroplist _instance = new EventDroplist();

        private SingletonHolder() {
        }
    }

    public static class DateDrop {
        protected final DateRange _dateRange;
        private final EventDrop _eventDrop;

        public DateDrop(DateRange dateRange, EventDrop eventDrop) {
            this._dateRange = dateRange;
            this._eventDrop = eventDrop;
        }

        public EventDrop getEventDrop() {
            return this._eventDrop;
        }

        public DateRange getDateRange() {
            return this._dateRange;
        }
    }
}

