/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.base.ClassInfo;
import com.l2jserver.gameserver.model.base.PlayerClass;
import gnu.trove.map.hash.TIntObjectHashMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ClassListData
extends DocumentParser {
    private static final TIntObjectHashMap<ClassInfo> _classData = new TIntObjectHashMap();

    protected ClassListData() {
        this.load();
    }

    @Override
    public void load() {
        _classData.clear();
        this.parseDatapackFile("data/stats/chars/classList.xml");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + _classData.size() + " Class data.");
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equals(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                NamedNodeMap attrs = d.getAttributes();
                if (!"class".equals(d.getNodeName())) continue;
                Node attr = attrs.getNamedItem("classId");
                ClassId classId = ClassId.getClassId(this.parseInteger(attr));
                attr = attrs.getNamedItem("name");
                String className = attr.getNodeValue();
                attr = attrs.getNamedItem("serverName");
                String classServName = attr.getNodeValue();
                attr = attrs.getNamedItem("parentClassId");
                ClassId parentClassId = attr != null ? ClassId.getClassId(this.parseInteger(attr)) : null;
                _classData.put(classId.getId(), (Object)new ClassInfo(classId, className, classServName, parentClassId));
            }
        }
    }

    public ClassInfo getClass(ClassId classId) {
        return (ClassInfo)_classData.get(classId.getId());
    }

    public ClassInfo getClass(PlayerClass playerClass) {
        return (ClassInfo)_classData.get(playerClass.getId());
    }

    public ClassInfo getClass(int classId) {
        return (ClassInfo)_classData.get(classId);
    }

    public static ClassListData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final ClassListData _instance = new ClassListData();

        private SingletonHolder() {
        }
    }
}

