/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.ThreadPoolManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckDynamicIpAddressTask
implements Runnable {
    private static final Logger _log = Logger.getLogger(CheckDynamicIpAddressTask.class.getName());
    static final long CHECK_DYNAMIC_IP_ADDRESS_INITIAL = 1800000L;
    static final long CHECK_DYNAMIC_IP_ADDRESS_DELAY = 900000L;
    private static String[] WHAT_IS_MY_IP_URL = new String[]{"http://bot.whatismyipaddress.com", "http://checkip.dyndns.com/", "http://checkip.dyndns.org/", "http://checkmyip.com/", "http://ip1.dynupdate.no-ip.com:8245/", "http://ipaddress.com/", "http://ipecho.net/plain", "http://myip.dnsomatic.com", "http://myip.is/", "http://myip.nt0.biz/", "http://taruo.net/ip/?", "http://whatismyipaddress.com/ip-lookup", "http://whatsmyip.net/", "http://www.akakagemaru.info/cgi-bin/index.cgi", "http://www.canyouseeme.org/", "http://www.cybersyndrome.net/evc.html", "http://www.findmyipaddress.com/", "http://www.howtofindmyipaddress.com/", "http://www.ipchicken.com/", "http://www.iprivacytools.com/my-ip-address/", "http://www.my-ip-address.net/", "http://www.show-ip-addr.com/en/", "http://www.showmyip.gr/", "http://www.tracemyip.org/", "http://www.whereisip.net/"};
    public static boolean isAutoIpConfig;
    private static int _index;
    private static ScheduledFuture<?> _checkDynamicIpAddressTask;

    @Override
    public void run() {
        if (LoginServerThread.getInstance().getServerName() == null) {
            return;
        }
        String ip = this.whatIsMyIp();
        if (ip != null) {
            if (ip.equals(Config.IPConfigData.externalIp)) {
                _log.fine("Network Config: Current external IP address is '" + ip + "'");
            } else {
                _log.warning("Network Config: External IP address was changed '" + ip + "' from '" + Config.IPConfigData.externalIp + "'. Trying to reconnect the Login Server.");
                List<String> hosts = Config.GAME_SERVER_HOSTS;
                List<String> subnets = Config.GAME_SERVER_SUBNETS;
                int i = hosts.size();
                while (--i >= 0) {
                    if (!hosts.get(i).equals(Config.IPConfigData.externalIp) || !subnets.get(i).equals("0.0.0.0/0")) continue;
                    hosts.set(i, ip);
                    Config.IPConfigData.externalIp = ip;
                    System.out.println(CheckDynamicIpAddressTask.toIpConfigXml());
                    LoginServerThread.getInstance().disconnect();
                    break;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String whatIsMyIp() {
        _index = (_index + 1) % WHAT_IS_MY_IP_URL.length;
        String url = WHAT_IS_MY_IP_URL[_index];
        _log.info("Network Config: Check external IP address from '" + url + "'");
        try {
            URL autoIp = new URL(url);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(autoIp.openStream()));){
                String temp;
                Matcher match;
                Pattern pattern = Pattern.compile("(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)");
                do {
                    if ((temp = in.readLine()) == null) return null;
                } while (!(match = pattern.matcher(temp)).find());
                String string = match.group();
                return string;
            }
            catch (IOException e) {
                _log.warning("<!>Network Config: " + e.getMessage());
                return null;
            }
        }
        catch (MalformedURLException e) {
            _log.log(Level.WARNING, "", e);
        }
        return null;
    }

    public static String toIpConfigXml() {
        String T = "\t|";
        StringBuilder a = new StringBuilder(256);
        StringBuilder b = new StringBuilder(256);
        List<String> hosts = Config.GAME_SERVER_HOSTS;
        List<String> subnets = Config.GAME_SERVER_SUBNETS;
        for (int i = 0; i < hosts.size(); ++i) {
            String subnet = subnets.get(i);
            String host = hosts.get(i);
            if (subnet.equals("0.0.0.0/0")) {
                a.append("\t|").append("<gameserver address=\"").append(host).append("\">\n");
                continue;
            }
            b.append("\t|").append("\t<define subnet=\"").append(subnet).append(" address=\"").append(host).append("\" />\n");
        }
        return a.append((CharSequence)b).append("\t|</gameserver>").toString();
    }

    public static void start() {
        if (isAutoIpConfig && _checkDynamicIpAddressTask == null) {
            _checkDynamicIpAddressTask = ThreadPoolManager.getInstance().scheduleGeneralWithFixedDelay(new CheckDynamicIpAddressTask(), 1800000L, 900000L);
        }
    }

    static {
        _index = -1;
    }
}

