/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.python.core.Py;
import org.python.core.PyDescriptor;
import org.python.core.PyObject;
import org.python.core.PyType;

public class PyFieldDescr
extends PyDescriptor {
    private Field field;
    private Class field_type;
    private boolean readonly;

    public PyFieldDescr(String string, Class clazz, String string2) {
        this(string, clazz, string2, false);
    }

    public PyFieldDescr(String string, Class clazz, String string2, boolean bl) {
        this.name = string;
        this.dtype = PyType.fromClass(clazz);
        try {
            this.field = clazz.getField(string2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw Py.SystemError("bogus attribute spec");
        }
        int n = this.field.getModifiers();
        if (Modifier.isStatic(n)) {
            throw Py.SystemError("static attributes not supported");
        }
        this.readonly = bl || Modifier.isFinal(n);
        this.field_type = this.field.getType();
    }

    public String toString() {
        return "<member '" + this.name + "' of '" + this.dtype.fastGetName() + "' objects>";
    }

    public PyObject __get__(PyObject pyObject, PyObject pyObject2) {
        try {
            if (pyObject != null) {
                PyType pyType = pyObject.getType();
                if (pyType != this.dtype && !pyType.isSubType(this.dtype)) {
                    throw this.get_wrongtype(pyType);
                }
                return Py.java2py(this.field.get(pyObject));
            }
            return this;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Py.JavaError(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Py.JavaError(illegalAccessException);
        }
    }

    public void __set__(PyObject pyObject, PyObject pyObject2) {
        try {
            PyType pyType = pyObject.getType();
            if (pyType != this.dtype && !pyType.isSubType(this.dtype)) {
                throw this.get_wrongtype(pyType);
            }
            Object object = pyObject2.__tojava__(this.field_type);
            if (object == Py.NoConversion) {
                throw Py.TypeError("");
            }
            this.field.set(pyObject, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Py.JavaError(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Py.JavaError(illegalAccessException);
        }
    }

    public boolean implementsDescrSet() {
        return !this.readonly;
    }

    public boolean isDataDescr() {
        return true;
    }
}

