# Made by disKret & DrLecter
import sys
from com.l2jserver import Config
from com.l2jserver.gameserver.model.quest import State
from com.l2jserver.gameserver.model.quest import QuestState
from com.l2jserver.gameserver.model.quest import Quest as JQuest
from com.l2jserver.gameserver.enums import QuestSound
qn = "380_BringOutTheFlavorOfIngredients"

#NPC
ROLLANT = 30069

#MOBS
DIRE_WOLF = 20205
KADIF_WEREWOLF = 20206
GIANT_MIST_LEECH = 20225

#ITEMS
RITRONS_FRUIT,MOON_FACE_FLOWER,LEECH_FLUIDS = range(5895,5898)
ANTIDOTE = 1831
RITRON_JELLY = 5960
JELLY_RECIPE = 5959

#mob:[chance,item,max]
DROPLIST = {
DIRE_WOLF:[10,RITRONS_FRUIT,4],
KADIF_WEREWOLF:[50,MOON_FACE_FLOWER,20],
GIANT_MIST_LEECH:[50,LEECH_FLUIDS,10]
}

#CHANCE
RECIPE_CHANCE = 55

class Quest (JQuest) :

 def __init__(self,id,name,descr):
     JQuest.__init__(self,id,name,descr)
     self.questItemIds = range(5895,5898)

 def onEvent (self,event,st) :
   htmltext = event
   if event == "30069-4.htm" :
     st.set("cond","1")
     st.setState(State.STARTED)
     st.playSound(QuestSound.ITEMSOUND_QUEST_ACCEPT)
   elif event == "30069-12.htm" :
     if st.getInt("cond") == 6 :
        st.giveItems(JELLY_RECIPE,1)
        st.playSound(QuestSound.ITEMSOUND_QUEST_FINISH)
     else :
        htmltext = "I'll squeeze the jelly from your eyes"
     st.exitQuest(1)
   return htmltext

 def onTalk (self,npc,player):
   htmltext = Quest.getNoQuestMsg(player)
   st = player.getQuestState(qn)
   if not st : return htmltext

   npcId = npc.getId()
   id = st.getState()
   cond=st.getInt("cond")
   if cond == 0 :
     if player.getLevel() >= 24 :
       htmltext = "30069-1.htm"
     else:
       htmltext = "30069-0.htm"
       st.exitQuest(1)
   elif cond == 1 :
     htmltext = "30069-6.htm"
   elif cond == 2 :
     if st.getQuestItemsCount(ANTIDOTE) >= 2 and st.getQuestItemsCount(RITRONS_FRUIT) == 4 and st.getQuestItemsCount(MOON_FACE_FLOWER) == 20 and st.getQuestItemsCount(LEECH_FLUIDS) == 10 :
        st.takeItems(RITRONS_FRUIT,-1)
        st.takeItems(MOON_FACE_FLOWER,-1)
        st.takeItems(LEECH_FLUIDS,-1)
        st.takeItems(ANTIDOTE,2)
        st.set("cond","3")
        htmltext = "30069-7.htm"
     else :
        htmltext = "30069-6.htm"
   elif cond == 3 :
     st.set("cond","4")
     htmltext = "30069-8.htm"
   elif cond == 4 :
     st.set("cond","5")
     htmltext = "30069-9.htm"
   elif cond == 5 :
     st.set("cond","6")
     htmltext = "30069-10.htm"
   elif cond == 6 :
     st.giveItems(RITRON_JELLY,1)
     if self.getRandom(100) < RECIPE_CHANCE :
        htmltext = "30069-11.htm"
     else :
        htmltext = "30069-13.htm"
        st.playSound(QuestSound.ITEMSOUND_QUEST_FINISH)
        st.exitQuest(1)
   return htmltext

 def onKill(self,npc,player,isPet):
   st = player.getQuestState(qn)
   if not st : return 
   if st.getState() != State.STARTED : return 
   
   if st.getInt("cond") == 1 :
      chance,item,max = DROPLIST[npc.getId()]
      numItems,chance = divmod(chance*Config.RATE_QUEST_DROP,100)
      count = st.getQuestItemsCount(item)
      if count < max :
         if self.getRandom(100) < chance :
            numItems = numItems + 1
         numItems = int(numItems)
         if count + numItems > max :
            numItems = max - count
         if numItems != 0 :
            st.giveItems(item,numItems)
            if st.getQuestItemsCount(RITRONS_FRUIT) == 4 and st.getQuestItemsCount(MOON_FACE_FLOWER) == 20 and st.getQuestItemsCount(LEECH_FLUIDS) == 10 :
               st.set("cond","2")
               st.playSound(QuestSound.ITEMSOUND_QUEST_MIDDLE)
            else :
               st.playSound(QuestSound.ITEMSOUND_QUEST_ITEMGET)
   return

QUEST       = Quest(380,qn,'fނ̖𐶂I')

QUEST.addStartNpc(ROLLANT)

QUEST.addTalkId(ROLLANT)

for mob in DROPLIST.keys():
    QUEST.addKillId(mob)