/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.npc.ZealotOfShilen;

import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;

/**
 * Zealot of Shilen AI.
 * @author nonom
 */
public final class ZealotOfShilen extends AbstractNpcAI
{
	// NPCs
	private static final int ZEALOT = 18782;
	private static final int[] GUARDS =
	{
		32628,
		32629
	};
	
	private ZealotOfShilen()
	{
		super(ZealotOfShilen.class.getSimpleName(), "ai/npc");
		addSpawnId(ZEALOT);
		addSpawnId(GUARDS);	//+[JOJO]
		addMoveFinishedId(GUARDS);	//+[JOJO]
		addFirstTalkId(GUARDS);
		
if (!com.l2jserver.Config.FIX_onSpawn_for_SpawnTable) {{
		for (int npcId : GUARDS)
		{
			for (L2Spawn spawn : SpawnTable.getInstance().getSpawns(npcId))
			{
				L2Npc guard = spawn.getLastSpawn();
				guard.setIsInvul(true);
				((L2Attackable) guard).setCanReturnToSpawnPoint(false);
			//	startQuestTimer("WATCHING", 10000, guard, null, true);	//-[JOJO] --> onMoveFinished
			}
		}
		for (L2Spawn spawn : SpawnTable.getInstance().getSpawns(ZEALOT))
		{
			spawn.getLastSpawn().setIsNoRndWalk(true);
		}
}}
	}
	
	private boolean thinkAttack(L2GuardInstance guard)
	{
		// GUARDS[]
		if (!guard.isInCombat() && !guard.getKnownList().getKnownPlayers().isEmpty())
		{
			for (L2Character character : guard.getKnownList().getKnownCharacters())
			{
				if (character.isMonster() && !character.isDead() && !((L2Attackable) character).isDecayed())
				{
					guard.setRunning();
					guard.addDamageHate(character, 0, 999);
					guard.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, character, null);
					return true;
				}
			}
		}
		return false;
	}
	
	@Override
	public boolean onMoveFinished(L2Npc npc)	//[JOJO] onAdvEvent(|[O) --> onMoveFinished(Cxghu)
	{
		// GUARDS[]
		return thinkAttack((L2GuardInstance) npc);
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		// GUARDS[]
		return (npc.isAttackingNow()) ? "32628-01.html" : npc.getId() + ".html";
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
		switch (npc.getNpcId())
		{
			case ZEALOT:
				npc.setIsNoRndWalk(true);
				for (L2Character character : npc.getKnownList().getKnownCharacters())
					if (character instanceof L2GuardInstance)
						thinkAttack((L2GuardInstance) character);
				break;
			case 32628: case 32629: // GUARDS[]
				npc.setIsInvul(true);
				if (!com.l2jserver.Config.NEVER_WALKER_ReturnToSpawnPoint) ((L2Attackable) npc).setCanReturnToSpawnPoint(false);
				break;
		}
		return super.onSpawn(npc);
	}
	
	public static void main(String[] args)
	{
		new ZealotOfShilen();
	}
}
