/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.npc.Rignos;

import static com.l2jserver.gameserver.datatables.SkillTable.*;
import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.AbnormalVisualEffect;

/**
 * Rignos AI.
 * @author St3eT
 */
public class Rignos extends AbstractNpcAI
{
	private static final boolean MOD_VISUAL = true;	//+[JOJO]
	private static final boolean MOD_SOUND = true;	//+[JOJO]
	// NPC
	private static final int RIGNOS = 32349; // Rignos
	// Item
	private static final int STAMP = 10013; // Race Stamp
	private static final int KEY = 9694; // Secret Key
	// Skill
	private static final int TIMER = getSkillHashCode(5239, 5); // Event Timer
	// Misc
	private static final int MIN_LV = 78;
	private static final int NUM_OF_STAMPS = 4;
	private static final long TIME_OUT = getSkill(TIMER).getAbnormalTime() * 1000;	// 1800000
	
	private Rignos()
	{
		super(Rignos.class.getSimpleName(), "ai/npc");
		addStartNpc(RIGNOS);
		addTalkId(RIGNOS);
		addFirstTalkId(RIGNOS);
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		switch (event)
		{
			case "32349-03.html":
			{
				return event;
			}
			case "startRace":
			{
				if (npc.compareAndSetScriptValue(0, 1))
				{
					QuestManager.getInstance().getQuest("PrisonGuards").onAdvEvent("CLEAR_STATUS", null, null);
					
					startQuestTimer("TIME_OUT", TIME_OUT, npc, null);
					getSkill(TIMER).applyEffects(player, player);
					if (player.hasSummon())
					{
						getSkill(TIMER).applyEffects(player.getSummon(), player.getSummon());
					}
					
					takeItems(player, STAMP, -1);
					if (MOD_SOUND) playSound(player, "ItemSound2.race_start");
					if (MOD_VISUAL) npc.startAbnormalVisualEffect(true, AbnormalVisualEffect.VP_UP);
				}
				break;
			}
			case "exchange":
			{
				if (getQuestItemsCount(player, STAMP) >= NUM_OF_STAMPS)
				{
					giveItems(player, KEY, 3);
					takeItems(player, STAMP, -1);
					player.stopSkillEffects(true, getSkillId(TIMER));	//+[JOJO]
					if (MOD_SOUND) playSound(player, "ItemSound.quest_finish");
				}
				break;
			}
			case "TIME_OUT":
			{
				npc.setScriptValue(0);
				if (MOD_VISUAL) npc.stopAbnormalVisualEffect(true, AbnormalVisualEffect.VP_UP);
				break;
			}
		}
		return super.onAdvEvent(event, npc, player);
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		final String htmltext;
		if (getQuestItemsCount(player, STAMP) >= NUM_OF_STAMPS)
		{
			htmltext = "32349-01.html";	// "exchange"
		}
		else if (player.isAffectedBySkill(getSkillId(TIMER)))
		{
			htmltext = getQuestItemsCount(player, STAMP) == 0 ? "32349-started.htm" : "32349-notfinish.htm";
		}
		else if (npc.isScriptValue(1) || player.getLevel() < MIN_LV)
		{
			htmltext = "32349-02.html";
		}
		else
		{
			htmltext = "32349.html";	// "startRace"
		}
		return htmltext;
	}
	
	//[JOJO]-------------------------------------------------
	@Override
	public boolean unload()
	{
		for (L2Object o : L2World.getInstance().getVisibleObjects()) {
			if (o instanceof L2Npc) {
				L2Npc npc = (L2Npc) o;
				switch (npc.getNpcId()) {
					case RIGNOS:
						if (MOD_VISUAL) npc.stopAbnormalVisualEffect(true, AbnormalVisualEffect.VP_UP);
					case 18367:	// Prison Guard
					case 18368:	// Prison Guard
						npc.deleteMe();
						break;
				}
			}
		}
		return super.unload();
	}
	//-------------------------------------------------------
	
	public static void main(String[] args)
	{
		new Rignos();
	}
}