/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.group_template;

import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;
import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.clientpackets.Say2;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;

/**
 * Polymorphing on attack monsters AI.
 * @author Slyce
 */
public class PolymorphingOnAttack extends AbstractNpcAI
{
	private static final SortedIntObjectArrayMap<int[]> MOBSPAWNS = new SortedIntObjectArrayMap<int[]>()
		.append(21258, new int[]{21259, 100, 100, -1}) // Fallen Orc Shaman -> Sharp Talon Tiger (always polymorphs)
		.append(21261, new int[]{21262, 100, 20, 0}) // Ol Mahum Transcender 1st stage
		.append(21262, new int[]{21263, 100, 10, 1}) // Ol Mahum Transcender 2nd stage
		.append(21263, new int[]{21264, 100, 5, 2}) // Ol Mahum Transcender 3rd stage
		.append(21265, new int[]{21271, 100, 33, 0}) // Cave Ant Larva -> Cave Ant
		.append(21266, new int[]{21269, 100, 100, -1}) // Cave Ant Larva -> Cave Ant (always polymorphs)
		.append(21267, new int[]{21270, 100, 100, -1}) // Cave Ant Larva -> Cave Ant Soldier (always polymorphs)
		.append(21271, new int[]{21272, 66, 10, 1}) // Cave Ant -> Cave Ant Soldier
		.append(21272, new int[]{21273, 33, 5, 2}) // Cave Ant Soldier -> Cave Noble Ant
		.append(21521, new int[]{21522, 100, 30, -1}) // Claws of Splendor
		.append(21527, new int[]{21528, 100, 30, -1}) // Anger of Splendor
		.append(21533, new int[]{21534, 100, 30, -1}) // Alliance of Splendor
		.append(21537, new int[]{21538, 100, 30, -1}) // Fang of Splendor
	;
	protected static final NpcStringId[][] MOBTEXTS =
	{
		new NpcStringId[]
		{
			NpcStringId.ENOUGH_FOOLING_AROUND_GET_READY_TO_DIE,
			NpcStringId.YOU_IDIOT_IVE_JUST_BEEN_TOYING_WITH_YOU,
			NpcStringId.NOW_THE_FUN_STARTS
		},
		new NpcStringId[]
		{
			NpcStringId.I_MUST_ADMIT_NO_ONE_MAKES_MY_BLOOD_BOIL_QUITE_LIKE_YOU_DO,
			NpcStringId.NOW_THE_BATTLE_BEGINS,
			NpcStringId.WITNESS_MY_TRUE_POWER
		},
		new NpcStringId[]
		{
			NpcStringId.PREPARE_TO_DIE,
			NpcStringId.ILL_DOUBLE_MY_STRENGTH,
			NpcStringId.YOU_HAVE_MORE_SKILL_THAN_I_THOUGHT
		}
	};
	
	private PolymorphingOnAttack()
	{
		super(PolymorphingOnAttack.class.getSimpleName(), "ai/group_template");
		registerMobs(MOBSPAWNS.keys(), QuestEventType.ON_ATTACK);
	}
	
	@Override
	public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isSummon)
	{
		if (npc.isVisible() && !npc.isDead())
		{
			final int[] tmp = MOBSPAWNS.get(npc.getId());
			if (tmp != null)
			{
				if ((npc.getCurrentHp() <= ((npc.getMaxHp() * tmp[1]) / 100.0)) && (getRandom(100) < tmp[2]))
				{
				//	if (tmp[3] >= 0)	//-[JOJO]
				//	{
				//		NpcStringId npcString = MOBTEXTS[tmp[3]][getRandom(MOBTEXTS[tmp[3]].length)];
				//		npc.broadcastPacket(new CreatureSay(npc.getObjectId(), Say2.NPC_ALL, npc.getName(), npcString));
				//		
				//	}
					npc.deleteMe();
					L2Attackable newNpc = (L2Attackable) addSpawn(tmp[0], npc.getX(), npc.getY(), npc.getZ() + 10, npc.getHeading(), false, 0, true);
					L2Character originalAttacker = isSummon ? attacker.getSummon() : attacker;
					newNpc.setRunning();
					newNpc.addDamageHate(originalAttacker, 0, 500);
					newNpc.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, originalAttacker);
					if (tmp[3] >= 0)	//+[JOJO]
					{
						NpcStringId npcString = MOBTEXTS[tmp[3]][getRandom(MOBTEXTS[tmp[3]].length)];
						newNpc.broadcastPacket(new NpcSay(newNpc.getObjectId(), Say2.NPC_ALL, newNpc.getId(), npcString));
						
					}
				}
			}
		}
		return super.onAttack(npc, attacker, damage, isSummon);
	}
	
	public static void main(String[] args)
	{
		new PolymorphingOnAttack();
	}
}
