/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.model.PageResult;
import com.l2jserver.gameserver.model.interfaces.IFunction;
import com.l2jserver.gameserver.util.Util;
import java.util.Arrays;
import java.util.Collection;

public class HtmlUtil {
    public static String getCpGauge(int width, long current, long max, boolean displayAsPercentage) {
        return HtmlUtil.getGauge(width, current, max, displayAsPercentage, "L2UI_CT1.Gauges.Gauge_DF_Large_CP_bg_Center", "L2UI_CT1.Gauges.Gauge_DF_Large_CP_Center", 17L, -13L);
    }

    public static String getHpGauge(int width, long current, long max, boolean displayAsPercentage) {
        return HtmlUtil.getGauge(width, current, max, displayAsPercentage, "L2UI_CT1.Gauges.Gauge_DF_Large_HP_bg_Center", "L2UI_CT1.Gauges.Gauge_DF_Large_HP_Center", 17L, -13L);
    }

    public static String getHpWarnGauge(int width, long current, long max, boolean displayAsPercentage) {
        return HtmlUtil.getGauge(width, current, max, displayAsPercentage, "L2UI_CT1.Gauges.Gauge_DF_Large_HPWarn_bg_Center", "L2UI_CT1.Gauges.Gauge_DF_Large_HPWarn_Center", 17L, -13L);
    }

    public static String getHpFillGauge(int width, long current, long max, boolean displayAsPercentage) {
        return HtmlUtil.getGauge(width, current, max, displayAsPercentage, "L2UI_CT1.Gauges.Gauge_DF_Large_HPFill_bg_Center", "L2UI_CT1.Gauges.Gauge_DF_Large_HPFill_Center", 17L, -13L);
    }

    public static String getMpGauge(int width, long current, long max, boolean displayAsPercentage) {
        return HtmlUtil.getGauge(width, current, max, displayAsPercentage, "L2UI_CT1.Gauges.Gauge_DF_Large_MP_bg_Center", "L2UI_CT1.Gauges.Gauge_DF_Large_MP_Center", 17L, -13L);
    }

    public static String getExpGauge(int width, long current, long max, boolean displayAsPercentage) {
        return HtmlUtil.getGauge(width, current, max, displayAsPercentage, "L2UI_CT1.Gauges.Gauge_DF_Large_EXP_bg_Center", "L2UI_CT1.Gauges.Gauge_DF_Large_EXP_Center", 17L, -13L);
    }

    public static String getFoodGauge(int width, long current, long max, boolean displayAsPercentage) {
        return HtmlUtil.getGauge(width, current, max, displayAsPercentage, "L2UI_CT1.Gauges.Gauge_DF_Large_Food_Bg_Center", "L2UI_CT1.Gauges.Gauge_DF_Large_Food_Center", 17L, -13L);
    }

    public static String getWeightGauge(int width, long current, long max, boolean displayAsPercentage) {
        return HtmlUtil.getWeightGauge(width, current, max, displayAsPercentage, Util.map(current, 0L, max, 1L, 5L));
    }

    public static String getWeightGauge(int width, long current, long max, boolean displayAsPercentage, long level) {
        return HtmlUtil.getGauge(width, current, max, displayAsPercentage, "L2UI_CT1.Gauges.Gauge_DF_Large_Weight_bg_Center" + level, "L2UI_CT1.Gauges.Gauge_DF_Large_Weight_Center" + level, 17L, -13L);
    }

    private static String getGauge(int width, long current, long max, boolean displayAsPercentage, String backgroundImage, String image, long imageHeight, long top) {
        current = Math.min(current, max);
        StringBuilder sb = new StringBuilder(256);
        sb.append("<table width=");
        sb.append(width);
        sb.append(" cellpadding=0 cellspacing=0><tr><td background=\"");
        sb.append(backgroundImage);
        sb.append("\"><img src=\"");
        sb.append(image);
        sb.append("\" width=");
        sb.append((long)((double)current / (double)max * (double)width));
        sb.append(" height=");
        sb.append(imageHeight);
        sb.append("></td></tr><tr><td align=center><table cellpadding=0 cellspacing=");
        sb.append(top);
        sb.append("><tr><td>");
        if (displayAsPercentage) {
            sb.append("<table cellpadding=0 cellspacing=2><tr><td>");
            sb.append(String.format("%.2f%%", (double)current / (double)max * 100.0));
            sb.append("</td></tr></table>");
        } else {
            int tdWidth = (width - 10) / 2;
            sb.append("<table cellpadding=0 cellspacing=0><tr><td width=");
            sb.append(tdWidth);
            sb.append(" align=right>");
            sb.append(current);
            sb.append("</td><td width=10 align=center>/</td><td width=");
            sb.append(tdWidth);
            sb.append('>');
            sb.append(max);
            sb.append("</td></tr></table>");
        }
        sb.append("</td></tr></table></td></tr></table>");
        return sb.toString();
    }

    public static <T> PageResult createPage(Collection<T> elements, int page, int elementsPerPage, IFunction<Integer, String> pagerProcedure, IFunction<T, String> bodyProcedure) {
        return HtmlUtil.createPage(elements, elements.size(), page, elementsPerPage, pagerProcedure, bodyProcedure);
    }

    public static <T> PageResult createPage(T[] elements, int page, int elementsPerPage, IFunction<Integer, String> pagerProcedure, IFunction<T, String> bodyProcedure) {
        return HtmlUtil.createPage(Arrays.asList(elements), elements.length, page, elementsPerPage, pagerProcedure, bodyProcedure);
    }

    public static <T> PageResult createPage(Iterable<T> elements, int size, int page, int elementsPerPage, IFunction<Integer, String> pagerProcedure, IFunction<T, String> bodyProcedure) {
        int pages = size / elementsPerPage;
        if (elementsPerPage * pages < size) {
            ++pages;
        }
        StringBuilder pagerTemplate = new StringBuilder(256);
        if (pages > 1) {
            for (int i = 0; i < pages; ++i) {
                pagerTemplate.append(pagerProcedure.execute(i));
            }
        }
        if (page >= pages) {
            page = pages - 1;
        }
        int start = 0;
        if (page > 0) {
            start = elementsPerPage * page;
        }
        StringBuilder sb = new StringBuilder(256);
        int i = 0;
        for (T element : elements) {
            if (i++ < start) continue;
            sb.append(bodyProcedure.execute(element));
            if (i < elementsPerPage + start) continue;
            break;
        }
        return new PageResult(pages, pagerTemplate, sb);
    }
}

