/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager.tasks;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.taskmanager.Task;
import com.l2jserver.gameserver.taskmanager.TaskManager;
import com.l2jserver.gameserver.taskmanager.TaskTypes;
import java.sql.Connection;
import java.sql.PreparedStatement;

public class TaskDailySkillReuseClean
extends Task {
    private static final String NAME = "daily_skill_clean";
    private static final int[] _daily_skills = new int[]{2510, 22180};

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void onTimeElapsed(TaskManager.ExecutedTask task) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            for (int skill_id : _daily_skills) {
                try (PreparedStatement ps = con.prepareStatement("DELETE FROM character_skills_save WHERE skill_id=?;");){
                    ps.setInt(1, skill_id);
                    ps.execute();
                }
            }
        }
        catch (Exception e) {
            this._log.severe(this.getClass().getSimpleName() + ": Could not reset daily skill reuse: " + e);
        }
        this._log.info("Daily skill reuse cleaned.");
    }

    @Override
    public void initializate() {
        super.initializate();
        TaskManager.addUniqueTask(NAME, TaskTypes.TYPE_GLOBAL_TASK, "1", "06:30:00", "");
    }
}

