/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.script.faenor;

import com.l2jserver.gameserver.script.Parser;
import com.l2jserver.gameserver.script.ParserFactory;
import com.l2jserver.gameserver.script.ScriptEngine;
import com.l2jserver.gameserver.script.faenor.FaenorParser;
import java.util.logging.Logger;
import javax.script.ScriptContext;
import org.w3c.dom.Node;

public class FaenorQuestParser
extends FaenorParser {
    protected static final Logger _log = Logger.getLogger(FaenorQuestParser.class.getName());

    @Override
    public void parseScript(Node questNode, ScriptContext context) {
        String questID = FaenorQuestParser.attribute(questNode, "ID");
        for (Node node = questNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (FaenorQuestParser.isNodeName(node, "DROPLIST")) {
                this.parseQuestDropList(node.cloneNode(true), questID);
                continue;
            }
            if (!FaenorQuestParser.isNodeName(node, "DIALOG WINDOWS") && !FaenorQuestParser.isNodeName(node, "INITIATOR") && !FaenorQuestParser.isNodeName(node, "STATE")) continue;
        }
    }

    private void parseQuestDropList(Node dropList, String questID) throws NullPointerException {
        for (Node node = dropList.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!FaenorQuestParser.isNodeName(node, "DROP")) continue;
            this.parseQuestDrop(node.cloneNode(true), questID);
        }
    }

    private void parseQuestDrop(Node drop, String questID) {
        String[] states;
        int chance;
        int max;
        int min;
        int itemID;
        int npcID;
        try {
            npcID = FaenorQuestParser.getInt(FaenorQuestParser.attribute(drop, "NpcID"));
            itemID = FaenorQuestParser.getInt(FaenorQuestParser.attribute(drop, "ItemID"));
            min = FaenorQuestParser.getInt(FaenorQuestParser.attribute(drop, "Min"));
            max = FaenorQuestParser.getInt(FaenorQuestParser.attribute(drop, "Max"));
            chance = FaenorQuestParser.getInt(FaenorQuestParser.attribute(drop, "Chance"));
            states = FaenorQuestParser.attribute(drop, "States").split(",");
        }
        catch (NullPointerException e) {
            throw new NullPointerException("Incorrect Drop Data");
        }
        _bridge.addQuestDrop(npcID, itemID, min, max, chance, questID, states);
    }

    static {
        ScriptEngine.parserFactories.put(FaenorQuestParser.getParserName("Quest"), new FaenorQuestParserFactory());
    }

    static class FaenorQuestParserFactory
    extends ParserFactory {
        FaenorQuestParserFactory() {
        }

        @Override
        public Parser create() {
            return new FaenorQuestParser();
        }
    }
}

