/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ExperienceTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.skills.AbnormalVisualEffect;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public final class UserInfo
extends L2GameServerPacket {
    private final L2PcInstance _activeChar;
    private int _relation;
    private int _airShipHelm;
    private final int _runSpd;
    private final int _walkSpd;
    private final int _swimRunSpd;
    private final int _swimWalkSpd;
    private final int _flRunSpd = 0;
    private final int _flWalkSpd = 0;
    private final int _flyRunSpd;
    private final int _flyWalkSpd;
    private final float _moveMultiplier;

    public UserInfo(L2PcInstance cha) {
        this._activeChar = cha;
        int _territoryId = TerritoryWarManager.getInstance().getRegisteredTerritoryId(cha);
        int n = this._relation = this._activeChar.isClanLeader() ? 64 : 0;
        if (this._activeChar.getSiegeState() == 1) {
            this._relation = _territoryId == 0 ? (this._relation |= 0x180) : (this._relation |= 0x1000);
        }
        if (this._activeChar.getSiegeState() == 2) {
            this._relation |= 0x80;
        }
        this._airShipHelm = this._activeChar.isInAirShip() && this._activeChar.getAirShip().isCaptain(this._activeChar) ? this._activeChar.getAirShip().getHelmItemId() : 0;
        this._moveMultiplier = cha.getMovementSpeedMultiplier();
        this._runSpd = Math.round((float)cha.getRunSpeed() / this._moveMultiplier);
        this._walkSpd = Math.round((float)cha.getWalkSpeed() / this._moveMultiplier);
        this._swimRunSpd = Math.round((float)cha.getSwimRunSpeed() / this._moveMultiplier);
        this._swimWalkSpd = Math.round((float)cha.getSwimWalkSpeed() / this._moveMultiplier);
        this._flyRunSpd = cha.isFlying() ? this._runSpd : 0;
        this._flyWalkSpd = cha.isFlying() ? this._walkSpd : 0;
    }

    @Override
    protected final void writeImpl() {
        L2NpcTemplate polyObj;
        this.writeC(50);
        this.writeD(this._activeChar.getX());
        this.writeD(this._activeChar.getY());
        this.writeD(this._activeChar.getZ());
        this.writeD(this._activeChar.getVehicle() != null ? this._activeChar.getVehicle().getObjectId() : 0);
        this.writeD(this._activeChar.getObjectId());
        this.writeS(this._activeChar.getName());
        this.writeD(this._activeChar.getRace().ordinal());
        this.writeD(this._activeChar.getAppearance().getSex() ? 1 : 0);
        this.writeD(this._activeChar.getBaseClass());
        this.writeD(this._activeChar.getLevel());
        this.writeQ(this._activeChar.getExp());
        this.writeF((float)(this._activeChar.getExp() - ExperienceTable.getInstance().getExpForLevel(this._activeChar.getLevel())) / (float)(ExperienceTable.getInstance().getExpForLevel(this._activeChar.getLevel() + 1) - ExperienceTable.getInstance().getExpForLevel(this._activeChar.getLevel())));
        this.writeD(this._activeChar.getSTR());
        this.writeD(this._activeChar.getDEX());
        this.writeD(this._activeChar.getCON());
        this.writeD(this._activeChar.getINT());
        this.writeD(this._activeChar.getWIT());
        this.writeD(this._activeChar.getMEN());
        this.writeD(this._activeChar.getMaxHp());
        this.writeD((int)Math.round(this._activeChar.getCurrentHp()));
        this.writeD(this._activeChar.getMaxMp());
        this.writeD((int)Math.round(this._activeChar.getCurrentMp()));
        this.writeD(this._activeChar.getSp());
        this.writeD(this._activeChar.getCurrentLoad());
        this.writeD(this._activeChar.getMaxLoad());
        this.writeD(this._activeChar.getActiveWeaponItem() != null ? 40 : 20);
        for (int slot : this.getPaperdollOrder()) {
            this.writeD(this._activeChar.getInventory().getPaperdollObjectId(slot));
        }
        for (int slot : this.getPaperdollOrder()) {
            this.writeD(this._activeChar.getInventory().getPaperdollItemDisplayId(slot));
        }
        for (int slot : this.getPaperdollOrder()) {
            this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(slot));
        }
        this.writeD(this._activeChar.getInventory().getMaxTalismanCount());
        this.writeD(this._activeChar.getInventory().getCloakStatus());
        this.writeD(this._activeChar.getPAtk(null));
        this.writeD(this._activeChar.getPAtkSpd());
        this.writeD(this._activeChar.getPDef(null));
        this.writeD(this._activeChar.getEvasionRate(null));
        this.writeD(this._activeChar.getAccuracy());
        this.writeD(this._activeChar.getCriticalHit(null, null));
        this.writeD(this._activeChar.getMAtk(null, null));
        this.writeD(this._activeChar.getMAtkSpd());
        this.writeD(this._activeChar.getPAtkSpd());
        this.writeD(this._activeChar.getMDef(null, null));
        this.writeD(this._activeChar.getPvpFlag());
        this.writeD(this._activeChar.getKarma());
        this.writeD(this._runSpd);
        this.writeD(this._walkSpd);
        this.writeD(this._swimRunSpd);
        this.writeD(this._swimWalkSpd);
        this.writeD(0);
        this.writeD(0);
        this.writeD(this._flyRunSpd);
        this.writeD(this._flyWalkSpd);
        this.writeF(this._moveMultiplier);
        this.writeF(this._activeChar.getAttackSpeedMultiplier());
        this.writeF(this._activeChar.getCollisionRadius());
        this.writeF(this._activeChar.getCollisionHeight());
        this.writeD(this._activeChar.getAppearance().getHairStyle());
        this.writeD(this._activeChar.getAppearance().getHairColor());
        this.writeD(this._activeChar.getAppearance().getFace());
        this.writeD(this._activeChar.isGM() ? 1 : 0);
        String title = this._activeChar.getTitle();
        if (this._activeChar.getAppearance().getInvisible() && this._activeChar.canOverrideCond(PcCondOverride.SEE_ALL_PLAYERS)) {
            title = "Invisible";
        }
        if (this._activeChar.getPoly().isMorphed() && (polyObj = NpcTable.getInstance().getTemplate(this._activeChar.getPoly().getPolyId())) != null) {
            title = title + " - " + polyObj.getName();
        }
        this.writeS(title);
        this.writeD(this._activeChar.getClanId());
        this.writeD(this._activeChar.getClanCrestId());
        this.writeD(this._activeChar.getAllyId());
        this.writeD(this._activeChar.getAllyCrestId());
        this.writeD(this._relation);
        this.writeC(this._activeChar.getMountType().ordinal());
        this.writeC(this._activeChar.getPrivateStoreType().getId());
        this.writeC(this._activeChar.hasDwarvenCraft() ? 1 : 0);
        this.writeD(this._activeChar.getPkKills());
        this.writeD(this._activeChar.getPvpKills());
        this.writeH(this._activeChar.getCubics().size());
        for (L2CubicInstance cubic : this._activeChar.getCubics().values()) {
            this.writeH(cubic.getId());
        }
        this.writeC(this._activeChar.isInPartyMatchRoom() ? 1 : 0);
        this.writeD(this._activeChar.getAppearance().getInvisible() && this._activeChar.isGM() ? this._activeChar.getAbnormalVisualEffects() | AbnormalVisualEffect.STEALTH.getMask() : this._activeChar.getAbnormalVisualEffects());
        this.writeC(this._activeChar.isInsideZone(ZoneId.WATER) ? 1 : (this._activeChar.isFlyingMounted() ? 2 : 0));
        this.writeD(this._activeChar.getClanPrivileges().getBitmask());
        this.writeH(this._activeChar.getRecomLeft());
        this.writeH(this._activeChar.getRecomHave());
        this.writeD(this._activeChar.getMountNpcId() > 0 ? this._activeChar.getMountNpcId() + 1000000 : 0);
        this.writeH(this._activeChar.getInventoryLimit());
        this.writeD(this._activeChar.getClassId().getId());
        this.writeD(0);
        this.writeD(this._activeChar.getMaxCp());
        this.writeD((int)this._activeChar.getCurrentCp());
        this.writeC(this._activeChar.isMounted() || this._airShipHelm != 0 ? 0 : this._activeChar.getEnchantEffect());
        this.writeC(this._activeChar.getTeam().getId());
        this.writeD(this._activeChar.getClanCrestLargeId());
        this.writeC(this._activeChar.isNoble() ? 1 : 0);
        this.writeC(this._activeChar.isHero() || Config.GM_HERO_AURA && this._activeChar.isGM() || this._activeChar.aura ? 1 : 0);
        this.writeC(this._activeChar.isFishing() ? 1 : 0);
        this.writeD(this._activeChar.getFishx());
        this.writeD(this._activeChar.getFishy());
        this.writeD(this._activeChar.getFishz());
        this.writeD(this._activeChar.getAppearance().getNameColor());
        this.writeC(this._activeChar.isRunning() ? 1 : 0);
        this.writeD(this._activeChar.getPledgeClass());
        this.writeD(this._activeChar.getPledgeType());
        this.writeD(this._activeChar.getAppearance().getTitleColor());
        this.writeD(this._activeChar.isCursedWeaponEquipped() ? CursedWeaponsManager.getInstance().getLevel(this._activeChar.getCursedWeaponEquippedId()) : 0);
        this.writeD(this._activeChar.getTransformationDisplayId());
        byte attackAttribute = this._activeChar.getAttackElement();
        this.writeH(attackAttribute);
        this.writeH(this._activeChar.getAttackElementValue(attackAttribute));
        this.writeH(this._activeChar.getDefenseElementValue((byte)0));
        this.writeH(this._activeChar.getDefenseElementValue((byte)1));
        this.writeH(this._activeChar.getDefenseElementValue((byte)2));
        this.writeH(this._activeChar.getDefenseElementValue((byte)3));
        this.writeH(this._activeChar.getDefenseElementValue((byte)4));
        this.writeH(this._activeChar.getDefenseElementValue((byte)5));
        this.writeD(this._activeChar.getAgathionId());
        this.writeD(this._activeChar.getFame());
        this.writeD(this._activeChar.isMinimapAllowed() ? 1 : 0);
        this.writeD(this._activeChar.getVitalityPoints());
        this.writeD(this._activeChar.getAbnormalVisualEffectSpecial());
    }
}

