/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2ServitorInstance;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class PetInfo
extends L2GameServerPacket {
    private final L2Summon _summon;
    private final int _x;
    private final int _y;
    private final int _z;
    private final int _heading;
    private final boolean _isSummoned;
    private final int _val;
    private final int _mAtkSpd;
    private final int _pAtkSpd;
    private final int _runSpd;
    private final int _walkSpd;
    private final int _swimRunSpd;
    private final int _swimWalkSpd;
    private final int _flRunSpd = 0;
    private final int _flWalkSpd = 0;
    private final int _flyRunSpd;
    private final int _flyWalkSpd;
    private final float _moveMultiplier;
    private final int _maxHp;
    private final int _maxMp;
    private int _maxFed;
    private int _curFed;

    public PetInfo(L2Summon summon, int val) {
        this._summon = summon;
        this._isSummoned = summon.isShowSummonAnimation();
        this._x = summon.getX();
        this._y = summon.getY();
        this._z = summon.getZ();
        this._heading = summon.getHeading();
        this._mAtkSpd = summon.getMAtkSpd();
        this._pAtkSpd = summon.getPAtkSpd();
        this._moveMultiplier = summon.getMovementSpeedMultiplier();
        this._runSpd = Math.round((float)summon.getRunSpeed() / this._moveMultiplier);
        this._walkSpd = Math.round((float)summon.getWalkSpeed() / this._moveMultiplier);
        this._swimRunSpd = Math.round((float)summon.getSwimRunSpeed() / this._moveMultiplier);
        this._swimWalkSpd = Math.round((float)summon.getSwimWalkSpeed() / this._moveMultiplier);
        this._flyRunSpd = summon.isFlying() ? this._runSpd : 0;
        this._flyWalkSpd = summon.isFlying() ? this._walkSpd : 0;
        this._maxHp = summon.getMaxHp();
        this._maxMp = summon.getMaxMp();
        this._val = val;
        if (summon.isPet()) {
            L2PetInstance pet = (L2PetInstance)summon;
            this._curFed = pet.getCurrentFed();
            this._maxFed = pet.getMaxFed();
        } else if (summon.isServitor()) {
            L2ServitorInstance sum = (L2ServitorInstance)this._summon;
            this._curFed = sum.getTimeRemaining();
            this._maxFed = sum.getTotalLifeTime();
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(178);
        this.writeD(this._summon.getSummonType());
        this.writeD(this._summon.getObjectId());
        this.writeD(this._summon.getTemplate().getIdTemplate() + 1000000);
        this.writeD(0);
        this.writeD(this._x);
        this.writeD(this._y);
        this.writeD(this._z);
        this.writeD(this._heading);
        this.writeD(0);
        this.writeD(this._mAtkSpd);
        this.writeD(this._pAtkSpd);
        this.writeD(this._runSpd);
        this.writeD(this._walkSpd);
        this.writeD(this._swimRunSpd);
        this.writeD(this._swimWalkSpd);
        this.writeD(0);
        this.writeD(0);
        this.writeD(this._flyRunSpd);
        this.writeD(this._flyWalkSpd);
        this.writeF(this._moveMultiplier);
        this.writeF(this._summon.getAttackSpeedMultiplier());
        this.writeF(this._summon.getTemplate().getfCollisionRadius());
        this.writeF(this._summon.getTemplate().getfCollisionHeight());
        this.writeD(this._summon.getWeapon());
        this.writeD(this._summon.getArmor());
        this.writeD(0);
        this.writeC(this._summon.getOwner() != null ? 1 : 0);
        this.writeC(this._summon.isRunning() ? 1 : 0);
        this.writeC(this._summon.isInCombat() ? 1 : 0);
        this.writeC(this._summon.isAlikeDead() ? 1 : 0);
        this.writeC(this._isSummoned ? 2 : this._val);
        this.writeD(-1);
        if (this._summon instanceof L2PetInstance) {
            this.writeS(this._summon.getName());
        } else {
            this.writeS(this._summon.getTemplate().isServerSideName() ? this._summon.getName() : "");
        }
        this.writeD(-1);
        this.writeS(this._summon.getTitle());
        this.writeD(1);
        this.writeD(this._summon.getPvpFlag());
        this.writeD(this._summon.getKarma());
        this.writeD(this._curFed);
        this.writeD(this._maxFed);
        this.writeD((int)this._summon.getCurrentHp());
        this.writeD(this._maxHp);
        this.writeD((int)this._summon.getCurrentMp());
        this.writeD(this._maxMp);
        this.writeD(this._summon.getStat().getSp());
        this.writeD(this._summon.getLevel());
        this.writeQ(this._summon.getStat().getExp());
        if (this._summon.getExpForThisLevel() > this._summon.getStat().getExp()) {
            this.writeQ(this._summon.getStat().getExp());
        } else {
            this.writeQ(this._summon.getExpForThisLevel());
        }
        this.writeQ(this._summon.getExpForNextLevel());
        this.writeD(this._summon instanceof L2PetInstance ? this._summon.getInventory().getTotalWeight() : 0);
        this.writeD(this._summon.getMaxLoad());
        this.writeD(this._summon.getPAtk(null));
        this.writeD(this._summon.getPDef(null));
        this.writeD(this._summon.getMAtk(null, null));
        this.writeD(this._summon.getMDef(null, null));
        this.writeD(this._summon.getAccuracy());
        this.writeD(this._summon.getEvasionRate(null));
        this.writeD(this._summon.getCriticalHit(null, null));
        this.writeD((int)this._summon.getStat().getMoveSpeed());
        this.writeD(this._summon.getPAtkSpd());
        this.writeD(this._summon.getMAtkSpd());
        this.writeD(this._summon.getAbnormalVisualEffects());
        this.writeH(this._summon.isMountable() ? 1 : 0);
        this.writeC(this._summon.isInsideZone(ZoneId.WATER) ? 1 : (this._summon.isFlying() ? 2 : 0));
        this.writeH(0);
        this.writeC(this._summon.getTeam().getId());
        this.writeD(this._summon.getSoulShotsPerHit());
        this.writeD(this._summon.getSpiritShotsPerHit());
        int form = 0;
        int npcId = this._summon.getId();
        if (npcId == 16041 || npcId == 16042) {
            if (this._summon.getLevel() > 69) {
                form = 3;
            } else if (this._summon.getLevel() > 64) {
                form = 2;
            } else if (this._summon.getLevel() > 59) {
                form = 1;
            }
        } else if (npcId == 16025 || npcId == 16037) {
            if (this._summon.getLevel() > 69) {
                form = 3;
            } else if (this._summon.getLevel() > 64) {
                form = 2;
            } else if (this._summon.getLevel() > 59) {
                form = 1;
            }
        }
        this.writeD(form);
        this.writeD(this._summon.getAbnormalVisualEffectSpecial());
    }
}

