/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.enums.HtmlActionScope;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.network.serverpackets.AbstractHtmlPacket;

public final class NpcHtmlMessage
extends AbstractHtmlPacket {
    private final int _itemId;

    public NpcHtmlMessage() {
        this._itemId = 0;
    }

    public NpcHtmlMessage(L2Npc npc) {
        super(npc.getObjectId());
        this._itemId = 0;
    }

    public NpcHtmlMessage(int npcObjId) {
        super(npcObjId);
        this._itemId = 0;
    }

    public NpcHtmlMessage(String html) {
        super(html);
        this._itemId = 0;
    }

    public NpcHtmlMessage(L2Npc npc, String html) {
        super(npc.getObjectId(), html);
        this._itemId = 0;
    }

    public NpcHtmlMessage(int npcObjId, String html) {
        super(npcObjId, html);
        this._itemId = 0;
    }

    public NpcHtmlMessage(int npcObjId, int itemId) {
        super(npcObjId);
        if (itemId < 0) {
            throw new IllegalArgumentException();
        }
        this._itemId = itemId;
    }

    public NpcHtmlMessage(int npcObjId, int itemId, String html) {
        super(npcObjId, html);
        if (itemId < 0) {
            throw new IllegalArgumentException();
        }
        this._itemId = itemId;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(25);
        this.writeD(this.getNpcObjId());
        this.writeS(this.getHtml());
        this.writeD(this._itemId);
    }

    @Override
    public HtmlActionScope getScope() {
        return this._itemId == 0 ? HtmlActionScope.NPC_HTML : HtmlActionScope.NPC_ITEM_HTML;
    }
}

