/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.multisell.Entry;
import com.l2jserver.gameserver.model.multisell.Ingredient;
import com.l2jserver.gameserver.model.multisell.ListContainer;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public final class MultiSellList
extends L2GameServerPacket {
    private int _size;
    private int _index;
    private final ListContainer _list;
    private final boolean _finished;

    public MultiSellList(ListContainer list, int index) {
        this._list = list;
        this._index = index;
        this._size = list.getEntries().size() - index;
        if (this._size > 40) {
            this._finished = false;
            this._size = 40;
        } else {
            this._finished = true;
        }
    }

    @Override
    protected void writeImpl() {
        this.writeC(208);
        this.writeD(this._list.getListId());
        this.writeD(1 + this._index / 40);
        this.writeD(this._finished ? 1 : 0);
        this.writeD(40);
        this.writeD(this._size);
        while (this._size-- > 0) {
            Entry ent = this._list.getEntries().get(this._index++);
            this.writeD(ent.getEntryId());
            this.writeC(ent.isStackable() ? 1 : 0);
            this.writeH(0);
            this.writeD(0);
            this.writeD(0);
            this.writeH(65534);
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
            this.writeH(ent.getProducts().size());
            this.writeH(ent.getIngredients().size());
            for (Ingredient ing : ent.getProducts()) {
                this.writeD(ing.getItemId());
                if (ing.getTemplate() != null) {
                    this.writeD(ing.getTemplate().getBodyPart());
                    this.writeH(ing.getTemplate().getType2());
                } else {
                    this.writeD(0);
                    this.writeH(65535);
                }
                this.writeQ(ing.getItemCount());
                if (ing.getItemInfo() != null) {
                    this.writeH(ing.getItemInfo().getEnchantLevel());
                    this.writeD(ing.getItemInfo().getAugmentId());
                    this.writeD(0);
                    this.writeH(ing.getItemInfo().getElementId());
                    this.writeH(ing.getItemInfo().getElementPower());
                    this.writeH(ing.getItemInfo().getElementals()[0]);
                    this.writeH(ing.getItemInfo().getElementals()[1]);
                    this.writeH(ing.getItemInfo().getElementals()[2]);
                    this.writeH(ing.getItemInfo().getElementals()[3]);
                    this.writeH(ing.getItemInfo().getElementals()[4]);
                    this.writeH(ing.getItemInfo().getElementals()[5]);
                    continue;
                }
                this.writeH(0);
                this.writeD(0);
                this.writeD(0);
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
            }
            for (Ingredient ing : ent.getIngredients()) {
                this.writeD(ing.getItemId());
                this.writeH(ing.getTemplate() != null ? ing.getTemplate().getType2() : 65535);
                this.writeQ(ing.getItemCount());
                if (ing.getItemInfo() != null) {
                    this.writeH(ing.getItemInfo().getEnchantLevel());
                    this.writeD(ing.getItemInfo().getAugmentId());
                    this.writeD(0);
                    this.writeH(ing.getItemInfo().getElementId());
                    this.writeH(ing.getItemInfo().getElementPower());
                    this.writeH(ing.getItemInfo().getElementals()[0]);
                    this.writeH(ing.getItemInfo().getElementals()[1]);
                    this.writeH(ing.getItemInfo().getElementals()[2]);
                    this.writeH(ing.getItemInfo().getElementals()[3]);
                    this.writeH(ing.getItemInfo().getElementals()[4]);
                    this.writeH(ing.getItemInfo().getElementals()[5]);
                    continue;
                }
                this.writeH(0);
                this.writeD(0);
                this.writeD(0);
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
            }
        }
    }
}

